/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.integration.server.bean;

import bitel.billing.server.contract.bean.find.SearchContract;
import bitel.billing.server.contract.bean.find.SearchContracts;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.integration.server.bean.RegisterLoadPattern;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class RegisterLoadPatternManager {
    private static final Logger log = LogManager.getLogger();
    private Setup setup;

    public RegisterLoadPatternManager(Setup setup) {
        this.setup = setup;
    }

    public List<RegisterLoadPattern> getLoadPatterns(int regType) throws BGMessageException {
        return this.getPatterns(regType);
    }

    private List<RegisterLoadPattern> getPatterns(int registerType) throws BGMessageException {
        ArrayList<RegisterLoadPattern> result = new ArrayList<RegisterLoadPattern>();
        String prefix = registerType == 1 ? "charge.load.pattern." : "payment.load.pattern.";
        Set keys = Utils.toSet((String)this.setup.get(prefix + "keys", "")).stream().map(e -> e.trim()).collect(Collectors.toSet());
        if (keys.isEmpty()) {
            int id = 0;
            while (this.setup.get(prefix + ++id, null) != null) {
                keys.add(String.valueOf(id));
            }
        }
        for (String key : keys) {
            try {
                int positionDate;
                String idPos;
                String title = this.setup.get(prefix + key, "");
                String typeStr = registerType == 1 ? ".charge_type" : ".payment_type";
                String[] balanceItemTypes = this.setup.get(prefix + key + typeStr, "").split(",");
                int type = this.setup.getInt(prefix + key + ".type", 1);
                RegisterLoadPattern registerPattern = new RegisterLoadPattern(key, title, type, balanceItemTypes, registerType);
                registerPattern.setPatternTitle(this.setup.get(prefix + key, null));
                registerPattern.setHandlerClassName(this.setup.get(prefix + key + ".handler_class", null));
                String patternStr = this.setup.get(prefix + key + ".regexp", null);
                if (Utils.notBlankString((String)patternStr)) {
                    registerPattern.setPattern(Pattern.compile(patternStr));
                }
                registerPattern.setSummaPos(this.setup.get(prefix + key + ".position_sum", "").split(","));
                registerPattern.setCommentPositions(Utils.toList((String)this.setup.get(prefix + key + ".position_comment", "")).toArray(new String[0]));
                registerPattern.setCommentDelimiter(this.setup.get(prefix + key + ".comment_delimiter", " "));
                HashMap<Integer, String> extraParametersMap = new HashMap<Integer, String>();
                String extraPositions = this.setup.get(prefix + key + ".extra");
                if (extraPositions != null) {
                    String[] extra = extraPositions.split(";");
                    for (int i = 0; i < extra.length; ++i) {
                        int position;
                        String parameter = extra[i];
                        if (!parameter.contains(":") || (position = Utils.parseInt((String)parameter.substring(0, parameter.indexOf(":")), (int)-1)) <= 0) continue;
                        String keyOfExtraParameter = parameter.substring(parameter.indexOf(":") + 1, parameter.length());
                        extraParametersMap.put(position, keyOfExtraParameter);
                    }
                    registerPattern.setExtraParametersMap(extraParametersMap);
                }
                if (Utils.parseInt((String)(idPos = this.setup.get(prefix + key + ".position_id", null))) > 0) {
                    registerPattern.setIdPos(Utils.parseInt((String)idPos));
                }
                if ((positionDate = this.setup.getInt(prefix + key + ".position_date", 0)) > 0) {
                    registerPattern.setDatePos(positionDate);
                    try {
                        registerPattern.setDateFormat(new SimpleDateFormat(this.setup.get(prefix + key + ".date_format", null)));
                    }
                    catch (Exception e2) {
                        throw new BGException("date format parse error");
                    }
                }
                HashMap<String, String> params = new HashMap<String, String>();
                for (Map.Entry entry : this.setup.sub(prefix + key + ".search.").entrySet()) {
                    params.put((String)entry.getKey(), (String)entry.getValue());
                }
                SearchContracts searches = new SearchContracts(params);
                boolean none = true;
                for (SearchContract s : searches.searchContracts) {
                    if (s.pos == 0) continue;
                    none = false;
                    break;
                }
                if (none) {
                    throw new Exception("\u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u043f\u043e\u0438\u0441\u043a\u043e\u0432\u0430\u044f(\u044b\u0435) \u043f\u043e\u0437\u0438\u0446\u0438\u044f(\u0438)");
                }
                registerPattern.setSearchContracts(searches);
                registerPattern.setEncoding(this.setup.get(prefix + key + ".encoding", "UTF-8"));
                registerPattern.setSummaReplace(this.setup.get(prefix + key + ".summa.replace", null));
                registerPattern.setZeroEncoding(this.setup.getInt(prefix + key + ".encoding.clear", 1) > 0);
                result.add(registerPattern);
            }
            catch (Exception ex) {
                log.error("error loading " + (registerType == 1 ? "charge" : "payment") + " load pattern: " + ex.getMessage());
                throw new BGMessageException("\u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432 [" + prefix + key + "] => " + ex.getMessage());
            }
        }
        return result;
    }

    public Map<String, RegisterLoadPattern> getLoadPatternMap() throws BGMessageException {
        HashMap<String, RegisterLoadPattern> result = new HashMap<String, RegisterLoadPattern>();
        for (RegisterLoadPattern pattern : this.getLoadPatterns(0)) {
            result.put(pattern.getKey(), pattern);
        }
        return result;
    }

    public RegisterLoadPattern getLoadPatternByKey(String key, int registerType) throws BGMessageException {
        for (RegisterLoadPattern pattern : this.getLoadPatterns(registerType)) {
            if (!pattern.getKey().equals(key)) continue;
            return pattern;
        }
        return null;
    }
}

