/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.datalog.hourly;

import bitel.billing.server.admin.errorlog.AlarmSender;
import bitel.billing.server.admin.errorlog.bean.AlarmErrorMessage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Calendar;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.server.datalog.BGDataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLogReader;
import ru.bitel.bgbilling.kernel.base.server.datalog.ReadableDataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.hourly.HourlyDataLog;
import ru.bitel.bgbilling.kernel.network.datalog.FlowReader;
import ru.bitel.bgbilling.kernel.network.datalog.IPDataLog;
import ru.bitel.bgbilling.kernel.network.datalog.flowtools.FlowToolsLog;
import ru.bitel.bgbilling.kernel.network.datalog.v1.OldDataLog;
import ru.bitel.common.ParameterMap;

public class IPHourlyDataLog
extends HourlyDataLog<ReadableDataLog<? extends DataLogReader<?>>, DataLogReader<?>, FlowReader> {
    private static final Logger log = LogManager.getLogger();

    public IPHourlyDataLog(ParameterMap setup, int sourceId, Calendar hour) {
        this(setup, "log.dir", sourceId, hour);
    }

    public IPHourlyDataLog(ParameterMap setup, String key, int sourceId, Calendar hour) {
        super(IPHourlyDataLog.path(setup, sourceId, key), hour);
    }

    public IPHourlyDataLog(File path, Calendar hour) {
        super(path, hour);
    }

    @Override
    protected ReadableDataLog<? extends DataLogReader<?>> newDataLog(File file) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Opening " + file.getAbsolutePath());
        }
        ByteBuffer readBuffer = ByteBuffer.wrap(new byte[8]);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        FileChannel fileChannel = randomAccessFile.getChannel();
        fileChannel.read(readBuffer);
        readBuffer.flip();
        if (!readBuffer.hasRemaining()) {
            log.warn("Datalog file with size=0 " + file.getAbsolutePath());
            fileChannel.close();
            randomAccessFile.close();
            return null;
        }
        if (readBuffer.getInt(0) == BGDataLog.MAGIC) {
            fileChannel.position(0L);
            return new IPDataLog(0, file, randomAccessFile, fileChannel);
        }
        if (readBuffer.getShort(0) == FlowToolsLog.magic) {
            fileChannel.position(0L);
            return new FlowToolsLog(file, randomAccessFile, fileChannel);
        }
        if (readBuffer.getInt(0) == 0 && readBuffer.getInt(4) == 0 && !Pattern.matches("^log_\\d\\d$", file.getName())) {
            log.warn("Datalog file with header=0x00000000 " + file.getAbsolutePath());
            String key = "collector.datalog.error";
            long time = System.currentTimeMillis();
            try {
                if (AlarmSender.needAlarmSend(key, time, 300000L)) {
                    String message = "\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0435\u043d\u043d\u044b\u0439 \u043b\u043e\u0433-\u0444\u0430\u0439\u043b. \u041f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0444\u0430\u0439\u043b \u0431\u0443\u0434\u0435\u0442 \u043f\u0440\u043e\u043f\u0443\u0449\u0435\u043d:\n" + file.getAbsolutePath();
                    AlarmSender.sendAlarm(new AlarmErrorMessage(key, "IPNCollector: \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0435\u043d\u043d\u044b\u0439 \u043b\u043e\u0433-\u0444\u0430\u0439\u043b", message), time);
                }
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
            }
            fileChannel.close();
            randomAccessFile.close();
            return null;
        }
        fileChannel.position(0L);
        return new OldDataLog(file, randomAccessFile, fileChannel, this.hour);
    }

    @Override
    protected final FlowReader reader(DataLogReader<?> r) {
        return (FlowReader)((Object)r);
    }
}

