/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.datalog.snmp;

import bitel.billing.server.admin.errorlog.AlarmSender;
import bitel.billing.server.admin.errorlog.bean.AlarmErrorMessage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.network.datalog.FlowReader;
import ru.bitel.bgbilling.kernel.network.datalog.IPDataLogWriter;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLog;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLogEntry;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLogger;
import ru.bitel.bgbilling.kernel.network.datalog.snmp.SnmpFlowArray;
import ru.bitel.bgbilling.kernel.network.flow.SnmpFlowRecord;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;
import ru.bitel.common.worker.WorkerTask;
import uk.co.westhawk.snmp.pdu.BlockPdu;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnObjectId;
import uk.co.westhawk.snmp.stack.AsnUnsInteger;
import uk.co.westhawk.snmp.stack.AsnUnsInteger64;
import uk.co.westhawk.snmp.stack.GetNextPdu;
import uk.co.westhawk.snmp.stack.GetPdu;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContext;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;
import uk.co.westhawk.snmp.stack.SnmpContextv2c;
import uk.co.westhawk.snmp.stack.varbind;

public abstract class SnmpWorker
extends WorkerTask<ServerContext>
implements Runnable {
    private static final Logger log = LogManager.getLogger();
    protected final Setup setup;
    protected final int moduleId;
    private final IPHourlyDataLogger dataLogger;
    protected final WeakHashMap<IPHourlyDataLogEntry, IPDataLogWriter> writerMap = new WeakHashMap();
    protected final Map<Integer, SnmpFlowArray> flowArray = new HashMap<Integer, SnmpFlowArray>();
    private Map<Integer, Long> nextHourMap = new HashMap<Integer, Long>();
    public static final int POS_UPTIME_OID = 0;
    public static final int POS_IFINDEX_OID = 1;
    public static final int POS_IN_OCTETS_OID = 2;
    public static final int POS_OUT_OCTETS_OID = 3;
    private static final long[] UPTIME_OID = new long[]{1L, 3L, 6L, 1L, 2L, 1L, 1L, 3L, 0L};
    private static final List<long[][]> defaultQuery = new ArrayList<long[][]>();
    protected final String sourceKey;
    protected final boolean async;

    private static final long getNextHour(long millis) {
        GregorianCalendar lastHour = new GregorianCalendar();
        lastHour.setTimeInMillis(millis);
        lastHour.set(12, 0);
        lastHour.set(13, 0);
        lastHour.set(14, 0);
        ((Calendar)lastHour).add(11, 1);
        return lastHour.getTimeInMillis();
    }

    public SnmpWorker(Setup setup, int moduleId, IPHourlyDataLogger dataLogger) {
        this(setup, moduleId, dataLogger, "log.dir", true);
    }

    public SnmpWorker(Setup setup, int moduleId, IPHourlyDataLogger dataLogger, String sourceKey, boolean async) {
        this.setup = setup;
        this.moduleId = moduleId;
        this.dataLogger = dataLogger;
        this.async = async;
        this.sourceKey = sourceKey;
    }

    protected List<long[][]> getQuery(Id source) {
        return defaultQuery;
    }

    protected final void runImpl() {
        BGNestedContext.push((String)"flowListener");
        try {
            this.runImpl0();
        }
        finally {
            BGNestedContext.pop();
        }
    }

    protected void processSource(Id source, String host, int port, String secret, ParameterMap config, List<Long> ifaceList) {
        block15: {
            Object context = null;
            try {
                Long prevIface;
                ConcurrentLinkedQueue<Long> sourceIfaces;
                List<Long> sourceIfaceList;
                boolean useIfIndex;
                port = config.getInt("snmp.port", port);
                if (port <= 0) {
                    port = 161;
                }
                String version = config.get("snmp.version", "1");
                host = config.get("snmp.host", host);
                secret = config.get("snmp.secret", secret);
                context = version.equals("2") || version.equals("2c") ? new SnmpContextv2c(host, port, "UDP") : new SnmpContext(host, port, "UDP");
                context.setCommunity(Utils.notBlankString((String)secret) ? secret : "public");
                if (log.isDebugEnabled()) {
                    log.debug("Sending requests for " + source.getId() + " [" + source.toString() + "] port " + port + " version " + version);
                }
                List<long[][]> query = this.getQuery(source);
                boolean collectAll = config.getInt("snmp.source.collectAll", 1) > 0;
                boolean bl = useIfIndex = config.getInt("snmp.source.useIfIndex", 1) > 0;
                if (collectAll && query.get(2)[1] == null && query.get(3)[1] == null && useIfIndex) {
                    sourceIfaceList = null;
                    sourceIfaces = null;
                    prevIface = -1L;
                } else {
                    log.debug("Collecting only exist in DB ifaces");
                    sourceIfaceList = ifaceList;
                    if (sourceIfaceList != null && sourceIfaceList.size() > 0) {
                        sourceIfaces = new ConcurrentLinkedQueue<Long>(sourceIfaceList);
                        prevIface = (Long)sourceIfaces.poll();
                        if (prevIface != null) {
                            // empty if block
                        }
                    } else {
                        context.destroy();
                        return;
                    }
                }
                varbind[] parent = new varbind[query.size()];
                int size = query.size();
                for (int i = 0; i < size; ++i) {
                    parent[i] = new varbind(new AsnObjectId(query.get(i)[0]));
                }
                if (this.async) {
                    this.examineNext(source, useIfIndex, (SnmpContext)context, parent, sourceIfaceList, sourceIfaces, prevIface);
                } else {
                    this.examineSync(source, useIfIndex, (SnmpContext)context, parent, sourceIfaceList, sourceIfaces, prevIface);
                }
            }
            catch (IOException e) {
                if (context != null && !context.isDestroyed()) {
                    context.destroy();
                }
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (PduException e) {
                if (context != null && !context.isDestroyed()) {
                    context.destroy();
                }
                log.error(e.getMessage(), (Throwable)e);
                long time = System.currentTimeMillis();
                String key = "snmp.source.error";
                if (!AlarmSender.needAlarmSend(key, time, 300000L)) break block15;
                String text = "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u0431\u043e\u0440\u0435 \u043b\u043e\u0433\u043e\u0432 \u0441 SNMP \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \"" + source.toString() + "\". \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u043d\u0435\u0432\u0435\u0440\u043d\u043e \u0441\u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0438\u0440\u043e\u0432\u0430\u043d. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 snmp.port\n\n\u0422\u0435\u043a\u0441\u0442 \u043e\u0448\u0438\u0431\u043a\u0438: " + e.getMessage();
                AlarmSender.sendAlarm(new AlarmErrorMessage(key, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0431\u043e\u0440\u0430 \u043b\u043e\u0433\u043e\u0432 \u0441 SNMP-\u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430", text), time);
            }
        }
    }

    protected abstract void runImpl0();

    protected void processFlow(Id source, long iface, SnmpFlowArray flowArray, long millis, Long hour) {
    }

    private void reload(Id source, Map<Integer, SnmpFlowRecord> lastSnmp, Calendar hour) {
        log.info("Reloading last snmp messages for source " + source.getId() + " [" + source.toString() + "] from " + TimeUtils.format((Calendar)hour, (String)"dd.MM.yyyy HH:00:00"));
        for (int i = 24; i > 0; --i) {
            IPHourlyDataLog dataLog = new IPHourlyDataLog((ParameterMap)this.setup, this.sourceKey, source.getId(), hour);
            boolean result = false;
            try {
                FlowReader reader;
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put(" ru.bitel.bgbilling.server.util.ip.datalog.snmp.SnmpDataLogReader.LAST_SNMP", lastSnmp);
                while ((reader = (FlowReader)dataLog.nextReader(params, false)) != null) {
                    result = true;
                    while (reader.readChunk() != null) {
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            if (result) break;
            hour.add(11, -1);
        }
        log.info("End reloading last snmp messages for source " + source.getId() + " [" + source.toString() + "] from " + TimeUtils.format((Calendar)hour, (String)"dd.MM.yyyy HH:00:00"));
    }

    public int getValue(AsnObject value) {
        int intValue;
        Class<?> clazz = value.getClass();
        if (clazz == AsnInteger.class) {
            int val;
            intValue = val = ((AsnInteger)value).getValue();
        } else if (clazz == AsnUnsInteger.class) {
            long val = ((AsnUnsInteger)value).getValue();
            intValue = (int)(val & 0xFFFFFFFFL);
        } else if (clazz == AsnUnsInteger64.class) {
            long val = ((AsnUnsInteger64)value).getValue();
            intValue = (int)(val & 0xFFFFFFFFL);
        } else {
            intValue = 0;
            log.error("Unknown value type: " + clazz.getName());
        }
        return intValue;
    }

    private AsnObjectId getAsnObjectId(long[] oid, long iface) {
        long[] o = Arrays.copyOf(oid, oid.length + 1);
        o[o.length - 1] = iface;
        return new AsnObjectId(o);
    }

    private AsnObjectId getAsnObjectId(long[] oid, long iface, long[] suffix) {
        if (suffix == null || suffix.length == 0) {
            return this.getAsnObjectId(oid, iface);
        }
        long[] o = Arrays.copyOf(oid, oid.length + 1 + suffix.length);
        o[oid.length] = iface;
        System.arraycopy(suffix, 0, o, oid.length + 1, suffix.length);
        return new AsnObjectId(o);
    }

    private void examineNext(Id source, boolean useIfIndex, SnmpContext context, varbind[] parent, List<Long> sourceIfaceList, Queue<Long> sourceIfaces, Long prevIface) throws IOException, PduException {
        List<long[][]> queryLong = this.getQuery(source);
        varbind[] query = new varbind[queryLong.size()];
        query[0] = sourceIfaces == null ? new varbind(new AsnObjectId(queryLong.get(0)[0])) : new varbind(new AsnObjectId(UPTIME_OID));
        int size = queryLong.size();
        for (int i = 1; i < size; ++i) {
            long[][] q = queryLong.get(i);
            query[i] = prevIface == -1L ? new varbind(new AsnObjectId(q[0])) : new varbind(this.getAsnObjectId(q[0], prevIface, q[1]));
        }
        if (sourceIfaces == null) {
            GetNextPdu getPdu = new GetNextPdu((SnmpContextBasisFace)context);
            int size2 = query.length;
            for (i = 0; i < size2; ++i) {
                getPdu.addOid(query[i]);
            }
            getPdu.addObserver((Observer)new RequestObserver(source, context, parent, sourceIfaceList, sourceIfaces, prevIface, useIfIndex));
            getPdu.send();
        } else {
            GetPdu getPdu = new GetPdu((SnmpContextBasisFace)context);
            int size3 = query.length;
            for (i = 0; i < size3; ++i) {
                getPdu.addOid(query[i]);
            }
            getPdu.addObserver((Observer)new RequestObserver(source, context, parent, sourceIfaceList, sourceIfaces, prevIface, useIfIndex));
            getPdu.send();
        }
    }

    private void examineSync(Id source, boolean useIfIndex, SnmpContext context, varbind[] parent, List<Long> sourceIfaceList, Queue<Long> sourceIfaces, Long iface) throws IOException, PduException {
        while (iface != null) {
            iface = this.examineNextSync0(source, useIfIndex, context, parent, sourceIfaceList, sourceIfaces, iface);
        }
    }

    private Long examineNextSync0(Id source, boolean useIfIndex, SnmpContext context, varbind[] parent, List<Long> sourceIfaceList, Queue<Long> sourceIfaces, Long prevIface) throws IOException, PduException {
        List<long[][]> queryLong = this.getQuery(source);
        varbind[] query = new varbind[queryLong.size()];
        query[0] = sourceIfaces == null ? new varbind(new AsnObjectId(queryLong.get(0)[0])) : new varbind(new AsnObjectId(UPTIME_OID));
        int size = queryLong.size();
        for (int i = 1; i < size; ++i) {
            long[][] q = queryLong.get(i);
            query[i] = prevIface == -1L ? new varbind(new AsnObjectId(q[0])) : new varbind(this.getAsnObjectId(q[0], prevIface, q[1]));
        }
        BlockPdu getPdu = new BlockPdu((SnmpContextBasisFace)context);
        getPdu.setPduType(sourceIfaces == null ? 2 : 0);
        int size2 = query.length;
        for (int i = 0; i < size2; ++i) {
            getPdu.addOid(query[i]);
        }
        varbind[] varbind2 = getPdu.getResponseVariableBindings();
        return new RequestObserver(source, context, parent, sourceIfaceList, sourceIfaces, prevIface, useIfIndex).update(getPdu, varbind2);
    }

    static {
        defaultQuery.add(0, new long[][]{{1L, 3L, 6L, 1L, 2L, 1L, 1L, 3L}, null});
        defaultQuery.add(1, new long[][]{{1L, 3L, 6L, 1L, 2L, 1L, 2L, 2L, 1L, 1L}, null});
        defaultQuery.add(2, new long[][]{{1L, 3L, 6L, 1L, 2L, 1L, 2L, 2L, 1L, 10L}, null});
        defaultQuery.add(3, new long[][]{{1L, 3L, 6L, 1L, 2L, 1L, 2L, 2L, 1L, 16L}, null});
    }

    private class RequestObserver
    implements Observer {
        private final Id source;
        private final SnmpContext context;
        private final varbind[] parent;
        private final List<Long> sourceIfaceList;
        private final Queue<Long> sourceIfaces;
        private final boolean useIfIndex;
        private final Long iface;

        public RequestObserver(Id source, SnmpContext context, varbind[] parent, List<Long> sourceIfaceList, Queue<Long> sourceIfaces, Long iface, boolean useIfIndex) {
            this.source = source;
            this.context = context;
            this.parent = parent;
            this.sourceIfaceList = sourceIfaceList;
            this.sourceIfaces = sourceIfaces;
            this.iface = iface;
            this.useIfIndex = useIfIndex;
        }

        @Override
        public void update(Observable obs, Object arg) {
            Pdu pdu = (Pdu)obs;
            int errorStatus = pdu.getErrorStatus();
            if (errorStatus == 0) {
                try {
                    varbind[] vars = pdu.getResponseVarbinds();
                    this.update(vars, errorStatus, pdu);
                }
                catch (PduException e) {
                    this.context.destroy();
                    log.error("update(): PduException " + e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    this.context.destroy();
                    log.error("update(): Exception " + e.getMessage(), (Throwable)e);
                }
            } else {
                this.context.destroy();
                if (errorStatus == 5) {
                    log.error("The value of an object cannot be retrieved for reasons not covered by any of other errors. Community error or snmp agent not available?\n" + pdu.toString());
                } else if (errorStatus == 2) {
                    log.error("The object is not available or the object's name does not exactly match.\n" + pdu.toString());
                } else {
                    log.error("Snmp status: ---- " + errorStatus);
                }
            }
        }

        public Long update(BlockPdu pdu, varbind[] vars) {
            block8: {
                int errorStatus = pdu.getErrorStatus();
                if (errorStatus == 0) {
                    try {
                        return this.update(vars, errorStatus, pdu);
                    }
                    catch (PduException e) {
                        this.context.destroy();
                        log.error("update(): PduException " + e.getMessage(), (Throwable)e);
                        break block8;
                    }
                    catch (Exception e) {
                        this.context.destroy();
                        log.error("update(): Exception " + e.getMessage(), (Throwable)e);
                        break block8;
                    }
                }
                this.context.destroy();
                if (errorStatus == 5) {
                    log.error("The value of an object cannot be retrieved for reasons not covered by any of other errors. Community error or snmp agent not available?\n" + pdu.toString());
                } else if (errorStatus == 2) {
                    log.error("The object is not available or the object's name does not exactly match.\n" + pdu.toString());
                } else {
                    log.error("Snmp status: ---- " + errorStatus);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Long update(varbind[] vars, int errorStatus, Object pdu) throws IOException, PduException {
            Long sourceIface;
            if (log.isDebugEnabled()) {
                log.debug("Recieve answer from " + this.source.getId() + " [" + this.source.toString() + "]");
            }
            long now = System.currentTimeMillis();
            if (vars.length < 4) {
                log.info("Break query by vars length.");
                this.context.destroy();
                return null;
            }
            int size = vars.length;
            for (int i = 0; i < size; ++i) {
                AsnObjectId id = vars[i].getOid();
                AsnObject value = vars[i].getValue();
                if (log.isDebugEnabled()) {
                    log.debug("var[" + i + "]: " + id.toString() + "=" + value);
                }
                if (id.startsWith(this.parent[i].getOid())) continue;
                log.debug("Break query by prefix change.");
                this.context.destroy();
                return null;
            }
            varbind uptime = vars[0];
            varbind ifindex = vars[1];
            int uptimeValue = SnmpWorker.this.getValue(uptime.getValue());
            int ifindexValue = SnmpWorker.this.getValue(ifindex.getValue());
            long iface = (long)ifindexValue & 0xFFFFFFFFL;
            varbind input = vars[2];
            varbind output = vars[3];
            int inputValue = SnmpWorker.this.getValue(input.getValue());
            int outputValue = SnmpWorker.this.getValue(output.getValue());
            if (this.sourceIfaceList == null && input.getOid().getElementAt(input.getOid().getSize() - 1) != iface) {
                if (log.isDebugEnabled()) {
                    log.debug("Replace IN_OCTETS to 1");
                }
                inputValue = 1;
            }
            if (this.sourceIfaceList == null && output.getOid().getElementAt(output.getOid().getSize() - 1) != iface) {
                if (log.isDebugEnabled()) {
                    log.debug("Replace OUT_OCTETS to 1");
                }
                outputValue = 1;
            }
            ByteBuffer data = ByteBuffer.allocate(68);
            data.putInt(uptimeValue);
            if (this.useIfIndex) {
                data.putInt(ifindexValue);
            } else {
                data.putInt((int)(this.iface & 0xFFFFFFFFL));
            }
            data.putInt(0);
            data.putInt(0);
            data.putInt(0);
            data.putInt(0);
            data.putInt(0);
            data.putInt(0);
            data.putInt(inputValue);
            data.putInt(0);
            data.putInt(0);
            data.putInt(0);
            data.putInt(0);
            data.putInt(outputValue);
            data.putInt(0);
            data.putInt(0);
            data.putInt(0);
            long hour = now / 3600000L * 3600000L;
            IPHourlyDataLogger iPHourlyDataLogger = SnmpWorker.this.dataLogger;
            synchronized (iPHourlyDataLogger) {
                ConcurrentHashMap hourEntryMap = SnmpWorker.this.dataLogger.getForHourPart(hour);
                try {
                    Long nextHour;
                    data.flip();
                    SnmpFlowArray flowArray = SnmpWorker.this.flowArray.get(this.source.getId());
                    if (flowArray == null) {
                        flowArray = new SnmpFlowArray(null, new HashMap<Integer, SnmpFlowRecord>());
                        SnmpWorker.this.flowArray.put(this.source.getId(), flowArray);
                    }
                    if ((nextHour = SnmpWorker.this.nextHourMap.get(this.source.getId())) == null) {
                        GregorianCalendar hourCalendar = new GregorianCalendar();
                        hourCalendar.setTimeInMillis(hour);
                        SnmpWorker.this.reload(this.source, flowArray.getLastSnmp(), hourCalendar);
                    }
                    flowArray.parsePacket(data, now);
                    IPDataLogWriter writer = SnmpWorker.this.dataLogger.getWriter(hourEntryMap, SnmpWorker.this.writerMap, hour, (Idable)this.source);
                    if (nextHour == null || now > nextHour) {
                        if (this.sourceIfaceList == null) {
                            for (SnmpFlowRecord flow : flowArray.getLastSnmp().values()) {
                                writer.writeRecord(flow.getData(), flow.milliseconds);
                                flow.getData().clear();
                            }
                        } else {
                            Map<Integer, SnmpFlowRecord> lastSnmp = flowArray.getLastSnmp();
                            for (Long ifaceNumber : this.sourceIfaceList) {
                                Integer ifaceNumberInt = (int)(ifaceNumber & 0xFFFFFFFFL);
                                SnmpFlowRecord flow = lastSnmp.get(ifaceNumberInt);
                                if (flow == null) continue;
                                writer.writeRecord(flow.getData(), flow.milliseconds);
                                flow.getData().clear();
                            }
                        }
                        nextHour = SnmpWorker.getNextHour(now);
                        SnmpWorker.this.nextHourMap.put(this.source.getId(), nextHour);
                    }
                    if (data.remaining() == 68) {
                        writer.writeRecord(data, now);
                        SnmpWorker.this.processFlow(this.source, iface, flowArray, now, hour);
                    } else {
                        log.error("Data size = " + data.remaining() + " != record size");
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (this.sourceIfaces != null) {
                sourceIface = this.sourceIfaces.poll();
                if (sourceIface == null) {
                    log.debug("Break query by last iface.");
                    this.context.destroy();
                    return null;
                }
            } else {
                sourceIface = iface;
            }
            if (SnmpWorker.this.async) {
                SnmpWorker.this.examineNext(this.source, this.useIfIndex, this.context, this.parent, this.sourceIfaceList, this.sourceIfaces, sourceIface);
                return null;
            }
            return sourceIface;
        }
    }
}

