/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.processor;

import bitel.billing.server.admin.errorlog.AlarmSender;
import bitel.billing.server.admin.errorlog.bean.AlarmErrorMessage;
import java.beans.ConstructorProperties;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.application.server.ExtendedLifecycle;
import ru.bitel.bgbilling.kernel.network.processor.Processor;
import ru.bitel.bgbilling.kernel.network.processor.ProcessorListener;
import ru.bitel.bgbilling.kernel.network.processor.ProcessorRequest;
import ru.bitel.common.io.DatagramChannelListener;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.util.AverageCounter;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerTask;

public abstract class DatagramListener
extends DatagramChannelListener
implements ProcessorListener,
ThreadContextFactory<ThreadContext>,
ExtendedLifecycle {
    private static final Logger logger = LogManager.getLogger();
    private final ThreadPoolExecutor executorService;
    private final BlockingQueue<Runnable> workQueue;
    private final AverageCounter secondCounter = new AverageCounter(60L, TimeUnit.SECONDS);
    private final AverageCounter minuteCounter = new AverageCounter(60L, TimeUnit.MINUTES);
    protected volatile int maxQueueSize;
    protected volatile int rejectQueueSize;
    protected volatile int slow1QueueSize;
    protected volatile int slow2QueueSize;
    private volatile int overloadLevel;
    private final String name;

    @ConstructorProperties(value={"host", "port", "byteBufferCapacity", "threadCount", "maxQueueSize", "processor", "name", "nestedContext"})
    public DatagramListener(String host, int port, int byteBufferCapacity, int threadCount, int maxQueueSize, Processor processor, String name, String nestedContext) {
        super(host, port, byteBufferCapacity, 0);
        this.name = name;
        threadCount = threadCount > 0 ? threadCount : 10;
        this.maxQueueSize = maxQueueSize > 0 ? maxQueueSize : Math.max(threadCount * 3, 30);
        this.setMaxQueueSize(this.maxQueueSize);
        this.executorService = (ThreadPoolExecutor)WorkerTask.newFixedThreadPool((String)name, (String)nestedContext, (ThreadContextFactory)this, (int)threadCount);
        this.workQueue = this.executorService.getQueue();
    }

    public void onPacket(SocketAddress clientAddress, ByteBuffer data) {
        int overloadLevel;
        long millis = System.currentTimeMillis();
        this.minuteCounter.add(millis, 1L);
        this.secondCounter.add(millis, 1L);
        int queueSize = this.workQueue.size();
        if (queueSize > this.slow1QueueSize) {
            if (queueSize > this.slow2QueueSize) {
                if (queueSize > this.maxQueueSize) {
                    overloadLevel = 3;
                    String key = this.name + ".wait.thread";
                    if (AlarmSender.needAlarmSend(key, millis, 60000L)) {
                        String message = "\u0412 \u0440\u0430\u043c\u043a\u0430\u0445 \u043e\u0442\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u043c\u0438 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u043f\u043e\u0442\u043e\u043a\u043e\u0432 " + this.executorService.getMaximumPoolSize() + "  \u0438 \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u043c \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 " + this.maxQueueSize + " " + this.name + " \u043d\u0435 \u0443\u0441\u043f\u0435\u0435\u0432\u0430\u0435\u0442 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u044c \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0443 \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432.";
                        AlarmErrorMessage alarm = new AlarmErrorMessage(key, "\u0421\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u0443\u0441\u043f\u0435\u0432\u0430\u0435\u0442 \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441\u044b", message);
                        alarm.setDumpStackTrace(true);
                        AlarmSender.sendAlarm(alarm, millis);
                        logger.error(this.name + " queue is full!");
                    }
                    if (this.fallback(clientAddress, millis, data, overloadLevel)) {
                        if (queueSize > this.rejectQueueSize) {
                            this.workQueue.poll();
                        }
                        return;
                    }
                    this.workQueue.poll();
                    if (queueSize > this.rejectQueueSize) {
                        return;
                    }
                } else {
                    overloadLevel = 2;
                }
            } else {
                overloadLevel = 1;
            }
        } else {
            overloadLevel = 0;
        }
        this.overloadLevel = overloadLevel;
        this.executorService.execute(this.newRequest(clientAddress, millis, data, overloadLevel));
    }

    @Override
    public abstract ProcessorRequest<?> newRequest(SocketAddress var1, long var2, ByteBuffer var4, int var5);

    public boolean fallback(SocketAddress clientAddress, long millis, ByteBuffer data, int overloadLevel) {
        return false;
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void start() {
        if (!this.inited) {
            throw new IllegalStateException("ChannelListener not inited");
        }
        Thread result = new Thread((Runnable)((Object)this), this.getClass().getSimpleName());
        result.start();
    }

    @Override
    public void stop() throws Exception {
        this.shutdown();
    }

    @Override
    public void destroy() throws Exception {
    }

    @MBeanAttribute
    public int getThreadCount() {
        return this.executorService.getMaximumPoolSize();
    }

    public void setThreadCount(int count) {
        this.executorService.setCorePoolSize(count);
        this.executorService.setMaximumPoolSize(count);
    }

    @MBeanAttribute
    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
        this.rejectQueueSize = maxQueueSize * 2;
        int delta = this.maxQueueSize / 10;
        this.slow1QueueSize = Math.min(this.maxQueueSize, Math.max(this.maxQueueSize - 2 * delta, 10));
        this.slow2QueueSize = Math.min(this.maxQueueSize, Math.max(this.maxQueueSize - 1 * delta, 15));
    }

    @MBeanAttribute
    public int getSlow1QueueSize() {
        return this.slow1QueueSize;
    }

    @MBeanAttribute
    public int getSlow2QueueSize() {
        return this.slow2QueueSize;
    }

    @MBeanAttribute
    public int getCurrentThreadCount() {
        return this.executorService.getPoolSize();
    }

    @MBeanAttribute
    public int getActiveThreadCount() {
        return this.executorService.getActiveCount();
    }

    @MBeanAttribute
    public long getTaskCount() {
        return this.executorService.getTaskCount();
    }

    @MBeanAttribute
    public long getQueueSize() {
        return this.workQueue.size();
    }

    public int getOverloadLevel() {
        return this.overloadLevel;
    }

    @MBeanAttribute
    public long getLastMinuteCount() {
        return this.secondCounter.getSum(System.currentTimeMillis(), 60, TimeUnit.SECONDS);
    }

    @MBeanAttribute
    public double getLastTenMinutesAverage() {
        return this.minuteCounter.getAverage(System.currentTimeMillis(), 10, TimeUnit.MINUTES);
    }

    @MBeanAttribute
    public double getLastHourAverage() {
        return this.minuteCounter.getAverage(System.currentTimeMillis(), 60, TimeUnit.MINUTES);
    }
}

