/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.tlv;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.network.tlv.Tlv;
import ru.bitel.bgbilling.kernel.network.tlv.TlvHeader;

public abstract class TlvInfo<I extends TlvInfo<I, ?, H>, V, H extends TlvHeader>
implements Iterable<I> {
    public static final int TYPE_OCTETS = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_LONG = 3;
    public static final int TYPE_INTEGER = 4;
    public static final int TYPE_SHORT = 5;
    public static final int TYPE_BYTE = 6;
    public static final int TYPE_DOUBLE = 7;
    public static final int TYPE_FLOAT = 8;
    public static final int TYPE_TLV = 9;
    public static final int TYPE_IPADDR = 10;
    public static final int TYPE_ABINARY = 11;
    public static final int TYPE_IPV6ADDR = 20;
    public static final int TYPE_IPV6PREFIX = 21;
    protected final int paramTypeLength;
    protected final int paramLengthLength;
    public final int type;
    public final String name;
    public final int valueType;
    protected I parent;
    protected final List<I> childrenList;
    protected final I[] children;
    protected final Map<Integer, I> childrenMap;
    protected final Map<String, I> nameChildrenMap;
    private static final TlvInfo<?, ?, ?>[] nilArray = new TlvInfo[0];

    public TlvInfo(Class<?> clazz, int type, String name, int valueType, int paramTypeSize, int paramLengthSize, List<I> children) {
        this.paramTypeLength = paramTypeSize;
        this.paramLengthLength = paramLengthSize;
        this.type = type;
        this.name = name;
        this.valueType = valueType;
        if (children == null || children.size() == 0) {
            this.childrenList = Collections.emptyList();
            this.children = nilArray;
            this.childrenMap = null;
            this.nameChildrenMap = Collections.emptyMap();
        } else {
            this.childrenList = children;
            this.nameChildrenMap = new HashMap<String, I>();
            int max = 0;
            for (TlvInfo child : children) {
                this.nameChildrenMap.put(child.name.toLowerCase(), child);
                if (child.type <= max) continue;
                max = child.type;
            }
            if (max != 0 && max <= 256) {
                this.children = (TlvInfo[])Array.newInstance(clazz, max + 1);
                this.childrenMap = null;
                for (TlvInfo child : children) {
                    this.children[child.type] = child;
                }
            } else {
                this.children = null;
                this.childrenMap = new HashMap<Integer, I>();
                for (TlvInfo child : children) {
                    this.childrenMap.put(child.type, child);
                }
            }
        }
    }

    public void setParent(I parent) {
        this.parent = parent;
    }

    public I getChild(int type) {
        if (this.children != null) {
            if (type < this.children.length && type >= 0) {
                return this.children[type];
            }
            return null;
        }
        return (I)((TlvInfo)this.childrenMap.get(type));
    }

    public I getChild(String name) {
        return (I)((TlvInfo)this.nameChildrenMap.get(name));
    }

    @Override
    public Iterator<I> iterator() {
        return this.childrenList.iterator();
    }

    public abstract Tlv<?, ?> read(ByteBuffer var1, H var2);

    public abstract V unwrapValue(ByteBuffer var1);

    public abstract ByteBuffer wrapValue(V var1);

    public String valueToString(Tlv<?, V> attribute) {
        return String.valueOf(attribute.getValue());
    }

    protected final ByteBuffer sliceData(ByteBuffer bb, int length) {
        int limit = bb.limit();
        bb.limit(bb.position() + length);
        ByteBuffer data = bb.slice();
        bb.position(bb.limit());
        bb.limit(limit);
        return data;
    }

    public void readTypeLength(ByteBuffer bb, H header, int parentLength, boolean headerInLength) {
        switch (this.paramTypeLength) {
            case 2: {
                ((TlvHeader)header).type = bb.getShort() & 0xFFFF;
                break;
            }
            case 4: {
                ((TlvHeader)header).type = bb.getInt();
                break;
            }
            default: {
                ((TlvHeader)header).type = bb.get() & 0xFF;
            }
        }
        switch (this.paramLengthLength) {
            case 2: {
                ((TlvHeader)header).length = bb.getShort() & 0xFFFF;
                break;
            }
            case 0: {
                ((TlvHeader)header).length = parentLength;
                break;
            }
            default: {
                ((TlvHeader)header).length = bb.get() & 0xFF;
            }
        }
        if (headerInLength) {
            ((TlvHeader)header).length -= this.paramTypeLength + this.paramLengthLength;
        }
    }

    static enum TlvValueType {
        octets,
        string,
        integer,
        ipaddr,
        abinary;

    }
}

