/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.option.client;

import bitel.billing.module.common.BGControlPanelPluginControls;
import bitel.billing.module.common.BGTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.ContractTariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.ContractTariffOptionData;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOptionActivateMode;
import ru.bitel.bgbilling.kernel.tariff.option.common.service.TariffOptionService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Period;

public class ContractTariffOptionEditor
extends BGUPanel {
    private ContractTariffOptionTableModel model = new ContractTariffOptionTableModel();
    private ContractTariffOptionTableModel historyModel = new ContractTariffOptionTableModel();
    private JTabbedPane pane;
    private AtomicBoolean standartActivation = new AtomicBoolean(true);
    private TariffOptionService tariffOptionService = null;

    public ContractTariffOptionEditor() {
        try {
            this.build();
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    protected void jbInit() throws Exception {
        BGUTable table = new BGUTable((TableModel)((Object)this.model));
        table.setSelectionMode(0);
        BGDialogToolBar toolBar = new BGDialogToolBar();
        BGSwingUtilites.buildToolBar((BGDialogToolBar)toolBar, (JComponent)((Object)this));
        toolBar.compact();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.pane = new JTabbedPane();
        this.pane.add((Component)panel, "\u0422\u0435\u043a\u0443\u0449\u0438\u0435");
        this.pane.add((Component)BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)new BGUTable((TableModel)((Object)this.historyModel)))), "\u0418\u0441\u0442\u043e\u0440\u0438\u044f");
        JPanel productPanel = new JPanel(new BorderLayout());
        productPanel.add((Component)toolBar, "North");
        productPanel.add((Component)this.pane, "Center");
        this.setLayout(new BorderLayout());
        this.add(productPanel, "Center");
    }

    public int getContractId() {
        return ((ClientContext)this.getContext()).getContractId();
    }

    private TariffOptionService getTariffOptionService() {
        if (this.tariffOptionService == null) {
            this.tariffOptionService = (TariffOptionService)((ClientContext)this.getContext()).getPort(TariffOptionService.class);
        }
        return this.tariffOptionService;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            Date date = new Date();
            this.model.setData(this.getTariffOptionService().contractTariffOptionList(this.getContractId(), date));
            this.historyModel.setData(this.getTariffOptionService().contractTariffOptionHistory(this.getContractId(), date, false));
        }).setIcon((Icon)ClientUtils.getIcon((String)"refresh"));
        new AbstractBGUPanel.DefaultAction("activate", "\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0430\u0440\u0438\u0444\u043d\u0443\u044e \u043e\u043f\u0446\u0438\u044e", ClientUtils.getIcon((String)"fugue/present--plus")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                new TariffOptionEditor("\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0430\u0440\u0438\u0444\u043d\u0443\u044e \u043e\u043f\u0446\u0438\u044e", null).open();
            }
        };
        new AbstractBGUPanel.DefaultAction("reactivate", "\u0420\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0430\u0440\u0438\u0444\u043d\u0443\u044e \u043e\u043f\u0446\u0438\u044e", ClientUtils.getIcon((String)"fugue/present--arrow")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ContractTariffOption option = (ContractTariffOption)((Object)ContractTariffOptionEditor.this.model.getSelectedRow());
                if (option == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u043f\u0446\u0438\u044e!");
                } else if (option.getTimeTo() != null && option.getDeactivatedTime() != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0440\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u043f\u0446\u0438\u044e?", "\u0420\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f", 0) == 0) {
                    try {
                        ContractTariffOptionEditor.this.getTariffOptionService().contractTariffOptionReactivate(ContractTariffOptionEditor.this.getContractId(), option.getId());
                        ContractTariffOptionEditor.this.performAction("refresh");
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("deactivate", "\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0430\u0440\u0438\u0444\u043d\u0443\u044e \u043e\u043f\u0446\u0438\u044e", ClientUtils.getIcon((String)"fugue/present--minus")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ContractTariffOption option = (ContractTariffOption)((Object)ContractTariffOptionEditor.this.model.getSelectedRow());
                if (option == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u043f\u0446\u0438\u044e!");
                } else if (option.getTimeTo() == null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u043f\u0446\u0438\u044e?", "\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f", 0) == 0) {
                    try {
                        ContractTariffOptionEditor.this.getTariffOptionService().contractTariffOptionDeactivate(ContractTariffOptionEditor.this.getContractId(), option.getId());
                        ContractTariffOptionEditor.this.performAction("refresh");
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("option.delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0430\u0440\u0438\u0444\u043d\u0443\u044e \u043e\u043f\u0446\u0438\u044e", ClientUtils.getIcon((String)"item_delete")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ContractTariffOption option = ContractTariffOptionEditor.this.pane.getSelectedIndex() == 0 ? (ContractTariffOption)((Object)ContractTariffOptionEditor.this.model.getSelectedRow()) : (ContractTariffOption)((Object)ContractTariffOptionEditor.this.historyModel.getSelectedRow());
                if (option == null) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u043f\u0446\u0438\u044e!", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                } else if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043e\u043f\u0446\u0438\u044e?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                    try {
                        ContractTariffOptionEditor.this.getTariffOptionService().contractTariffOptionDelete(ContractTariffOptionEditor.this.getContractId(), option.getId(), false);
                        ContractTariffOptionEditor.this.performAction("refresh");
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            }
        };
    }

    class ContractTariffOptionTableModel
    extends BGTableModel<ContractTariffOption> {
        public ContractTariffOptionTableModel() {
            super(ContractTariffOptionTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", String.class, -1, 150, -1, "optionTitle", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", String.class, -1, 150, -1, "optionComment", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0412\u0440\u0435\u043c\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438", 150, 150, 200, "timeFrom", false).setTableCellRenderer(DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0412\u0440\u0435\u043c\u044f \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f", 150, 150, 200, "timeTo", false).setTableCellRenderer(DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438", 180, 180, 180, "summa", true).setTableCellRenderer((TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
        }
    }

    class TariffOptionEditor
    extends BGEditorDialog<TariffOption> {
        private BGControlPanelPluginControls extensionPanel;
        private BGUComboBox<TariffOption> optionComboBox;
        private BGUComboBox<TariffOptionActivateMode> modeComboBox;
        private JRadioButton autoMode;
        private JRadioButton manualMode;
        private BGControlPanelPeriodNoB period;
        private ButtonGroup buttonGroup;
        private BGTextArea comment;

        public TariffOptionEditor(String title, TariffOption data) {
            super(title, (Object)data);
            this.optionComboBox = new BGUComboBox();
            this.modeComboBox = new BGUComboBox();
            this.autoMode = new JRadioButton("\u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 (\u0437\u0430\u0434\u0430\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438)");
            this.manualMode = new JRadioButton("\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439");
            this.period = new BGControlPanelPeriodNoB();
            this.buttonGroup = new ButtonGroup();
            this.comment = new BGTextArea(3, 40);
        }

        public void doDialogPanel() {
            ActionListener actionListener = e -> this.period.setEnabled("manual".equals(this.buttonGroup.getSelection().getActionCommand()));
            this.autoMode.setActionCommand("auto");
            this.autoMode.setSelected(true);
            this.autoMode.addActionListener(actionListener);
            this.buttonGroup.add(this.autoMode);
            this.manualMode.setActionCommand("manual");
            this.manualMode.addActionListener(actionListener);
            this.buttonGroup.add(this.manualMode);
            this.period.setEnabled(false);
            this.panel.add((Component)new JLabel("\u041e\u043f\u0446\u0438\u044f:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.optionComboBox, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.modeComboBox, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.autoMode, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.manualMode, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.period, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)this.comment, (int)500, (int)60), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            try {
                this.extensionPanel = new BGControlPanelPluginControls(ContractTariffOptionEditor.class.getName(), (Component)this.panel, new Object[]{this.modeComboBox, ContractTariffOptionEditor.this.getContractId(), ContractTariffOptionEditor.this.standartActivation, new AtomicReference<ButtonGroup>(this.buttonGroup), new AtomicReference<BGControlPanelPeriodNoB>(this.period)});
                this.panel.add((Component)this.extensionPanel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            }
            catch (Exception e2) {
                ClientUtils.showErrorMessageDialog((Throwable)e2);
            }
            try {
                List<TariffOption> list = ContractTariffOptionEditor.this.getTariffOptionService().tariffOptionListAvailable(ContractTariffOptionEditor.this.getContractId(), null, null, false, false);
                ArrayList<TariffOption> result = new ArrayList<TariffOption>();
                list.forEach(option -> {
                    if (option.isEnable()) {
                        result.add((TariffOption)((Object)option));
                    }
                });
                result.add(TariffOption.builder().setTitle("-----").build());
                list.forEach(option -> {
                    if (!option.isEnable()) {
                        result.add((TariffOption)((Object)option));
                    }
                });
                this.optionComboBox.setData(result);
                this.reloadModeCombo();
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.optionComboBox.addActionListener(e -> this.reloadModeCombo());
            this.modeComboBox.addItemListener(e -> {
                if (this.extensionPanel != null && e.getStateChange() == 1) {
                    this.extensionPanel.invokeSetData(new Object[0]);
                }
            });
        }

        public boolean doApply() throws Exception {
            TariffOption option = (TariffOption)this.optionComboBox.getSelectedItem();
            TariffOptionActivateMode mode = (TariffOptionActivateMode)this.modeComboBox.getSelectedItem();
            if (option == null || mode == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u043f\u0446\u0438\u044e \u0438 \u0440\u0435\u0436\u0438\u043c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438!");
            } else {
                try {
                    if (this.extensionPanel != null && !this.extensionPanel.invokeBeforeAction(new Object[]{ContractTariffOptionEditor.this.standartActivation})) {
                        return true;
                    }
                    if (ContractTariffOptionEditor.this.standartActivation.get()) {
                        Period optionPeriod = "auto".equals(this.buttonGroup.getSelection().getActionCommand()) ? null : this.period.getPeriod();
                        ContractTariffOptionData optionActivate = new ContractTariffOptionData();
                        optionActivate.setContractId(ContractTariffOptionEditor.this.getContractId());
                        optionActivate.setOptionId(option.getId());
                        optionActivate.setModeId(mode.getId());
                        optionActivate.setPeriod(optionPeriod);
                        optionActivate.setComment(this.comment.getText());
                        ContractTariffOptionEditor.this.getTariffOptionService().contractTariffOptionActivate(optionActivate);
                    }
                    EventBus.publish((Object)new UpdateContractTreeEvent(0, ContractTariffOptionEditor.this.getContractId()));
                    ContractTariffOptionEditor.this.performAction("refresh");
                }
                catch (Exception e) {
                    ClientUtils.showErrorMessageDialog((Throwable)e);
                }
            }
            return true;
        }

        public BGUComboBox<TariffOptionActivateMode> getTariffOptionModeComboBox() {
            return this.modeComboBox;
        }

        private void reloadModeCombo() {
            TariffOption option = (TariffOption)this.optionComboBox.getSelectedItem();
            if (option != null) {
                this.modeComboBox.setData(option.getActivateModeList());
            }
            if (this.extensionPanel != null) {
                this.extensionPanel.invokeSetData(new Object[0]);
            }
        }
    }
}

