/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.option.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.FloatTextField;
import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ChargeType;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ChargeService;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOptionActivateMode;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;

public class TariffOptionActivateModesEditor
extends BGUPanel {
    private TariffOptionActivateModeTableModel model;
    private BGUTable table;

    public TariffOptionActivateModesEditor() {
        super((LayoutManager)new GridBagLayout());
        this.init();
    }

    protected void jbInit() {
        this.model = new TariffOptionActivateModeTableModel();
        this.table = new BGUTable((TableModel)((Object)this.model));
        BGSwingUtilites.handleEdit((String)"mode", (JTable)this.table, (AbstractBGUPanel)this);
        BGDialogToolBar toolBar = new BGDialogToolBar();
        this.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 0), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        BGSwingUtilites.buildToolBar((BGDialogToolBar)toolBar, (JComponent)((Object)this), (String)"mode");
        toolBar.setFloatable(false);
        toolBar.compact();
    }

    public void setData(List<TariffOptionActivateMode> modeList) {
        this.model.setData(modeList);
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("mode.new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c", ICON_NEW){

            public void actionPerformedImpl(ActionEvent e) throws BGException {
                TariffOptionActivateMode tariffOptionActivateMode = new TariffOptionActivateMode();
                tariffOptionActivateMode.setDateFrom(new Date());
                tariffOptionActivateMode.setPeriodCol(1);
                new TariffOptionActivateModeEditor("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c", tariffOptionActivateMode).getDialog().setVisible(true);
            }

            public void setEnabled(boolean newValue) {
                super.setEnabled(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("mode.edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0440\u0435\u0436\u0438\u043c", ICON_EDIT){

            public void actionPerformedImpl(ActionEvent e) throws BGException {
                TariffOptionActivateMode mode = (TariffOptionActivateMode)((Object)TariffOptionActivateModesEditor.this.model.getSelectedRow());
                if (mode == null) {
                    return;
                }
                new TariffOptionActivateModeEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0440\u0435\u0436\u0438\u043c\u0430", mode).getDialog().setVisible(true);
            }

            public void setEnabled(boolean newValue) {
                super.setEnabled(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("mode.delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c", ICON_DELETE){

            public void actionPerformedImpl(ActionEvent e) throws BGException {
                TariffOptionActivateModesEditor.this.model.deleteSelectedRows();
            }

            public void setEnabled(boolean newValue) {
                super.setEnabled(true);
            }
        };
    }

    public List<TariffOptionActivateMode> getData() {
        return this.model.getRows();
    }

    class TariffOptionActivateModeTableModel
    extends BGTableModel<TariffOptionActivateMode> {
        public TariffOptionActivateModeTableModel() {
            super(TariffOptionActivateModeTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 180, 180, 180, "period", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, 150, -1, "title", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f", -1, 150, 150, "deactivate", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0420\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f", -1, 150, 150, "reactivate", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0422\u0438\u043f \u0440\u0430\u0441\u0445\u043e\u0434\u0430", -1, 200, 300, "chargeTypeTitle", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", 100, 100, 100, "chargeSumma", false, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
        }

        public Object getValue(TariffOptionActivateMode val, int column) throws BGException {
            String identifier;
            switch (identifier = this.getIdentifier(column)) {
                case "period": {
                    return new Period(val.getDateFrom(), val.getDateTo());
                }
                case "title": {
                    return val.getTitle();
                }
                case "deactivate": {
                    if (val.getPeriodCol() != 0) {
                        return "";
                    }
                    switch (val.getDeactivationMode()) {
                        case 0: {
                            return "\u043c\u043e\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u043e";
                        }
                        case 4: {
                            return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0447\u0430\u0441\u0430";
                        }
                        case 1: {
                            return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0434\u043d\u044f";
                        }
                        case 2: {
                            return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043d\u0435\u0434\u0435\u043b\u0438";
                        }
                        case 3: {
                            return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043c\u0435\u0441\u044f\u0446\u0430";
                        }
                        case 5: {
                            return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0433\u043e\u0434\u0430";
                        }
                    }
                    return null;
                }
                case "reactivate": {
                    if (val.getPeriodCol() != 0) {
                        return "";
                    }
                    switch (val.getReactivationMode()) {
                        case 0: {
                            return "\u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430";
                        }
                        case 1: {
                            return "\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0430";
                        }
                    }
                    return null;
                }
            }
            return super.getValue((Object)val, column);
        }
    }

    class TariffOptionActivateModeEditor
    extends BGEditorDialog<TariffOptionActivateMode> {
        private BGTextField title;
        private BGControlPanelPeriodNoB period;
        private IntTextField periodFromValue;
        private BGUComboBox<KeyValue> periodFromStart;
        private BGUComboBox<KeyValue> periodFromUnit;
        private BGUComboBox<KeyValue> periodFromMode;
        private IntTextField periodDurationValue;
        private BGUComboBox<KeyValue> periodDurationUnit;
        private IntTextField periodToValue;
        private BGUComboBox<KeyValue> periodToStart;
        private BGUComboBox<KeyValue> periodToUnit;
        private BGUComboBox<KeyValue> periodToMode;
        private BGUComboBox<IdTitle> deactivationModeCB;
        private BGUComboBox<IdTitle> reactivationModeCB;
        private BGComboBox<ComboBoxItem> chargeTypeCB;
        private BGUComboBox<IdTitle> deleteModeCB;
        private BGUComboBox<IdTitle> deleteChargeModeCB;
        private FloatTextField chargeSummTF;
        private ButtonGroup periodEndButtonGroup;
        List<KeyValue> periodUnitData;

        public TariffOptionActivateModeEditor(String title, TariffOptionActivateMode data) {
            super(title, (Object)data);
            this.title = new BGTextField(40);
            this.period = new BGControlPanelPeriodNoB();
            this.periodFromValue = new IntTextField(5);
            this.periodFromStart = new BGUComboBox();
            this.periodFromUnit = new BGUComboBox();
            this.periodFromMode = new BGUComboBox();
            this.periodDurationValue = new IntTextField(5);
            this.periodDurationUnit = new BGUComboBox();
            this.periodToValue = new IntTextField(5);
            this.periodToStart = new BGUComboBox();
            this.periodToUnit = new BGUComboBox();
            this.periodToMode = new BGUComboBox();
            this.deactivationModeCB = new BGUComboBox();
            this.reactivationModeCB = new BGUComboBox();
            this.chargeTypeCB = new BGComboBox();
            this.deleteModeCB = new BGUComboBox();
            this.deleteChargeModeCB = new BGUComboBox();
            this.chargeSummTF = new FloatTextField(8);
            this.periodEndButtonGroup = new ButtonGroup();
            this.periodUnitData = Arrays.asList(new KeyValue("min", "\u043c\u0438\u043d\u0443\u0442\u0430"), new KeyValue("hour", "\u0447\u0430\u0441"), new KeyValue("day", "\u0434\u0435\u043d\u044c"), new KeyValue("week", "\u043d\u0435\u0434\u0435\u043b\u044f"), new KeyValue("month", "\u043c\u0435\u0441\u044f\u0446"), new KeyValue("year", "\u0433\u043e\u0434"));
        }

        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.period, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 5, 0, 3), 0, 0));
            this.panel.add((Component)new JLabel("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.getPeriodModePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.getDeactivatePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.getDeletePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u043e\u043f\u0446\u0438\u0438 (\u0440\u0430\u0441\u0445\u043e\u0434):"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.getChargePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 0, 0), 0, 0));
            try {
                DefaultComboBoxModel<ComboBoxItem> comboBoxModel = new DefaultComboBoxModel<ComboBoxItem>();
                for (ChargeType type : ((ChargeService)((ClientContext)TariffOptionActivateModesEditor.this.getContext()).getPort(ChargeService.class)).chargeTypeList(1, 0, false)) {
                    comboBoxModel.addElement(new ComboBoxItem(type.getId(), type.getTitle()));
                }
                this.chargeTypeCB.setModel(comboBoxModel);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.title.setText(((TariffOptionActivateMode)((Object)this.data)).getTitle());
            this.period.setDateFrom(((TariffOptionActivateMode)((Object)this.data)).getDateFrom());
            this.period.setDateTo(((TariffOptionActivateMode)((Object)this.data)).getDateTo());
            Object activatePeriod = ((TariffOptionActivateMode)((Object)this.data)).getActivatePeriod();
            if (activatePeriod == null) {
                Map<Integer, String> unitMap1 = Map.of(1, "min", 2, "hour", 3, "day", 4, "week", 5, "month", 6, "year");
                Map<Integer, String> unitMap2 = Map.of(1, "minStart", 2, "hourStart", 3, "dayStart", 4, "weekStart", 5, "monthStart", 6, "yearStart");
                int[] modeValue = TariffOptionActivateMode.mode(((TariffOptionActivateMode)((Object)this.data)).getPeriodMode());
                activatePeriod = modeValue[1] == 1 ? "now" : "now+_" + (modeValue[1] == 2 ? "0" : "1") + "_" + (modeValue[1] == 4 ? "hour" : unitMap1.getOrDefault(modeValue[0], "month")) + "_" + unitMap2.getOrDefault(modeValue[0], "monthStart");
                int periodCol = ((TariffOptionActivateMode)((Object)this.data)).getPeriodCol();
                activatePeriod = periodCol == 0 ? (String)activatePeriod + "-end_unlim" : (String)activatePeriod + "-on_" + periodCol + "_" + unitMap1.getOrDefault(modeValue[0], "month");
            }
            String[] startEnd = ((String)activatePeriod).split("-");
            String[] start = startEnd[0].split("_");
            String[] end = startEnd[1].split("_");
            this.periodFromStart.setSelectedItem((Object)this.periodFromStart.getData().stream().filter(a -> a.getKey().equals(start[0])).findFirst().orElse((KeyValue)this.periodFromStart.getData().get(0)));
            if ("now+".equals(start[0])) {
                this.periodFromValue.setText(start[1]);
                this.periodFromUnit.setSelectedItem((Object)this.periodUnitData.stream().filter(a -> a.getKey().equals(start[2])).findFirst().orElse(this.periodUnitData.get(0)));
                this.periodFromMode.setSelectedItem((Object)this.periodFromMode.getData().stream().filter(a -> a.getKey().equals(start[3])).findFirst().orElse((KeyValue)this.periodFromMode.getData().get(0)));
            }
            this.periodEndButtonGroup.getElements().asIterator().forEachRemaining(a -> {
                if (a.getActionCommand().equals(end[0])) {
                    a.setSelected(true);
                }
            });
            if ("on".equals(end[0])) {
                this.periodDurationValue.setText(end[1]);
                this.periodDurationUnit.setSelectedItem((Object)this.periodUnitData.stream().filter(a -> a.getKey().equals(end[2])).findFirst().orElse(this.periodUnitData.get(0)));
            } else {
                this.periodToStart.setSelectedItem((Object)this.periodToStart.getData().stream().filter(a -> a.getKey().equals(end[1])).findFirst().orElse((KeyValue)this.periodToStart.getData().get(0)));
                if ("start+".equals(end[1])) {
                    this.periodToValue.setText(end[2]);
                    this.periodToUnit.setSelectedItem((Object)this.periodUnitData.stream().filter(a -> a.getKey().equals(end[3])).findFirst().orElse(this.periodUnitData.get(0)));
                    this.periodToMode.setSelectedItem((Object)this.periodToMode.getData().stream().filter(a -> a.getKey().equals(end[4])).findFirst().orElse((KeyValue)this.periodToMode.getData().get(0)));
                }
            }
            this.deactivationModeCB.setSelectedItem((Object)((TariffOptionActivateMode)((Object)this.data)).getDeactivationMode());
            this.reactivationModeCB.setSelectedItem((Object)((TariffOptionActivateMode)((Object)this.data)).getReactivationMode());
            this.deleteModeCB.setSelectedItem((Object)((TariffOptionActivateMode)((Object)this.data)).getDeleteMode());
            this.deleteChargeModeCB.setSelectedItem((Object)((TariffOptionActivateMode)((Object)this.data)).getDeleteChargeMode());
            if (this.chargeTypeCB.getItemCount() > 0) {
                this.chargeTypeCB.setSelectedIndex(0);
            }
            this.chargeTypeCB.setSelectedId(Integer.toString(((TariffOptionActivateMode)((Object)this.data)).getChargeTypeId()));
            this.chargeSummTF.setText(Utils.formatBigDecimal((BigDecimal)((TariffOptionActivateMode)((Object)this.data)).getChargeSumma(), (int)2));
            this.setEnabledPeriod1();
            this.setEnabledPeriod2();
            this.setEnabledPeriod3();
            this.setEnableDeactivate();
        }

        public boolean doApply() throws Exception {
            Object end;
            ComboBoxItem chargeType = (ComboBoxItem)this.chargeTypeCB.getSelectedItem();
            if (chargeType == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0440\u0430\u0441\u0445\u043e\u0434\u0430!");
                return false;
            }
            if (((TariffOptionActivateMode)((Object)this.data)).getId() == 0) {
                ((TariffOptionActivateMode)((Object)this.data)).setId(-1);
                TariffOptionActivateModesEditor.this.model.getRows().add((TariffOptionActivateMode)((Object)this.data));
            }
            ((TariffOptionActivateMode)((Object)this.data)).setTitle(this.title.getText());
            ((TariffOptionActivateMode)((Object)this.data)).setDateFrom(this.period.getDateFrom());
            ((TariffOptionActivateMode)((Object)this.data)).setDateTo(this.period.getDateTo());
            Object start = ((KeyValue)this.periodFromStart.getSelectedItem()).getKey();
            if ("now+".equals(start)) {
                if (Utils.isBlankString((String)this.periodFromValue.getText())) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0430\u0447\u0430\u043b\u0430 \u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438");
                    return false;
                }
                start = (String)start + "_" + this.periodFromValue.getText() + "_" + ((KeyValue)this.periodFromUnit.getSelectedItem()).getKey() + "_" + ((KeyValue)this.periodFromMode.getSelectedItem()).getKey();
            }
            if ("on".equals(end = this.periodEndButtonGroup.getSelection().getActionCommand())) {
                if (Utils.isBlankString((String)this.periodDurationValue.getText())) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438");
                    return false;
                }
                end = (String)end + "_" + this.periodDurationValue.getText() + "_" + ((KeyValue)this.periodDurationUnit.getSelectedItem()).getKey();
            } else if ("end".equals(end)) {
                String endStart = ((KeyValue)this.periodToStart.getSelectedItem()).getKey();
                end = (String)end + "_" + endStart;
                if ("start+".equals(endStart)) {
                    if (Utils.isBlankString((String)this.periodToValue.getText())) {
                        ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438");
                        return false;
                    }
                    end = (String)end + "_" + this.periodToValue.getText() + "_" + ((KeyValue)this.periodToUnit.getSelectedItem()).getKey() + "_" + ((KeyValue)this.periodToMode.getSelectedItem()).getKey();
                }
            }
            ((TariffOptionActivateMode)((Object)this.data)).setPeriodCol(0);
            ((TariffOptionActivateMode)((Object)this.data)).setPeriodMode(0);
            ((TariffOptionActivateMode)((Object)this.data)).setActivatePeriod((String)start + "-" + (String)end);
            ((TariffOptionActivateMode)((Object)this.data)).setDeactivationMode(((IdTitle)this.deactivationModeCB.getSelectedItem()).getId());
            ((TariffOptionActivateMode)((Object)this.data)).setReactivationMode(((IdTitle)this.reactivationModeCB.getSelectedItem()).getId());
            ((TariffOptionActivateMode)((Object)this.data)).setDeleteMode(((IdTitle)this.deleteModeCB.getSelectedItem()).getId());
            ((TariffOptionActivateMode)((Object)this.data)).setDeleteChargeMode(((IdTitle)this.deleteChargeModeCB.getSelectedItem()).getId());
            ((TariffOptionActivateMode)((Object)this.data)).setChargeTypeId(Utils.parseInt((String)((String)chargeType.getObject())));
            ((TariffOptionActivateMode)((Object)this.data)).setChargeTypeTitle(chargeType.toString());
            ((TariffOptionActivateMode)((Object)this.data)).setChargeSumma(Utils.parseBigDecimal((String)this.chargeSummTF.getText(), (BigDecimal)BigDecimal.ZERO));
            TariffOptionActivateModesEditor.this.model.fireTableDataChanged();
            return true;
        }

        private JPanel getChargePanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.chargeSummTF, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.chargeTypeCB, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getDeactivatePanel() {
            List<IdTitle> deactivationModeData = Arrays.asList(new IdTitle(0, "\u043c\u043e\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u043e"), new IdTitle(4, "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0447\u0430\u0441\u0430"), new IdTitle(1, "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0434\u043d\u044f"), new IdTitle(2, "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043d\u0435\u0434\u0435\u043b\u0438"), new IdTitle(3, "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043c\u0435\u0441\u044f\u0446\u0430"), new IdTitle(5, "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0433\u043e\u0434\u0430"));
            this.deactivationModeCB.setData(deactivationModeData);
            List<IdTitle> reactivationModeData = Arrays.asList(new IdTitle(0, "\u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430"), new IdTitle(1, "\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0430"));
            this.reactivationModeCB.setData(reactivationModeData);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0420\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f (\u043e\u0442\u043c\u0435\u043d\u0430 \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438):"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
            panel.add((Component)this.deactivationModeCB, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)this.reactivationModeCB, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 10, 0, 3), 0, 0));
            return panel;
        }

        private void setEnableDeactivate() {
            boolean enabled = "end".equals(this.periodEndButtonGroup.getSelection().getActionCommand());
            this.deactivationModeCB.setEnabled(enabled &= "unlim".equals(((KeyValue)this.periodToStart.getSelectedItem()).getKey()));
            this.reactivationModeCB.setEnabled(enabled);
        }

        private JPanel getDeletePanel() {
            this.deleteModeCB.addActionListener(e -> this.deleteChargeModeCB.setEnabled(((IdTitle)this.deleteModeCB.getSelectedItem()).getId() != 0));
            List<IdTitle> deleteModeData = Arrays.asList(new IdTitle(0, "\u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e"), new IdTitle(1, "\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e \u0434\u043b\u044f \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430"), new IdTitle(2, "\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e"));
            this.deleteModeCB.setData(deleteModeData);
            List<IdTitle> deleteChargeModeData = Arrays.asList(new IdTitle(0, "\u043d\u0435 \u0443\u0434\u0430\u043b\u044f\u0442\u044c"), new IdTitle(1, "\u0443\u0434\u0430\u043b\u044f\u0442\u044c \u0435\u0441\u043b\u0438 \u0432\u0440\u0435\u043c\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043d\u0435 \u043d\u0430\u0441\u0442\u0443\u043f\u0438\u043b\u043e"), new IdTitle(2, "\u0443\u0434\u0430\u043b\u044f\u0442\u044c"));
            this.deleteChargeModeCB.setData(deleteChargeModeData);
            this.deleteChargeModeCB.setSelectedIndex(1);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u043e\u043f\u0446\u0438\u0438:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0440\u0430\u0441\u0445\u043e\u0434\u0430:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
            panel.add((Component)this.deleteModeCB, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)this.deleteChargeModeCB, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 10, 0, 3), 0, 0));
            return panel;
        }

        private JPanel getPeriodModePanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.getPeriod1Panel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)this.getPeriod2Panel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)this.getPeriod3Panel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getPeriod1Panel() {
            List<KeyValue> data = Arrays.asList(new KeyValue("now", "\u0441 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043c\u043e\u043c\u0435\u043d\u0442\u0430"), new KeyValue("now+", "\u0441 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043c\u043e\u043c\u0435\u043d\u0442\u0430 +"));
            this.periodFromStart.setData(data);
            this.periodFromStart.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.setEnabledPeriod1();
                }
            });
            this.periodFromUnit.setData(this.periodUnitData);
            data = Arrays.asList(new KeyValue("no", ""), new KeyValue("minStart", "\u0441 \u043d\u0430\u0447\u0430\u043b\u0430 \u043c\u0438\u043d\u0443\u0442\u044b"), new KeyValue("hourStart", "\u0441 \u043d\u0430\u0447\u0430\u043b\u0430 \u0447\u0430\u0441\u0430"), new KeyValue("dayStart", "\u0441 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u043d\u044f"), new KeyValue("weekStart", "\u0441 \u043d\u0430\u0447\u0430\u043b\u0430 \u043d\u0435\u0434\u0435\u043b\u0438"), new KeyValue("monthStart", "\u0441 \u043d\u0430\u0447\u0430\u043b\u0430 \u043c\u0435\u0441\u044f\u0446\u0430"), new KeyValue("yearStart", "\u0441 \u043d\u0430\u0447\u0430\u043b\u0430 \u0433\u043e\u0434\u0430"));
            this.periodFromMode.setData(data);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u0430\u0447\u0430\u043b\u043e "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.periodFromStart, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 3, 0, 0), 0, 0));
            panel.add((Component)this.periodFromValue, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 3, 0, 0), 0, 0));
            panel.add((Component)this.periodFromUnit, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 3, 0, 0), 0, 0));
            panel.add((Component)this.periodFromMode, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 3, 0, 0), 0, 0));
            return panel;
        }

        private void setEnabledPeriod1() {
            boolean enabled = "now+".equals(((KeyValue)this.periodFromStart.getSelectedItem()).getKey());
            this.periodFromValue.setEnabled(enabled);
            this.periodFromUnit.setEnabled(enabled);
            this.periodFromMode.setEnabled(enabled);
        }

        private JPanel getPeriod2Panel() {
            JRadioButton radio = new JRadioButton("\u043d\u0430", true);
            radio.setActionCommand("on");
            radio.addActionListener(e -> {
                this.setEnabledPeriod2();
                this.setEnabledPeriod3();
                this.setEnableDeactivate();
            });
            this.periodEndButtonGroup.add(radio);
            this.periodDurationUnit.setData(this.periodUnitData);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)radio, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.periodDurationValue, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 0, 0), 0, 0));
            panel.add((Component)this.periodDurationUnit, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 3, 0, 0), 0, 0));
            return panel;
        }

        private void setEnabledPeriod2() {
            boolean enabled = "on".equals(this.periodEndButtonGroup.getSelection().getActionCommand());
            this.periodDurationValue.setEnabled(enabled);
            this.periodDurationUnit.setEnabled(enabled);
        }

        private JPanel getPeriod3Panel() {
            JRadioButton radio = new JRadioButton("\u0434\u043e");
            radio.setActionCommand("end");
            radio.addActionListener(e -> {
                this.setEnabledPeriod2();
                this.setEnabledPeriod3();
                this.setEnableDeactivate();
            });
            this.periodEndButtonGroup.add(radio);
            List<KeyValue> data = Arrays.asList(new KeyValue("unlim", "\u0431\u0435\u0441\u0441\u0440\u043e\u0447\u043d\u043e"), new KeyValue("start+", "\u043d\u0430\u0447\u0430\u043b\u043e +"));
            this.periodToStart.setData(data);
            this.periodToStart.addItemListener(e -> {
                this.setEnableDeactivate();
                this.setEnabledPeriod3();
            });
            this.periodToUnit.setData(this.periodUnitData);
            data = Arrays.asList(new KeyValue("no", ""), new KeyValue("minEnd", "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043c\u0438\u043d\u0443\u0442\u044b"), new KeyValue("hourEnd", "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0447\u0430\u0441\u0430"), new KeyValue("dayEnd", "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0434\u043d\u044f"), new KeyValue("weekEnd", "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043d\u0435\u0434\u0435\u043b\u0438"), new KeyValue("monthEnd", "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043c\u0435\u0441\u044f\u0446\u0430"), new KeyValue("yearEnd", "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0433\u043e\u0434\u0430"));
            this.periodToMode.setData(data);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)radio, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.periodToStart, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 3, 0, 0), 0, 0));
            panel.add((Component)this.periodToValue, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 3, 0, 0), 0, 0));
            panel.add((Component)this.periodToUnit, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 3, 0, 0), 0, 0));
            panel.add((Component)this.periodToMode, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 3, 0, 0), 0, 0));
            return panel;
        }

        private void setEnabledPeriod3() {
            boolean enabled = "end".equals(this.periodEndButtonGroup.getSelection().getActionCommand());
            this.periodToStart.setEnabled(enabled);
            this.periodToValue.setEnabled(enabled &= "start+".equals(((KeyValue)this.periodToStart.getSelectedItem()).getKey()));
            this.periodToUnit.setEnabled(enabled);
            this.periodToMode.setEnabled(enabled);
        }
    }
}

