/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.option.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.ContractTariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class ContractTariffOptionDao
extends AbstractIdDao<ContractTariffOption> {
    public ContractTariffOptionDao(Connection con) {
        super(con, 0, "contract_tariff_option");
    }

    public List<ContractTariffOption> list(int contractId, Date date) throws BGException {
        return this.list(contractId, date, false, true);
    }

    public List<ContractTariffOption> list(int contractId, Date date, boolean history, boolean needNonActive) throws BGException {
        try {
            ArrayList<ContractTariffOption> result = new ArrayList<ContractTariffOption>();
            StringBuilder query = new StringBuilder();
            query.append("SELECT cto.*, `to`.title FROM ");
            query.append("contract_tariff_option");
            query.append(" AS cto ");
            query.append("\n LEFT JOIN ");
            query.append("tariff_option");
            query.append(" AS `to` ON cto.option_id=`to`.id ");
            query.append("\n WHERE cto.cid=? ");
            if (date != null) {
                if (history) {
                    query.append("\n AND (cto.time_to IS NOT NULL AND ?>cto.time_to)");
                } else {
                    query.append("\n AND (cto.time_to IS NULL OR ?<=cto.time_to)");
                }
            }
            if (!needNonActive) {
                query.append("\n AND (cto.time_to IS NULL OR cto.time_from<cto.time_to)");
            }
            query.append("\n ORDER BY time_from");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, contractId);
            if (date != null) {
                Timestamp sqlTime = TimeUtils.convertDateToTimestamp((Date)date);
                ps.setTimestamp(2, sqlTime);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs, true));
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public ContractTariffOptionList getContractRealtimeTariffOptionList(int contractId, Date fromTime) throws SQLException {
        return ContractTariffOptionDao.getContractRealtimeTariffOptionList(this.con, contractId, fromTime);
    }

    public static ContractTariffOptionList getContractRealtimeTariffOptionList(Connection con, int contractId, Date fromTime) throws SQLException {
        ArrayList<ContractTariffOptionList.OptionItem> result = new ArrayList<ContractTariffOptionList.OptionItem>();
        StringBuilder query = new StringBuilder();
        query.append("SELECT time_from, time_to, option_id, id FROM ");
        query.append("contract_tariff_option");
        query.append(" WHERE cid=? AND (time_to IS NULL OR (?<=time_to AND time_from<time_to)) ORDER BY time_from");
        PreparedStatement ps = con.prepareStatement(query.toString());
        ps.setInt(1, contractId);
        ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)fromTime));
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(new ContractTariffOptionList.OptionItem(rs.getInt(3), rs.getInt(4), rs.getTimestamp(1), rs.getTimestamp(2)));
        }
        rs.close();
        ps.close();
        return new ContractTariffOptionList(result);
    }

    public ContractTariffOptionList getRoundContractRealtimeTariffOptionList(int contractId, Date fromTime) throws SQLException {
        return ContractTariffOptionDao.getRoundContractRealtimeTariffOptionList(this.con, contractId, fromTime);
    }

    public static ContractTariffOptionList getRoundContractRealtimeTariffOptionList(Connection con, int contractId, Date fromTime) throws SQLException {
        ArrayList<ContractTariffOptionList.OptionItem> result = new ArrayList<ContractTariffOptionList.OptionItem>();
        StringBuilder query = new StringBuilder();
        query.append("SELECT time_from, time_to, option_id, id FROM ");
        query.append("contract_tariff_option");
        query.append(" WHERE cid=? AND (time_to IS NULL OR (?<=time_to AND time_from<time_to)) ORDER BY time_from");
        PreparedStatement ps = con.prepareStatement(query.toString());
        ps.setInt(1, contractId);
        ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)fromTime));
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Timestamp from = rs.getTimestamp(1);
            Timestamp to = rs.getTimestamp(2);
            long timeFrom = from != null ? from.getTime() - from.getTime() % 3600000L : 0L;
            long timeTo = to != null ? to.getTime() - 1L : 0L;
            result.add(new ContractTariffOptionList.OptionItem(rs.getInt(3), rs.getInt(4), timeFrom, timeTo));
        }
        rs.close();
        ps.close();
        return new ContractTariffOptionList(result);
    }

    private ContractTariffOption getFromRS(ResultSet rs, boolean titleLoad) throws SQLException {
        ContractTariffOption contractOption = new ContractTariffOption();
        contractOption.setId(rs.getInt("id"));
        contractOption.setContractId(rs.getInt("cid"));
        contractOption.setTimeFrom(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("time_from")));
        contractOption.setTimeTo(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("time_to")));
        contractOption.setOptionId(rs.getInt("option_id"));
        contractOption.setOptionComment(rs.getString("option_comment"));
        contractOption.setActivatedMode(rs.getInt("activated_mode"));
        contractOption.setActivatedTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("activated_time")));
        contractOption.setDeactivatedTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("deactivated_time")));
        contractOption.setChargeId(rs.getInt("charge_id"));
        contractOption.setSum(rs.getBigDecimal("summa"));
        contractOption.setUserId(rs.getInt("uid"));
        User user = UserMap.getUser(contractOption.getUserId());
        contractOption.setUserTitle(user != null ? user.getTitle() : "");
        if (titleLoad) {
            contractOption.setOptionTitle(rs.getString("to.title"));
        }
        return contractOption;
    }

    protected ContractTariffOption getFromRS(ResultSet rs) throws SQLException {
        return this.getFromRS(rs, false);
    }

    public void update(ContractTariffOption b) throws BGException {
        super.update((Object)b);
    }

    public void update(ContractTariffOption b, boolean checkDeactivated) throws BGException {
        try {
            this.updateImpl(b, checkDeactivated);
        }
        catch (SQLException e) {
            this.processException(e);
        }
    }

    protected void updateImpl(ContractTariffOption contractOption) throws BGException, SQLException {
        this.updateImpl(contractOption, true);
    }

    protected void updateImpl(ContractTariffOption contractOption, boolean checkDeactivated) throws BGException, SQLException {
        boolean timeToNotNull;
        boolean update = contractOption.getId() > 0;
        boolean bl = timeToNotNull = contractOption.getTimeTo() != null;
        String where = timeToNotNull ? (checkDeactivated ? " AND time_to IS NULL" : "") : " AND (time_to IS NOT NULL AND deactivated_time IS NOT NULL)";
        String query = (update ? "UPDATE " : "INSERT INTO ") + "contract_tariff_option" + (String)(update ? " SET time_to=?, deactivated_time=? WHERE id=?" + where : " SET cid=?, time_from=?, time_to=?, option_id=?, activated_mode=?, activated_time=?, deactivated_time=?, charge_id=?, summa=?, uid=?, option_comment=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            if (update) {
                ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)contractOption.getTimeTo()));
                if (timeToNotNull) {
                    ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)contractOption.getTimeTo()));
                    ps.setInt(3, contractOption.getId());
                    if (ps.executeUpdate() == 0) {
                        throw new BGMessageException("\u041e\u043f\u0446\u0438\u044f \u0443\u0436\u0435 \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430!");
                    }
                } else {
                    ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)contractOption.getDeactivatedTime()));
                    ps.setInt(3, contractOption.getId());
                    if (ps.executeUpdate() == 0) {
                        throw new BGMessageException("\u042d\u0442\u0443 \u043e\u043f\u0446\u0438\u044e \u043d\u0435\u043b\u044c\u0437\u044f \u0440\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c!");
                    }
                }
            } else {
                int index = 1;
                ps.setInt(index++, contractOption.getContractId());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)contractOption.getTimeFrom()));
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)contractOption.getTimeTo()));
                ps.setInt(index++, contractOption.getOptionId());
                ps.setInt(index++, contractOption.getActivatedMode());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)contractOption.getActivatedTime()));
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)contractOption.getDeactivatedTime()));
                ps.setInt(index++, contractOption.getChargeId());
                ps.setBigDecimal(index++, contractOption.getSum());
                ps.setInt(index++, contractOption.getUserId());
                ps.setString(index++, contractOption.getOptionComment());
                ps.executeUpdate();
                contractOption.setId(ServerUtils.lastInsertId(ps));
            }
        }
    }
}

