/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Calendar;
import ru.bitel.common.TimeUtils;

public abstract class ServiceCost {
    protected int serviceId = 0;
    protected Calendar date1;
    protected Calendar date2;
    protected Calendar serviceStart;
    protected Calendar serviceEnd;
    protected int accountingPeriodDays;
    protected long amount = 0L;
    protected BigDecimal cost;
    public boolean amountNull = false;

    protected ServiceCost() {
    }

    protected String paramsToString() {
        StringBuilder result = new StringBuilder();
        result.append("serviceId: ");
        result.append(this.serviceId);
        result.append("; date1: ");
        result.append(TimeUtils.formatDate((Calendar)this.date1));
        result.append("; date2: ");
        result.append(TimeUtils.formatDate((Calendar)this.date2));
        result.append("; serviceStart: ");
        result.append(TimeUtils.formatDate((Calendar)this.serviceStart));
        result.append("; serviceEnd: ");
        result.append(TimeUtils.formatDate((Calendar)this.serviceEnd));
        result.append("; accountingPeriodDays: ");
        result.append(this.accountingPeriodDays);
        result.append("; amount: ");
        result.append(this.amount);
        result.append("; cost: ");
        result.append(this.cost);
        return result.toString();
    }

    public ServiceCost newCost() {
        ServiceCost result = this.newCostInternal();
        result.amountNull = this.amountNull;
        return result;
    }

    protected ServiceCost newCostInternal() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder result = new StringBuilder(100);
        result.append("ServiceCost [");
        result.append(this.paramsToString());
        result.append("]");
        return result.toString();
    }

    public void setServiceId(int serviceId) {
        this.serviceId = serviceId;
    }

    public int getServiceId() {
        return this.serviceId;
    }

    public long getAmount() {
        return this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public Calendar getDate1() {
        return this.date1;
    }

    public Calendar getDate2() {
        return this.date2;
    }

    public void setDate1(Calendar date1) {
        this.date1 = date1;
        if (this.date1 != null && this.date2 != null) {
            this.accountingPeriodDays = this.date2.get(5) - this.date1.get(5) + 1;
        }
    }

    public void setDate2(Calendar date2) {
        this.date2 = date2;
        if (this.date1 != null && this.date2 != null) {
            this.accountingPeriodDays = this.date2.get(5) - this.date1.get(5) + 1;
        }
    }

    public void setDate1(LocalDate date) {
        this.setDate1(TimeUtils.convertLocalDateToCalendar((LocalDate)date));
    }

    public void setDate2(LocalDate date) {
        this.setDate2(TimeUtils.convertLocalDateToCalendar((LocalDate)date));
    }

    public Calendar getServiceStart() {
        return this.serviceStart;
    }

    public Calendar getServiceEnd() {
        return this.serviceEnd;
    }

    public void setServiceStart(Calendar serviceStart) {
        this.serviceStart = serviceStart;
    }

    public void setServiceEnd(Calendar serviceEnd) {
        this.serviceEnd = serviceEnd;
    }

    public void setServiceStart(LocalDate serviceStart) {
        this.setServiceStart(TimeUtils.convertLocalDateToCalendar((LocalDate)serviceStart));
    }

    public void setServiceEnd(LocalDate serviceEnd) {
        this.setServiceEnd(TimeUtils.convertLocalDateToCalendar((LocalDate)serviceEnd));
    }

    public int getAccountingPeriodDays() {
        return this.accountingPeriodDays;
    }

    public void setAccountingPeriodDays(int accountingPeriodDays) {
        this.accountingPeriodDays = accountingPeriodDays;
    }

    public BigDecimal getCost() {
        return this.cost;
    }

    public void setCost(BigDecimal cost) {
        this.cost = cost;
    }
}

