/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.client;

import bitel.billing.module.common.BGControlPanelPeriodNavigation;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.task.common.bean.LightweightTaskData;
import ru.bitel.bgbilling.kernel.task.common.bean.SchedulerTaskLog;
import ru.bitel.bgbilling.kernel.task.common.service.SchedulerService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.SearchResult;

public class SchedulerStatisticPanel
extends BGUPanel {
    private BGUTable statisticTable;
    private SchedulerTaskLogTableModel tableModel;
    private BGControlPanelPages page;
    private JLabel recordCountLabel;
    private BGControlPanelPeriodNavigation periodPanel;
    private BGUComboBox<LightweightTaskData> taskFilter;
    private SchedulerService schedulerService;

    public SchedulerStatisticPanel(ClientContext context) {
        super((LayoutManager)new GridBagLayout(), context);
    }

    protected void jbInit() throws Exception {
        this.tableModel = new SchedulerTaskLogTableModel();
        this.statisticTable = new BGUTable((TableModel)((Object)this.tableModel));
        this.periodPanel = new BGControlPanelPeriodNavigation();
        this.taskFilter = new BGUComboBox();
        this.page = new BGControlPanelPages();
        this.recordCountLabel = new JLabel();
        this.periodPanel.setDateFrom(TimeUtils.getStartMonth((Date)new Date()));
        this.periodPanel.setDateTo(TimeUtils.getEndMonth((Date)new Date()));
        List<LightweightTaskData> taskList = this.getSchedulerService().getSchedulerTasks(null);
        taskList.add(0, new LightweightTaskData(-1, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e"));
        this.taskFilter.setModel(this.getTaskList(taskList));
        JPanel pagePanel = new JPanel(new GridBagLayout());
        pagePanel.add((Component)this.recordCountLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        pagePanel.add((Component)this.page, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 10, 3, 3), 0, 0));
        this.add(this.getFilterPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.add(pagePanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 3, 3), 0, 0));
        this.add(new JScrollPane((Component)this.statisticTable), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 3, 3, 3), 0, 0));
        PropertyChangeListener listener = e -> this.performAction("refresh");
        this.periodPanel.addPropertyChangeListener(listener);
        this.page.addPropertyChangeListener(listener);
        this.taskFilter.addActionListener(e -> {
            this.page.setPageIndex(1);
            this.performAction("refresh");
        });
    }

    private JPanel getFilterPanel() {
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("\u0424\u0438\u043b\u044c\u0442\u0440"));
        panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434: "), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 5, 0), 0, 0));
        panel.add((Component)this.periodPanel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 5, 0), 0, 0));
        panel.add((Component)new JLabel("\u0417\u0430\u0434\u0430\u0447\u0430: "), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 15, 5, 0), 0, 0));
        panel.add((Component)this.taskFilter, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 5, 5, 5), 0, 0));
        return panel;
    }

    private SchedulerService getSchedulerService() {
        if (this.schedulerService == null) {
            this.schedulerService = (SchedulerService)((ClientContext)this.getContext()).getPort(SchedulerService.class);
        }
        return this.schedulerService;
    }

    private DefaultComboBoxModel<LightweightTaskData> getTaskList(List<LightweightTaskData> taskList) {
        for (LightweightTaskData lightweightTaskData : taskList) {
            lightweightTaskData.setTitle(String.format("[#%d] %s", lightweightTaskData.getId(), lightweightTaskData.getTitle()));
        }
        return new DefaultComboBoxModel<LightweightTaskData>(taskList.toArray(new LightweightTaskData[0]));
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                LightweightTaskData selectedTask = (LightweightTaskData)SchedulerStatisticPanel.this.taskFilter.getSelectedItem();
                SearchResult<SchedulerTaskLog> result = SchedulerStatisticPanel.this.getSchedulerService().getTaskLog(selectedTask.getId(), SchedulerStatisticPanel.this.periodPanel.getPeriod(), SchedulerStatisticPanel.this.page.getPage());
                SchedulerStatisticPanel.this.tableModel.setData(result.getList());
                SchedulerStatisticPanel.this.page.setPage(result.getPage());
                SchedulerStatisticPanel.this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + result.getPage().getRecordCount());
            }
        };
    }

    class SchedulerTaskLogTableModel
    extends BGTableModel<SchedulerTaskLog> {
        private static final long msPerHour = 3600000L;
        private static final long msPerMin = 60000L;
        private DecimalFormat hourMinSecFormat;
        private DecimalFormat msFormat;

        public SchedulerTaskLogTableModel() {
            super(SchedulerTaskLogTableModel.class.getName());
            this.hourMinSecFormat = new DecimalFormat("00");
            this.msFormat = new DecimalFormat("000");
        }

        protected void initColumns() {
            this.addColumn("\u041a\u043e\u0434 \u0437\u0430\u0434\u0430\u0447\u0438", 100, 100, 100, "taskId", true).setTableCellRenderer((TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", -1, -1, -1, "taskTitle", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0412\u0440\u0435\u043c\u044f \u0437\u0430\u043f\u0443\u0441\u043a\u0430", 200, 200, 200, "startTime", true).setTableCellRenderer((TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy HH:mm:ss.SSS"));
            this.addColumn("\u0412\u0440\u0435\u043c\u044f \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f", 200, 200, 200, "finishTime", true).setTableCellRenderer((TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy HH:mm:ss.SSS"));
            this.addColumn("\u0412\u0440\u0435\u043c\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f, \u0427:\u041c:\u0421.\u043c\u0441", 200, 200, 200, "duration", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValue(SchedulerTaskLog val, int column) throws BGException {
            switch (column) {
                case 2: {
                    return new Date(val.getStartTime());
                }
                case 3: {
                    return new Date(val.getFinishTime());
                }
                case 4: {
                    long duration = val.getDuration();
                    long hour = duration / 3600000L;
                    long min = (duration - hour * 3600000L) / 60000L;
                    long sec = (duration - hour * 3600000L - min * 60000L) / 1000L;
                    long ms = duration % 1000L;
                    String result = this.hourMinSecFormat.format(hour) + ":" + this.hourMinSecFormat.format(min) + ":" + this.hourMinSecFormat.format(sec) + "." + this.msFormat.format(ms);
                    return result;
                }
            }
            super.getValue((Object)val, column);
            return super.getValue((Object)val, column);
        }
    }
}

