/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.task.common.bean.PeriodicTask;
import ru.bitel.bgbilling.kernel.task.common.bean.RunningTask;
import ru.bitel.bgbilling.kernel.task.common.service.SchedulerService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;

public class SchedulerStatusPanel
extends BGUPanel {
    private SchedulerService schedulerService = null;
    private RunningTaskTableModel tableHardTasksModel;
    private PeriodicTaskTableModel tablePeriodicTasksModel;

    public SchedulerStatusPanel(ClientContext clientContext) {
        super(clientContext);
    }

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.getPeriodicTasksPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getHardTasksPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a\u0430"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                SchedulerStatusPanel.this.tableHardTasksModel.setData(SchedulerStatusPanel.this.getSchedulerService().getRunningTaskList());
                SchedulerStatusPanel.this.tablePeriodicTasksModel.setData(SchedulerStatusPanel.this.getSchedulerService().getPeriodicTaskList());
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                RunningTask selectedTask = (RunningTask)((Object)SchedulerStatusPanel.this.tableHardTasksModel.getSelectedRow());
                if (selectedTask != null) {
                    if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u0430\u0434\u0430\u0447\u0443 \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                        SchedulerStatusPanel.this.getSchedulerService().deleteCurrentRunTask(selectedTask.getId());
                        SchedulerStatusPanel.this.performAction("refresh");
                    }
                } else {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0430\u0434\u0430\u0447\u0443 \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \u0442\u044f\u0436\u0435\u043b\u044b\u0445 \u0437\u0430\u0434\u0430\u0447!");
                }
            }
        };
    }

    private SchedulerService getSchedulerService() {
        if (this.schedulerService == null) {
            this.schedulerService = (SchedulerService)((ClientContext)this.getContext()).getPort(SchedulerService.class);
        }
        return this.schedulerService;
    }

    private JPanel getPeriodicTasksPanel() {
        this.tablePeriodicTasksModel = new PeriodicTaskTableModel(PeriodicTaskTableModel.class.getName());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u043c\u044b\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0437\u0430\u0434\u0430\u0447\u0438"));
        panel.add((Component)new JScrollPane((Component)new BGUTable((TableModel)((Object)this.tablePeriodicTasksModel))), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getHardTasksPanel() {
        this.tableHardTasksModel = new RunningTaskTableModel(RunningTaskTableModel.class.getName());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder("\u041e\u0447\u0435\u0440\u0435\u0434\u044c \u0442\u044f\u0436\u0435\u043b\u044b\u0445 \u0437\u0430\u0434\u0430\u0447"));
        panel.add((Component)new JScrollPane((Component)new BGUTable((TableModel)((Object)this.tableHardTasksModel))), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    static class PeriodicTaskTableModel
    extends BGTableModel<PeriodicTask> {
        public PeriodicTaskTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u2116", 50, 50, 50, "id", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", -1, -1, -1, "description", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e", 100, 150, 200, "amount", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
        }
    }

    static class RunningTaskTableModel
    extends BGTableModel<RunningTask> {
        public RunningTaskTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u2116", 50, 50, 50, "id", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", -1, -1, -1, "description", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 200, 200, 200, "status", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0412\u0440\u0435\u043c\u044f \u0437\u0430\u043f\u0443\u0441\u043a\u0430", 200, 200, 200, "startTime", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValue(RunningTask val, int column) throws BGException {
            if (column == 3 && val.getStartTime() != null) {
                return TimeUtils.formatFullDate((Date)val.getStartTime());
            }
            return super.getValue((Object)val, column);
        }
    }
}

