/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.dbcp;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import ru.bitel.bgbilling.server.dbcp.PoolGuardConnectionWrapper;
import ru.bitel.common.jmx.MBeanAttribute;

public final class DatabaseConnectionPool {
    private final GenericObjectPool<Connection> pool;
    private final PoolingDataSource dataSource;

    public DatabaseConnectionPool(GenericObjectPool<Connection> pool) {
        this.pool = pool;
        this.dataSource = new PoolingDataSource((ObjectPool)pool){

            public Connection getConnection() throws SQLException {
                try {
                    Connection conn = (Connection)this._pool.borrowObject();
                    if (conn != null) {
                        conn = new PoolGuardConnectionWrapper((DelegatingConnection)conn);
                    }
                    return conn;
                }
                catch (SQLException e) {
                    throw e;
                }
                catch (NoSuchElementException e) {
                    throw new SQLNestedException("Cannot get a connection, pool error " + e.getMessage(), (Throwable)e);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SQLNestedException("Cannot get a connection, general error", (Throwable)e);
                }
            }
        };
    }

    @MBeanAttribute
    public boolean isOverload() {
        return this.pool.getMaxActive() <= this.pool.getNumActive();
    }

    @MBeanAttribute
    public float getLoadRatio() {
        return (float)this.pool.getNumActive() / (float)this.pool.getMaxActive();
    }

    @MBeanAttribute
    public int getMaxActive() {
        return this.pool.getMaxActive();
    }

    public void setMaxActive(int maxActive) {
        this.pool.setMaxActive(maxActive);
    }

    @MBeanAttribute
    public byte getWhenExhaustedAction() {
        return this.pool.getWhenExhaustedAction();
    }

    public void setWhenExhaustedAction(byte whenExhaustedAction) {
        this.pool.setWhenExhaustedAction(whenExhaustedAction);
    }

    @MBeanAttribute
    public long getMaxWait() {
        return this.pool.getMaxWait();
    }

    public void setMaxWait(long maxWait) {
        this.pool.setMaxWait(maxWait);
    }

    @MBeanAttribute
    public int getMaxIdle() {
        return this.pool.getMaxIdle();
    }

    public void setMaxIdle(int maxIdle) {
        this.pool.setMaxIdle(maxIdle);
    }

    public void setMinIdle(int minIdle) {
        this.pool.setMinIdle(minIdle);
    }

    @MBeanAttribute
    public int getMinIdle() {
        return this.pool.getMinIdle();
    }

    @MBeanAttribute
    public boolean getTestOnBorrow() {
        return this.pool.getTestOnBorrow();
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.pool.setTestOnBorrow(testOnBorrow);
    }

    @MBeanAttribute
    public boolean getTestOnReturn() {
        return this.pool.getTestOnReturn();
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.pool.setTestOnReturn(testOnReturn);
    }

    @MBeanAttribute
    public long getTimeBetweenEvictionRunsMillis() {
        return this.pool.getTimeBetweenEvictionRunsMillis();
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.pool.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
    }

    @MBeanAttribute
    public int getNumTestsPerEvictionRun() {
        return this.pool.getNumTestsPerEvictionRun();
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.pool.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
    }

    @MBeanAttribute
    public long getMinEvictableIdleTimeMillis() {
        return this.pool.getMinEvictableIdleTimeMillis();
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.pool.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
    }

    @MBeanAttribute
    public long getSoftMinEvictableIdleTimeMillis() {
        return this.pool.getSoftMinEvictableIdleTimeMillis();
    }

    public void setSoftMinEvictableIdleTimeMillis(long softMinEvictableIdleTimeMillis) {
        this.pool.setSoftMinEvictableIdleTimeMillis(softMinEvictableIdleTimeMillis);
    }

    @MBeanAttribute
    public boolean getTestWhileIdle() {
        return this.pool.getTestWhileIdle();
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.pool.setTestWhileIdle(testWhileIdle);
    }

    @MBeanAttribute
    public boolean getLifo() {
        return this.pool.getLifo();
    }

    public void setLifo(boolean lifo) {
        this.pool.setLifo(lifo);
    }

    @MBeanAttribute
    public int getNumActive() {
        return this.pool.getNumActive();
    }

    @MBeanAttribute
    public int getNumIdle() {
        return this.pool.getNumIdle();
    }

    public GenericObjectPool<Connection> getPool() {
        return this.pool;
    }

    public PoolingDataSource getDataSource() {
        return this.dataSource;
    }
}

