/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.util;

import bitel.billing.server.admin.bean.AddressManager;
import bitel.billing.server.contract.ContractRemover;
import bitel.billing.server.contract.bean.CommentPatternManager;
import bitel.billing.server.contract.bean.ContractAddressParamValue;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractParameterManager;
import bitel.billing.server.tariff.TariffTreeBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.server.bean.ContractParameterPrefDao;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.server.utils.AddressUtils;

public class ScriptUtils
implements AutoCloseable {
    private DefaultServerSetup setup;
    private Connection con;
    private ContractParameterPrefDao _contractParameterPrefDao;
    private ContractParameterManager _contractParameterManager;
    private ContractTariffDao _contractTariffDao;
    private ContractRemover _remover;
    private ContractManager _contractManager;

    public ScriptUtils(DefaultServerSetup setup, Connection con) {
        this.setup = setup;
        this.con = con;
    }

    public ScriptUtils(Connection con) {
        this(Setup.getSetup(), con);
    }

    private ContractParameterPrefDao contractParameterPrefDao() {
        if (this._contractParameterPrefDao == null) {
            this._contractParameterPrefDao = new ContractParameterPrefDao(this.con);
        }
        return this._contractParameterPrefDao;
    }

    private ContractParameterManager contractParameterManager() {
        if (this._contractParameterManager == null) {
            this._contractParameterManager = new ContractParameterManager(this.con);
        }
        return this._contractParameterManager;
    }

    private ContractTariffDao contractTariffDao() {
        if (this._contractTariffDao == null) {
            this._contractTariffDao = new ContractTariffDao(this.con);
        }
        return this._contractTariffDao;
    }

    private ContractRemover contractRemover() {
        if (this._remover == null) {
            this._remover = new ContractRemover(this.con, null);
        }
        return this._remover;
    }

    private ContractManager contractManager() {
        if (this._contractManager == null) {
            this._contractManager = new ContractManager(this.con);
        }
        return this._contractManager;
    }

    @Override
    public void close() throws BGException {
        if (this._contractParameterPrefDao != null) {
            this._contractParameterPrefDao.close();
        }
        if (this._contractParameterManager != null) {
            this._contractParameterManager.close();
        }
        if (this._contractTariffDao != null) {
            this._contractTariffDao.close();
        }
        if (this._remover != null) {
            this._remover.close();
        }
        if (this._contractManager != null) {
            this._contractManager.close();
        }
    }

    public void addContractParameter(int contractId, int parameterId, String value) throws BGException {
        this.addContractParameter(contractId, parameterId, value, null);
    }

    public void addContractParameter(int contractId, int parameterId, String value, String comment) throws BGException {
        if (Utils.isEmptyString((String)value)) {
            return;
        }
        ContractParameterPrefDao contractParameterPrefDao = this.contractParameterPrefDao();
        ContractParameterManager contractParameterManager = this.contractParameterManager();
        ContractParameterPref cpp = (ContractParameterPref)contractParameterPrefDao.get(parameterId);
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            switch (cpp.getType()) {
                case TYPE_TEXT: {
                    contractDao.updateContractParameter(contractId, (EntityAttr)new EntityAttrText(contractId, parameterId, value));
                    return;
                }
                case TYPE_EMAIL: {
                    EntityAttrEmail attrEmail = contractDao.getContractParameterEmail(contractId, parameterId).orElse(new EntityAttrEmail(contractId, parameterId));
                    attrEmail.addContact(value, comment);
                    contractDao.updateContractParameter(contractId, (EntityAttr)attrEmail);
                    return;
                }
                case TYPE_DATE: {
                    if (Utils.isBlankString((String)comment)) {
                        comment = "dd.MM.yyyy";
                    }
                    Date date = TimeUtils.parseDate((String)value, (String)comment);
                    contractDao.updateContractParameter(contractId, (EntityAttr)new EntityAttrDate(contractId, parameterId, date));
                    return;
                }
                case TYPE_PHONE: {
                    EntityAttrPhone attrPhone = contractDao.getContractParameterPhone(contractId, parameterId).orElse(new EntityAttrPhone(contractId, parameterId));
                    attrPhone.addContact(value, comment);
                    contractDao.updateContractParameter(contractId, (EntityAttr)attrPhone);
                    return;
                }
                case TYPE_FLAG: {
                    contractDao.updateContractParameter(contractId, (EntityAttr)new EntityAttrBoolean(contractId, parameterId, Utils.parseBoolean((String)value)));
                    return;
                }
                case TYPE_LIST: {
                    int foundId = -1;
                    try {
                        String query = "SELECT id, title FROM contract_parameter_type_7_values WHERE pid=?";
                        PreparedStatement ps = this.con.prepareStatement(query);
                        ps.setInt(1, parameterId);
                        ResultSet rs = ps.executeQuery();
                        while (rs.next()) {
                            int id = rs.getInt(1);
                            String title = rs.getString(2);
                            if (!Utils.notBlankString((String)title) || !value.trim().equalsIgnoreCase(title.trim())) continue;
                            foundId = id;
                            break;
                        }
                        rs.close();
                        ps.close();
                    }
                    catch (Exception e) {
                        throw new BGException("error get list values", (Throwable)e);
                    }
                    if (foundId > 0) {
                        contractDao.updateContractParameter(contractId, (EntityAttr)new EntityAttrList(contractId, parameterId, foundId, ""));
                    } else {
                        throw new BGMessageException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 (" + value + ") \u0434\u043b\u044f pid=" + parameterId + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e, cid=" + contractId);
                    }
                    return;
                }
            }
            throw new RuntimeException("unsupported type '" + cpp.getType() + "' parameter " + parameterId);
        }
    }

    public String getContractParameter(int contractId, int parameterId) throws BGException {
        ContractParameterPrefDao contractParameterPrefDao = this.contractParameterPrefDao();
        ContractParameterManager contractParameterManager = this.contractParameterManager();
        ContractParameterPref cpp = (ContractParameterPref)contractParameterPrefDao.get(parameterId);
        if (cpp == null) {
            throw new BGException("parameter pid=" + parameterId + " not found");
        }
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            switch (cpp.getType()) {
                case TYPE_TEXT: {
                    String string = contractDao.getContractParameterTextAsString(contractId, parameterId).orElse(null);
                    return string;
                }
                case TYPE_EMAIL: 
                case TYPE_PHONE: {
                    String string = contractParameterManager.getTextlikeParam(contractId, parameterId);
                    return string;
                }
                case TYPE_FLAG: {
                    String string = contractDao.getContractParameterBoolean(contractId, parameterId, false).toString();
                    return string;
                }
                case TYPE_LIST: {
                    String string = contractDao.getContractParameterListAsString(contractId, parameterId).orElse(null);
                    return string;
                }
                case TYPE_MULTILIST: {
                    String string = contractDao.getContractParameterMultiListAsString(contractId, parameterId).orElse(null);
                    return string;
                }
            }
            throw new BGException("unsupported type '" + cpp.getType() + "' parameter " + parameterId);
        }
    }

    public AddressStruct getContractParameterAddress(int contractId, int pidAddress) {
        return new AddressManager(this.con).getAddress(contractId, pidAddress);
    }

    public void addContractAddressParameter(int cid, int pid, int countryId, int cityId, int streetId, int houseId, String flat, String streetUserValue, String houseUserValue) throws Exception {
        String comment = "";
        ContractAddressParamValue capValue = new ContractAddressParamValue();
        if (houseId > 0) {
            AddressStruct addressStruct = AddressUtils.getAddressStruct(this.con, houseId, flat, "", null, null, comment);
            capValue.setHouseId(houseId);
            capValue.setFlat(addressStruct.getFlat());
            capValue.setRoom(addressStruct.getRoom());
            capValue.setPod(0);
            capValue.setFloor(0);
            capValue.setComment(addressStruct.getComment());
            capValue.setFormatKey("0");
            String fullAddress = AddressUtils.getAddress(this.setup, addressStruct, "0");
            capValue.setAddress(fullAddress);
        } else {
            capValue.setHouseId(0);
            capValue.setFlat(null);
            capValue.setRoom("");
            capValue.setPod(0);
            capValue.setFloor(0);
            capValue.setComment(comment);
            capValue.setFormatKey(null);
            String fullAddress = streetUserValue + ", " + houseUserValue + " - " + flat;
            capValue.setAddress(fullAddress);
        }
        this.contractParameterManager().updateAddressParam(cid, pid, capValue, 0);
        new CommentPatternManager(this.con).updateContractComment(cid);
    }

    public Map<String, Integer> getBillingTariffMap() throws SQLException {
        HashMap<String, Integer> tarifMap = new HashMap<String, Integer>();
        String query = "SELECT id, title FROM tariff_plan";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            tarifMap.put(rs.getString(2).toLowerCase(), rs.getInt(1));
        }
        rs.close();
        ps.close();
        return tarifMap;
    }

    public int addNewTariff(String title) throws SQLException {
        int treeId = new TariffTreeBuilder(this.con).createTree();
        String query = "INSERT INTO tariff_plan ( title, tree_id ) values ( ?, ? )";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setString(1, title);
        ps.setInt(2, treeId);
        ps.executeUpdate();
        int tpId = ServerUtils.lastInsertId(this.con);
        ps.close();
        return tpId;
    }

    public void addContractTariff(int cid, int tariffId, Date date1, String comment) throws BGException {
        ContractTariff contractTariff = new ContractTariff();
        contractTariff.setContractId(cid);
        contractTariff.setTariffPlanId(tariffId);
        contractTariff.getPeriod().setDateFrom(date1);
        contractTariff.setComment(comment);
        this.contractTariffDao().update(contractTariff);
    }

    public void addContractGroup(int contractId, int groupId) throws BGException {
        this.contractManager().addContractGroup(contractId, groupId);
    }

    public void deleteContractGroup(int contractId, int groupId) throws BGException {
        this.contractManager().deleteContractGroup(contractId, groupId);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean checkOnGroup(int contractId, long contractGroups) throws BGException {
        try {
            String query = "SELECT id FROM contract WHERE id=" + contractId + " AND contract.gr&" + contractGroups + ">0 ";
            try (Statement ps = this.con.createStatement();){
                boolean bl;
                block14: {
                    ResultSet rs = ps.executeQuery(query);
                    try {
                        bl = rs.next();
                        if (rs == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return bl;
            }
        }
        catch (SQLException e) {
            throw new BGException("error sql check on group", (Throwable)e);
        }
    }

    public int removeContracts(int group) throws SQLException, BGException {
        return this.removeContracts(Utils.enumToMask((String)String.valueOf(group)));
    }

    public int removeContracts(long groups) throws SQLException, BGException {
        return this.removeContracts(groups, null);
    }

    public int removeContracts(long groups, String exceptIds) throws SQLException, BGException {
        ContractRemover remover = this.contractRemover();
        Object query = "SELECT id FROM contract WHERE gr & ? > 0 ";
        if (Utils.notBlankString((String)exceptIds)) {
            query = (String)query + " AND id NOT IN (" + exceptIds + ")";
        }
        int count = 0;
        try (PreparedStatement ps = this.con.prepareStatement((String)query);){
            ps.setLong(1, groups);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int cid = rs.getInt(1);
                    remover.removeContract(cid, false);
                    ++count;
                    if (this.con.getAutoCommit()) continue;
                    this.con.commit();
                }
            }
        }
        return count;
    }

    public void removeContractsMultiThread(int group, String exceptIds, int theadCount) throws SQLException, BGException {
        long groups = Utils.enumToMask((String)String.valueOf(group));
        Object query = "SELECT id FROM contract WHERE gr & ? > 0 ";
        if (Utils.notBlankString((String)exceptIds)) {
            query = (String)query + " AND id NOT IN (" + exceptIds + ")";
        }
        ScheduledExecutorService service = Executors.newScheduledThreadPool(theadCount);
        ArrayList<RemoveThread> threads = new ArrayList<RemoveThread>();
        for (int i = 0; i < theadCount; ++i) {
            RemoveThread thread = new RemoveThread((Setup)this.setup);
            threads.add(thread);
            service.execute(thread);
        }
        try (PreparedStatement ps = this.con.prepareStatement((String)query);){
            ps.setLong(1, groups);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int cid = rs.getInt(1);
                    int idx = cid % theadCount;
                    ((RemoveThread)threads.get(idx)).addContract(cid);
                }
            }
            for (int i = 0; i < theadCount; ++i) {
                ((RemoveThread)threads.get(i)).finish();
            }
            service.shutdown();
            service.awaitTermination(5L, TimeUnit.HOURS);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static class RemoveThread
    implements Runnable {
        BlockingQueue<Integer> queue = new LinkedBlockingQueue<Integer>();
        private final Setup setup;

        public RemoveThread(Setup setup) {
            this.setup = setup;
        }

        public void addContract(int contractId) throws InterruptedException {
            this.queue.put(contractId);
        }

        public void finish() throws InterruptedException {
            this.queue.put(-1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ServerContext context = null;
            ThreadContext parentContext = null;
            try {
                try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);
                     Connection con = connectionSet.getConnection();
                     ContractRemover remover = new ContractRemover(con, null);){
                    context = new ServerContext(this.setup, connectionSet, 0, 0);
                    parentContext = ServerContext.push((ThreadContext)context);
                    Integer cid = null;
                    while ((cid = this.queue.take()) != -1) {
                        remover.removeContract(cid, false);
                        if (con.getAutoCommit()) continue;
                        con.commit();
                    }
                }
                ServerContext.pop((ThreadContext)context, (ThreadContext)parentContext);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                ServerContext.pop(context, parentContext);
            }
        }
    }
}

