/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.function.Function;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.CityItem;
import ru.bitel.oss.kernel.directories.address.server.bean.AbstractAddressDao;

abstract class AbstractCityItemDao<B extends CityItem>
extends AbstractAddressDao<B>
implements Directory<B> {
    public AbstractCityItemDao(Connection con, String tableName) {
        super(con, tableName);
    }

    protected B getFromRS(ResultSet rs) throws SQLException, BGException {
        City city = new City();
        city.setId(rs.getInt("cityid"));
        CityItem result = (CityItem)super.getBaseFromRS(rs);
        result.setCity(city);
        return (B)result;
    }

    protected void updateImpl(B b) throws BGException, SQLException {
        CityItem old = b.getId() > 0 ? (CityItem)this.get(b.getId()) : null;
        boolean update = old != null;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET cityid=?, title=?" + (update ? " WHERE " : ", ") + "id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, b.getCity().getId());
            ps.setString(index++, b.getTitle());
            ps.setInt(index++, b.getId());
            ps.executeUpdate();
            if (!update) {
                b.setId(ServerUtils.lastInsertId(ps));
            }
        }
    }

    @Override
    public List<B> list() throws BGException {
        return super.list(null, "title", new Object[0]);
    }

    @Override
    public B get(String title) throws BGException {
        return (B)((CityItem)super.get("title=?", new Object[]{title}));
    }

    public B get(String title, int cityId) throws BGException {
        return (B)((CityItem)super.get("title=? AND cityid=?", new Object[]{title, cityId}));
    }

    public List<B> list(int cityId, String title) throws BGException {
        return super.list("(? OR cityid=?) AND (? OR title LIKE ?)", "title", new Object[]{cityId <= 0, cityId, Utils.isBlankString((String)title), title + "%"});
    }

    protected <T> void searchStreetList(SearchResult<T> searchResult, int cityId, String mask, Function<ResultSet, T> function) {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List list = searchResult.getList();
            String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " AS item WHERE true" + (cityId > 0 ? " AND item.cityid=?" : "") + (mask != null && !mask.isEmpty() ? " AND item.title LIKE ?" : "") + " ORDER BY item.title" + (page != null ? page.sqlLimit() : "");
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                if (cityId > 0) {
                    ps.setInt(index++, cityId);
                }
                if (mask != null && !mask.isEmpty()) {
                    ps.setString(index++, mask);
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        list.add(function.apply(rs));
                    }
                }
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

