/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.server.bean.AbstractAddressDao;

public class CityDao
extends AbstractAddressDao<City>
implements Directory<City> {
    public CityDao(Connection con) {
        super(con, "address_city");
    }

    @Override
    protected City newBean() {
        return new City();
    }

    protected City getFromRS(ResultSet rs) throws SQLException, BGException {
        City result = (City)super.getBaseFromRS(rs);
        result.setCountryId(rs.getInt("country_id"));
        return result;
    }

    protected void updateImpl(City city) throws BGException, SQLException {
        City old = city.getId() > 0 ? (City)this.get(city.getId()) : null;
        boolean update = old != null;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET country_id=?, title=?" + (update ? " WHERE id=?" : ", id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, city.getCountryId());
            ps.setString(index++, city.getTitle());
            ps.setInt(index++, city.getId());
            ps.executeUpdate();
            if (!update) {
                city.setId(ServerUtils.lastInsertId(ps));
            }
        }
    }

    @Override
    public List<City> list() throws BGException {
        return super.list(null, "title", new Object[0]);
    }

    public List<City> list(int countryId, String title) throws BGException {
        return super.list("(? OR country_id=?) AND (? OR title LIKE ?)", "title", new Object[]{countryId <= 0, countryId, Utils.isBlankString((String)title), title + "%"});
    }

    @Override
    public City get(String title) throws BGException {
        return (City)super.get("title=?", new Object[]{title});
    }

    public City get(String title, int countryId) throws BGException {
        return (City)super.get("title=? AND country_id=?", new Object[]{title, countryId});
    }

    public void searchCityList(SearchResult<City> searchResult, int countryId, String cityMask) throws BGException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List list = searchResult.getList();
            String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " AS city WHERE true" + (countryId > 0 ? " AND city.country_id=?" : "") + (cityMask != null && !cityMask.isEmpty() ? " AND city.title LIKE ?" : "") + " ORDER BY city.title" + (page != null ? page.sqlLimit() : "");
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                if (countryId > 0) {
                    ps.setInt(index++, countryId);
                }
                if (cityMask != null && !cityMask.isEmpty()) {
                    ps.setString(index++, cityMask);
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        list.add(this.getFromRS(rs));
                    }
                }
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }
}

