/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.server.bean.AbstractAddressDao;
import ru.bitel.oss.kernel.entity.server.utils.AddressUtils;

public class HouseDao
extends AbstractAddressDao<House> {
    public HouseDao(Connection con) {
        super(con, "address_house");
    }

    @Override
    protected House newBean() {
        return new House();
    }

    protected House getFromRS(ResultSet rs) throws SQLException, BGException {
        House result = House.builder().setId(rs.getInt("id")).setAreaId(rs.getInt("areaid")).setQuarterId(rs.getInt("quarterid")).setStreetId(rs.getInt("streetid")).setHouse(rs.getInt("house")).setFrac(rs.getString("frac")).setPostIndex(rs.getString("box_index")).setAmount(rs.getInt("amount")).setComment(rs.getString("comment")).build();
        return result;
    }

    protected void updateImpl(House house) throws BGException, SQLException {
        if (house.getStreetId() < 0) {
            throw new BGException("house.getStreetId() < 0");
        }
        if (house.getHouse() < 0 || house.getAmount() == -1) {
            throw new BGException("house.getHouse() < 0");
        }
        if (house.getAmount() < 0) {
            throw new BGException("house.getAmount() < 0");
        }
        int houseId = this.get(house.getStreetId(), house.getHouse(), house.getFrac());
        if (houseId > 0 && house.getId() != houseId) {
            throw new BGMessageException("\u0414\u043e\u043c \u0443\u0436\u0435 \u0438\u043c\u0435\u0435\u0442\u0441\u044f");
        }
        boolean update = house.getId() > 0 || houseId > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + "address_house SET areaid=?, quarterid=?, streetid=?, house=?, frac=?, box_index=?, amount=?, comment=?" + (update ? " WHERE id=?" : ", id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, house.getAreaId());
            ps.setInt(index++, house.getQuarterId());
            ps.setInt(index++, house.getStreetId());
            ps.setInt(index++, house.getHouse());
            ps.setString(index++, house.getFrac());
            ps.setString(index++, house.getPostIndex());
            ps.setInt(index++, house.getAmount());
            ps.setString(index++, house.getComment());
            ps.setInt(index++, house.getId());
            ps.executeUpdate();
            if (!update) {
                house.setId(ServerUtils.lastInsertId(ps));
            }
        }
    }

    @Override
    public House get(int id) throws BGException {
        try {
            House result;
            StringBuilder sb = new StringBuilder(500).append("SELECT SQL_CALC_FOUND_ROWS house.*, city.id, city.title, area.title, street.title, quarter.title FROM ").append(this.tableName).append(" as house");
            sb.append(" LEFT JOIN address_street as street ON street.id=house.streetid");
            sb.append(" LEFT JOIN address_city AS city ON city.id=street.cityid");
            sb.append(" LEFT JOIN address_area as area ON area.id=house.areaid");
            sb.append(" LEFT JOIN address_quarter as quarter ON quarter.id=house.quarterid");
            sb.append(" WHERE house.id=?");
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getFromRS(rs);
                result.setCityId(rs.getInt("city.id"));
                result.setCityTitle(rs.getString("city.title"));
                result.setAreaTitle(rs.getString("area.title"));
                result.setStreetTitle(rs.getString("street.title"));
                result.setQuarterTitle(rs.getString("quarter.title"));
            } else {
                result = null;
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public House get(String houseFrac, int streetId) throws BGException {
        Object[] hf = House.getHouseAndFrac((String)houseFrac);
        return (House)super.get("streetid=? AND house=? AND frac=?", new Object[]{streetId, (int)((Integer)hf[0]), (String)hf[1]});
    }

    private int get(int streetid, int house, String frac) throws SQLException {
        ResultSet rs;
        int index = 1;
        int houseId = 0;
        StringBuffer query = new StringBuffer();
        query.append("SELECT id FROM address_house WHERE streetid=? AND house=?");
        if (frac.startsWith("/")) {
            query.append(" AND ( frac=? OR frac=? )");
        } else {
            query.append(" AND frac=? ");
        }
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(index++, streetid);
        ps.setInt(index++, house);
        ps.setString(index++, frac);
        if (frac.startsWith("/")) {
            ps.setString(index++, frac.substring(1));
        }
        if ((rs = ps.executeQuery()).next()) {
            houseId = rs.getInt(1);
        }
        rs.close();
        ps.close();
        return houseId;
    }

    public List<House> list(int cityId, int areaId, int streetId, int quarterId, int house, String frac, Page page) throws BGException {
        try {
            ArrayList<House> result = new ArrayList<House>();
            StringBuilder sb = new StringBuilder(500).append("SELECT SQL_CALC_FOUND_ROWS house.*, city.id, city.title, area.title, street.title, quarter.title FROM ").append(this.tableName).append(" as house");
            sb.append(" LEFT JOIN address_street as street ON street.id=house.streetid");
            sb.append(" LEFT JOIN address_city AS city ON city.id=street.cityid");
            sb.append(" LEFT JOIN address_area as area ON area.id=house.areaid");
            sb.append(" LEFT JOIN address_quarter as quarter ON quarter.id=house.quarterid");
            sb.append(" WHERE (? OR house.streetid=?) AND (? OR street.cityid=?) AND (? OR house.areaid=?)  AND (? OR house.quarterid=?)");
            sb.append(" AND (? OR house.house=?) AND (? OR house.frac=? OR house.frac=?)");
            sb.append(" ORDER BY city.title, area.title, quarter.title, street.title, house.house, house.frac");
            if (page != null) {
                sb.append(" LIMIT ?,?");
            }
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            ps.setBoolean(1, streetId <= 0);
            ps.setInt(2, streetId);
            ps.setBoolean(3, cityId <= 0);
            ps.setInt(4, cityId);
            ps.setBoolean(5, areaId <= 0);
            ps.setInt(6, areaId);
            ps.setBoolean(7, quarterId <= 0);
            ps.setInt(8, quarterId);
            ps.setBoolean(9, house <= 0);
            ps.setInt(10, house);
            ps.setBoolean(11, Utils.isBlankString((String)frac));
            ps.setString(12, frac);
            if (frac.matches("^/[0-9]+$")) {
                ps.setString(13, frac.substring(1));
            } else {
                ps.setString(13, frac);
            }
            if (page != null) {
                ps.setInt(14, page.getPageFirstRecordNumber());
                ps.setInt(15, page.getPageSize());
            }
            ResultSet rs = ps.executeQuery();
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
            while (rs.next()) {
                House b = this.getFromRS(rs);
                b.setCityId(rs.getInt("city.id"));
                b.setCityTitle(rs.getString("city.title"));
                b.setAreaTitle(rs.getString("area.title"));
                b.setStreetTitle(rs.getString("street.title"));
                b.setQuarterTitle(rs.getString("quarter.title"));
                result.add(b);
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void searchHouseList(SearchResult<House> searchResult, int areaId, int quarterId, int streetId, String houseFrac) throws BGException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List list = searchResult.getList();
            int house = Utils.parseInt((String)AddressUtils.getHouse(houseFrac), (int)-1);
            String frac = AddressUtils.getHouseFrac(houseFrac);
            String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " AS house WHERE true" + (areaId > 0 ? " AND house.areaid=?" : "") + (quarterId > 0 ? " AND house.quarterid=?" : "") + (streetId > 0 ? " AND house.streetid=?" : "") + (house > -1 ? " AND house.house=?" : "") + (!frac.isEmpty() ? " AND house.frac LIKE ?" : "") + " ORDER BY house.house, house.frac" + (page != null ? page.sqlLimit() : "");
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                if (areaId > 0) {
                    ps.setInt(index++, areaId);
                }
                if (quarterId > 0) {
                    ps.setInt(index++, quarterId);
                }
                if (streetId > 0) {
                    ps.setInt(index++, streetId);
                }
                if (house > -1) {
                    ps.setInt(index++, house);
                }
                if (!frac.isEmpty()) {
                    ps.setString(index++, frac);
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        list.add(this.getFromRS(rs));
                    }
                }
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    @Override
    public House get(String title) throws BGException {
        return (House)super.get("house=?", new Object[]{title});
    }

    @Override
    public List<House> list() throws BGException {
        return super.list(null, "house", new Object[0]);
    }

    @Override
    public void update(House k) throws BGException {
        super.update((Object)k);
    }
}

