/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.common.Utils;

public class ParameterDao {
    private Connection con = null;

    public ParameterDao(Connection con) {
        this.con = con;
    }

    public Map<String, String> getAddressParams(String tableId, int recordId) {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "SELECT * FROM address_config WHERE table_id=? AND record_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(sql);){
            ps.setString(1, tableId);
            ps.setInt(2, recordId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    map.put(rs.getString("key"), rs.getString("value"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public String getAddressParam(String tableId, int recordId, String key) {
        String result = null;
        String sql = "SELECT * FROM address_config WHERE table_id=? AND record_id=? AND address_config.key=?";
        try (PreparedStatement ps = this.con.prepareStatement(sql);){
            ps.setString(1, tableId);
            ps.setInt(2, recordId);
            ps.setString(3, key);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result = rs.getString("value");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateAddressParams(String tableId, int recordId, String key, String value) {
        try {
            String sql = null;
            sql = "DELETE FROM address_config WHERE table_id=? AND record_id=? AND address_config.key=? ";
            PreparedStatement psDelete = this.con.prepareStatement(sql);
            psDelete.setString(1, tableId);
            psDelete.setInt(2, recordId);
            psDelete.setString(3, key);
            psDelete.executeUpdate();
            psDelete.close();
            sql = "INSERT INTO address_config SET table_id=?, value=?, record_id=?, address_config.key=?";
            PreparedStatement psUpdate = this.con.prepareStatement(sql);
            psUpdate.setString(1, tableId);
            psUpdate.setString(2, value);
            psUpdate.setInt(3, recordId);
            psUpdate.setString(4, key);
            psUpdate.executeUpdate();
            psUpdate.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteAddressParams(String tableId, int recordId) {
        try {
            String sql = null;
            ArrayList<Integer> streetIdList = new ArrayList<Integer>();
            ArrayList<Integer> areaIdList = new ArrayList<Integer>();
            ArrayList<Integer> quarterIdList = new ArrayList<Integer>();
            if (tableId.equals("address_city")) {
                sql = "SELECT * FROM address_street WHERE cityid=?";
                PreparedStatement streetPS = this.con.prepareStatement(sql);
                streetPS.setInt(1, recordId);
                ResultSet rs = streetPS.executeQuery();
                while (rs.next()) {
                    streetIdList.add(rs.getInt("id"));
                }
                sql = "SELECT * FROM address_area WHERE cityid=?";
                PreparedStatement areaPS = this.con.prepareStatement(sql);
                areaPS.setInt(1, recordId);
                rs = areaPS.executeQuery();
                while (rs.next()) {
                    areaIdList.add(rs.getInt("id"));
                }
                sql = "SELECT * FROM address_quarter WHERE cityid=?";
                PreparedStatement quarterPS = this.con.prepareStatement(sql);
                quarterPS.setInt(1, recordId);
                rs = quarterPS.executeQuery();
                while (rs.next()) {
                    quarterIdList.add(rs.getInt("id"));
                }
                rs.close();
                streetPS.close();
                areaPS.close();
                quarterPS.close();
                if (areaIdList.size() > 0) {
                    this.deleteExctraAddressParams("address_area", Utils.toString(areaIdList, (int)0), null);
                }
                if (streetIdList.size() > 0) {
                    this.deleteExctraAddressParams("address_street", Utils.toString(streetIdList, (int)0), null);
                }
                if (quarterIdList.size() > 0) {
                    this.deleteExctraAddressParams("address_quarter", Utils.toString(quarterIdList, (int)0), null);
                }
            }
            this.deleteExctraAddressParams(tableId, String.valueOf(recordId), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteExctraAddressParams(String tableId, String recordId, String key) {
        try {
            String sql = null;
            sql = key == null ? "DELETE FROM address_config WHERE table_id=? AND record_id IN (" + recordId + ")" : "DELETE FROM address_config WHERE table_id=? AND address_config.key=? AND record_id IN (" + recordId + ")";
            PreparedStatement psDelete = this.con.prepareStatement(sql);
            psDelete.setString(1, tableId);
            if (key != null) {
                psDelete.setString(2, key);
            }
            psDelete.executeUpdate();
            psDelete.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

