/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.GetIndexPoint;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.KeyValue;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.directories.address.common.bean.Area;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.Country;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.common.bean.Quarter;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;
import ru.bitel.oss.kernel.directories.address.server.bean.AddressUtils;
import ru.bitel.oss.kernel.directories.address.server.bean.AreaDao;
import ru.bitel.oss.kernel.directories.address.server.bean.CityDao;
import ru.bitel.oss.kernel.directories.address.server.bean.CountryDao;
import ru.bitel.oss.kernel.directories.address.server.bean.HouseDao;
import ru.bitel.oss.kernel.directories.address.server.bean.ParameterDao;
import ru.bitel.oss.kernel.directories.address.server.bean.QuarterDao;
import ru.bitel.oss.kernel.directories.address.server.bean.StreetDao;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityType;

@WebService(endpointInterface="ru.bitel.oss.kernel.directories.address.common.service.AddressService")
@XmlSeeAlso(value={KeyValue.class})
public class AddressServiceImpl
extends AbstractService
implements AddressService {
    private static final Logger logger = LogManager.getLogger();
    private Directory<Country> countryDirectory;
    private Directory<City> cityDirectory;
    private Directory<Area> areaDirectory;
    private Directory<Street> streetDirectory;
    private Directory<Quarter> quarterDirectory;
    private AreaDao areaDao;
    private CountryDao countryDao;
    private CityDao cityDao;
    private StreetDao streetDao;
    private QuarterDao quarterDao;
    private HouseDao houseDao;

    @PostConstruct
    protected void init() throws BGException {
        this.countryDirectory = this.context.getDirectory(Country.class, 0);
        this.cityDirectory = this.context.getDirectory(City.class, 0);
        this.areaDirectory = this.context.getDirectory(Area.class, 0);
        this.streetDirectory = this.context.getDirectory(Street.class, 0);
        this.quarterDirectory = this.context.getDirectory(Quarter.class, 0);
        this.countryDao = new CountryDao(this.getConnection());
        this.areaDao = new AreaDao(this.getConnection());
        this.cityDao = new CityDao(this.getConnection());
        this.streetDao = new StreetDao(this.getConnection());
        this.quarterDao = new QuarterDao(this.getConnection());
        this.houseDao = new HouseDao(this.getConnection());
    }

    public Country countryGet(int id) throws BGException {
        return this.countryDirectory.get(id);
    }

    public SearchResult<Country> searchCountryList(String title, String searchMode, Page page) throws BGException {
        SearchResult searchResult = new SearchResult(null, page);
        if (searchMode == null && page == null) {
            if (Utils.isBlankString((String)title)) {
                searchResult.setList(this.countryDirectory.list());
            } else {
                searchResult.setList(this.countryDao.list(title));
            }
        } else {
            try (CountryDao countryDao = new CountryDao(this.getConnection());){
                countryDao.searchCountryList((SearchResult<Country>)searchResult, this.getMask(title, searchMode));
            }
        }
        return searchResult;
    }

    public int countryUpdate(Country country) throws BGException {
        this.countryDirectory.update(country);
        return country.getId();
    }

    public void countryDelete(int id) throws BGException {
        this.countryDirectory.delete(id);
    }

    public City cityGet(int id) throws BGException {
        return this.cityDirectory.get(id);
    }

    public SearchResult<City> searchCityList(int countryId, String title, String searchMode, Page page) throws BGException {
        SearchResult searchResult = new SearchResult(null, page);
        if (searchMode == null && page == null) {
            if (countryId <= 0 && Utils.isBlankString((String)title)) {
                searchResult.setList(this.cityDirectory.list());
            } else {
                searchResult.setList(this.cityDao.list(countryId, title));
            }
        } else {
            try (CityDao cityDao = new CityDao(this.getConnection());){
                cityDao.searchCityList((SearchResult<City>)searchResult, countryId, this.getMask(title, searchMode));
            }
        }
        return searchResult;
    }

    public int cityUpdate(City city) throws BGException {
        this.cityDirectory.update(city);
        return city.getId();
    }

    public void cityDelete(int id) throws BGException {
        this.cityDirectory.delete(id);
    }

    public List<City> cityList(int countryId) throws BGException, BGException {
        List<City> cities = this.cityDirectory.list();
        return countryId > 0 ? cities.stream().filter(a -> a.getCountryId() == countryId).toList() : cities;
    }

    public Area areaGet(int id) throws BGException {
        return this.areaDirectory.get(id);
    }

    public SearchResult<Area> searchAreaList(int cityId, String title, String searchMode, Page page) throws BGException {
        SearchResult searchResult = new SearchResult(null, page);
        if (searchMode == null && page == null) {
            if (cityId <= 0 && Utils.isBlankString((String)title)) {
                searchResult.setList(this.areaDirectory.list());
            } else {
                searchResult.setList(this.areaDao.list(cityId, title));
            }
        } else {
            try (AreaDao areaDao = new AreaDao(this.getConnection());){
                areaDao.searchAreaList((SearchResult<Area>)searchResult, cityId, this.getMask(title, searchMode));
            }
        }
        return searchResult;
    }

    public int areaUpdate(Area area) throws BGException {
        this.areaDirectory.update(area);
        return area.getId();
    }

    public void areaDelete(int id) throws BGException {
        this.areaDirectory.delete(id);
    }

    public List<Area> areaList(int cityId) throws BGException, BGMessageException {
        List<Area> areas = this.areaDirectory.list();
        return cityId > 0 ? areas.stream().filter(a -> a.getCity().getId() == cityId).toList() : areas;
    }

    public Street streetGet(int id) throws BGException {
        return this.streetDirectory.get(id);
    }

    public SearchResult<Street> searchStreetList(int cityId, String title, String searchMode, Page page) throws BGException {
        SearchResult searchResult = new SearchResult(null, page);
        if (searchMode == null && page == null) {
            if (cityId <= 0 && Utils.isBlankString((String)title)) {
                searchResult.setList(this.streetDirectory.list());
            } else {
                searchResult.setList(this.streetDao.list(cityId, title));
            }
        } else {
            try (StreetDao streetDao = new StreetDao(this.getConnection());){
                streetDao.searchStreetList((SearchResult<Street>)searchResult, cityId, this.getMask(title, searchMode));
            }
        }
        return searchResult;
    }

    public List<Street> streetSearch(int cityId, String title, String cityTitle, Page page) throws BGException {
        if (cityId <= 0 && Utils.isBlankString((String)title) && Utils.isBlankString((String)cityTitle) && page == null) {
            return this.streetDirectory.list();
        }
        return this.streetDao.search(cityId, title, cityTitle, page);
    }

    public int streetUpdate(Street b) throws BGException {
        this.streetDirectory.update(b);
        return b.getId();
    }

    public void streetDelete(int id) throws BGException {
        this.streetDirectory.delete(id);
    }

    public List<Street> streetList(int cityId) throws BGException, BGMessageException {
        List<Street> streets = this.streetDirectory.list();
        return cityId > 0 ? streets.stream().filter(a -> a.getCity().getId() == cityId).toList() : streets;
    }

    public Quarter quarterGet(int id) throws BGException {
        return this.quarterDirectory.get(id);
    }

    public SearchResult<Quarter> searchQuarterList(int cityId, String title, String searchMode, Page page) throws BGException {
        SearchResult searchResult = new SearchResult(null, page);
        if (searchMode == null && page == null) {
            if (cityId <= 0 && Utils.isBlankString((String)title)) {
                searchResult.setList(this.quarterDirectory.list());
            } else {
                searchResult.setList(this.quarterDao.list(cityId, title));
            }
        } else {
            try (QuarterDao quarterDao = new QuarterDao(this.getConnection());){
                quarterDao.searchQuarterList((SearchResult<Quarter>)searchResult, cityId, this.getMask(title, searchMode));
            }
        }
        return searchResult;
    }

    public int quarterUpdate(Quarter b) throws BGException {
        this.quarterDirectory.update(b);
        return b.getId();
    }

    public void quarterDelete(int id) throws BGException {
        this.quarterDirectory.delete(id);
    }

    public List<Quarter> quarterList(int cityId) throws BGException, BGMessageException {
        List<Quarter> quarters = this.quarterDirectory.list();
        return cityId > 0 ? quarters.stream().filter(a -> a.getCity().getId() == cityId).toList() : quarters;
    }

    public String postIndexGet(int streetId, String houseAndFrac, int house, String frac) throws BGException {
        Collection<GetIndexPoint> points;
        if (streetId == -1) {
            return null;
        }
        Connection con = this.getConnection();
        String index = this.streetDao.getPostIndex(streetId);
        if (!Utils.isEmptyString((String)index)) {
            return index;
        }
        if (houseAndFrac != null && house <= 0) {
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < houseAndFrac.length(); ++i) {
                int ch = houseAndFrac.charAt(i);
                if (!Character.isDigit((char)ch)) {
                    frac = houseAndFrac.substring(i);
                    break;
                }
                str.append((char)ch);
            }
            house = Utils.parseInt((String)str.toString(), (int)-1);
        }
        if (house < 1) {
            return null;
        }
        String boxIndexRange = new ParameterDao(con).getAddressParam("address_street", streetId, "boxIndexRange");
        if (!Utils.isEmptyString((String)boxIndexRange)) {
            for (String tokens : boxIndexRange.split(";")) {
                String[] indexData = tokens.split(":");
                if (indexData.length != 2 && !indexData[0].matches("^\\d{6}$")) continue;
                for (String houseToken : indexData[1].split(",")) {
                    int rangeStop;
                    if ("*".equals(houseToken) || houseToken.equals(String.valueOf(house).concat(frac != null ? frac : ""))) {
                        return indexData[0];
                    }
                    if (!houseToken.matches("^\\d+\\-(\\d+)?$")) continue;
                    String[] range = houseToken.split("-");
                    int rangeStart = Utils.parseInt((String)range[0], (int)-1);
                    int n = rangeStop = range.length > 1 ? Utils.parseInt((String)range[1], (int)-1) : -1;
                    if (rangeStart != -1 && (rangeStart <= 0 || rangeStart > house) || rangeStop != -1 && (rangeStop <= 0 || house > rangeStop)) continue;
                    return indexData[0];
                }
            }
        }
        if ((points = BGPluginManagerServer.getManager().getInvokeables(GetIndexPoint.class, true)).size() > 1) {
            throw new BGMessageException("\u0411\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u0433\u0438\u043d\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u043a \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0443 \u0432\u044b\u0434\u0430\u0447\u0438 \u0438\u043d\u0434\u0435\u043a\u0441\u0430 \u0434\u043e\u043c\u0430");
        }
        GetIndexPoint finder = null;
        if (points.size() == 1) {
            finder = points.iterator().next();
        }
        if (finder != null && !Utils.isEmptyString((String)(index = finder.getIndex(this.getConnection(), logger, streetId, house, frac)))) {
            return index;
        }
        return null;
    }

    public House houseGet(int id) throws BGException {
        return this.houseDao.get(id);
    }

    public List<House> houseList(int cityId, int areaId, int streetId, int quarterId, int house, String frac, Page page) throws BGException {
        return this.houseDao.list(cityId, areaId, streetId, quarterId, house, frac, page);
    }

    public int houseUpdate(House house) throws BGException {
        this.houseDao.update(house);
        return house.getId();
    }

    public void houseDelete(int id) throws BGException {
        this.houseDao.delete(id);
    }

    public List<KeyValue<String, String>> addressFormat(EntityAttrAddress attrAddress, EntityType entityType) throws BGException {
        ArrayList<KeyValue<String, String>> result = new ArrayList<KeyValue<String, String>>();
        Setup setup = this.context.getSetup();
        AddressUtils addressUtils = new AddressUtils(this.context);
        House house = this.houseGet(attrAddress.getHouseId());
        attrAddress.setFormatKey("0");
        result.add(new KeyValue((Comparable)((Object)"0"), (Object)addressUtils.getAddress((ParameterMap)setup, house, attrAddress)));
        String sortOrder = setup.get("addrs.format.list", null);
        if (sortOrder != null) {
            String[] sortOrderValues = sortOrder.trim().split(";");
            String cp = "cp" + attrAddress.getEntitySpecAttrId();
            String op = "op" + attrAddress.getEntitySpecAttrId();
            for (String item : sortOrderValues) {
                if (item.startsWith("cp") && (entityType == EntityType.OBJECT_PARAMETER || !item.equals(cp)) || item.startsWith("op") && (entityType == EntityType.CONTRACT_PARAMETER || !item.equals(op))) continue;
                attrAddress.setFormatKey(item);
                String title = house != null ? addressUtils.getAddress((ParameterMap)setup, house, attrAddress) : "";
                result.add((KeyValue<String, String>)new KeyValue((Comparable)((Object)item), (Object)title));
            }
        }
        return result;
    }

    private String getMask(String searchText, String searchMode) {
        StringBuilder mask = new StringBuilder();
        if (searchText != null && !searchText.isEmpty()) {
            if (searchMode == null || "subs".equals(searchMode) || "end".equals(searchMode)) {
                mask.append('%');
            }
            mask.append(searchText);
            if (searchMode == null || "subs".equals(searchMode) || "start".equals(searchMode)) {
                mask.append('%');
            }
        }
        return mask.toString();
    }

    public String houseIndexGet(int streetId, String houseAndFrac, int house, String frac) throws BGException, BGMessageException {
        if (streetId == -1) {
            return "";
        }
        String index = new StreetDao(this.getConnection()).getPostIndex(streetId);
        if (!Utils.isEmptyString((String)index)) {
            return index;
        }
        Collection<GetIndexPoint> points = BGPluginManagerServer.getManager().getInvokeables(GetIndexPoint.class, true);
        if (points.size() > 1) {
            throw new BGMessageException("\u0411\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u0433\u0438\u043d\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u043a \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0443 \u0432\u044b\u0434\u0430\u0447\u0438 \u0438\u043d\u0434\u0435\u043a\u0441\u0430 \u0434\u043e\u043c\u0430");
        }
        GetIndexPoint finder = null;
        if (points.size() == 1) {
            finder = points.iterator().next();
        }
        if (finder != null) {
            int houseNumber = -1;
            String houseFrac = null;
            if (houseAndFrac != null) {
                StringBuilder str = new StringBuilder();
                for (int i = 0; i < houseAndFrac.length(); ++i) {
                    char ch = houseAndFrac.charAt(i);
                    if (!Character.isDigit(ch)) {
                        houseFrac = houseAndFrac.substring(i);
                        break;
                    }
                    str.append(ch);
                }
                houseNumber = Utils.parseInt((String)str.toString(), (int)0);
            }
            house = house > 0 ? house : houseNumber;
            frac = frac != null ? frac : houseFrac;
            index = finder.getIndex(this.getConnection(), logger, streetId, house, frac);
            if (!Utils.isEmptyString((String)index)) {
                return index;
            }
        }
        return "";
    }
}

