/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.oss.kernel.entity.common.bean.Entity;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDaoSupport;

public abstract class AbstractEntityDao<E extends Entity>
extends AbstractEntityAttrDao<E> {
    private static final Logger logger = LogManager.getLogger();
    protected PreparedStatement insertEntityPS = null;
    protected PreparedStatement updateEntityPS = null;
    protected PreparedStatement updateEntityPS2 = null;

    public AbstractEntityDao(Connection con, int moduleId, int userId, String tableName, String entityTableSuffix) {
        this(con, moduleId, userId, tableName, entityTableSuffix, ENTITY_SUPPORT);
    }

    public AbstractEntityDao(Connection con, int moduleId, int userId, String tableName, String entityTableSuffix, EntityAttrDaoSupport entityAttrDaoSupport) {
        super(con, moduleId, userId, tableName, entityTableSuffix, entityAttrDaoSupport);
    }

    protected void linkEntity(Entity entity) throws SQLException {
        if (entity.getId() <= 0 || entity.getEntitySpecId() > 0 && entity.getEntityId() == 0) {
            PreparedStatement ps = this.insertEntityPS;
            if (ps == null) {
                ps = this.insertEntityPS = this.con.prepareStatement("INSERT INTO entity SET entitySpecId=?, title=?", 1);
            }
            ps.setInt(1, entity.getEntitySpecId());
            ps.setString(2, "");
            ps.executeUpdate();
            entity.setEntityId(ServerUtils.lastInsertId(ps));
        } else if (entity.getEntitySpecId() > 0) {
            PreparedStatement ps = this.updateEntityPS;
            if (ps == null) {
                ps = this.updateEntityPS = this.con.prepareStatement("UPDATE entity SET entitySpecId=?, title=? WHERE id=?");
            }
            ps.setInt(1, entity.getEntitySpecId());
            ps.setString(2, "");
            ps.setInt(3, entity.getEntityId());
            ps.executeUpdate();
        } else {
            PreparedStatement ps = this.updateEntityPS2;
            if (ps == null) {
                ps = this.updateEntityPS2 = this.con.prepareStatement("UPDATE entity SET title=? WHERE id=?");
            }
            ps.setString(1, "");
            ps.setInt(2, entity.getEntityId());
            ps.executeUpdate();
        }
    }

    protected void unlinkEntity(int entityId) throws SQLException {
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM entity WHERE entity.id=?");){
            ps.setInt(1, entityId);
            ps.executeUpdate();
        }
    }

    public void update(E b) throws BGException {
        try {
            this.updateImpl(b);
            this.updateEntityAttributes(b.getId(), b.getEntityAttributes());
        }
        catch (SQLException e) {
            this.processException(e);
        }
    }

    public int delete(int id) throws BGException {
        int result = 0;
        try {
            result = super.deleteImpl(id);
            this.deleteEntityAttributes(id);
        }
        catch (SQLException e) {
            this.processException(e);
        }
        return result;
    }

    @Override
    protected List<E> list(boolean loadAttributes, Page page, String what, String join, List<FilterEntityAttr> entityFilter, String filter, String groupBy, String orderBy, Object ... params) throws BGException {
        try {
            what = what == null ? "SQL_CALC_FOUND_ROWS " + this.tableName + ".*, entity.entitySpecId, entity.title as entityTitle" : "SQL_CALC_FOUND_ROWS " + (String)what + ", entity.entitySpecId, entity.title as entityTitle";
            List result = this.listImpl(loadAttributes, page, "SQL_CALC_FOUND_ROWS " + this.tableName + ".*, entity.entitySpecId, entity.title as entityTitle", "LEFT JOIN entity ON entity.id=" + this.tableName + ".entityId", join, entityFilter, filter, groupBy, orderBy, params);
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
            return result;
        }
        catch (SQLException e) {
            this.processException(e);
            return Collections.emptyList();
        }
    }

    @Override
    protected E getFromRS(ResultSet rs, boolean loadAttributes) throws SQLException, BGException {
        E result = this.getFromRSImpl(rs);
        if (loadAttributes) {
            result.setEntityAttributes(this.getEntityAttributes(result.getEntitySpecId(), result.getId(), false));
        }
        return result;
    }

    protected abstract E getFromRSImpl(ResultSet var1) throws SQLException, BGException;

    public void recycle() throws BGException {
        try {
            if (this.insertEntityPS != null) {
                this.insertEntityPS.close();
                this.insertEntityPS = null;
            }
            if (this.updateEntityPS != null) {
                this.updateEntityPS.close();
                this.updateEntityPS = null;
            }
            if (this.updateEntityPS2 != null) {
                this.updateEntityPS2.close();
                this.updateEntityPS2 = null;
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        finally {
            super.recycle();
        }
    }

    protected Result<E> list(Page page, String filter, String orderBy, Object ... params) throws BGException {
        try {
            List result = this.listImpl(true, page, "SQL_CALC_FOUND_ROWS " + this.tableName + ".*, entity.entitySpecId, entity.title as entityTitle", "LEFT JOIN entity ON entity.id=" + this.tableName + ".entityId", null, null, filter, null, orderBy, params);
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
            return new Result(result, page);
        }
        catch (SQLException e) {
            this.processException(e);
            return new Result(Collections.emptyList());
        }
    }

    protected List<E> listImpl(Page page, String filter, String orderBy, Object ... params) throws BGException, SQLException {
        return this.listImpl(true, page, this.tableName + ".*", null, null, null, filter, null, orderBy, params);
    }

    @Override
    protected E getFromRS(ResultSet rs) throws SQLException, BGException {
        return this.getFromRS(rs, true);
    }

    static {
        try {
            new AbstractEntityAttrDao.AddressItemModifiedEventListener(){

                @Override
                protected AbstractEntityAttrDao<?> newDao(ServerContext context) {
                    return new AbstractEntityDao<Entity>(context.getConnection(), context.getModuleId(), context.getUserId(), null, null){

                        @Override
                        protected Entity getFromRSImpl(ResultSet rs) throws SQLException, BGException {
                            return null;
                        }

                        protected void updateImpl(Entity b) throws BGException, SQLException {
                        }
                    };
                }
            };
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }
}

