/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttr;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDaoSupport;

abstract class EntityAttrDefaultDao<A extends EntityAttr> {
    protected static final String ENTITY_TABLE_MAP_KEY = "entity.table.map.key";
    final String table;
    protected final Connection con;
    protected final AbstractEntityAttrDao<?> entityAttrDao;
    protected final EntityAttrDaoSupport support;

    public EntityAttrDefaultDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String table) {
        this.con = con;
        this.entityAttrDao = entityAttrDao;
        this.support = entityAttrDao.support;
        this.table = table;
        Set<String> entityTableSet = this.getEntityTableSet();
        if (!entityTableSet.contains(table)) {
            this.createTable();
            entityTableSet.add(table);
        }
    }

    protected Set<String> getEntityTableSet() {
        Setup setup = Setup.getSetup();
        HashSet entityTableSet = (HashSet)setup.getObject(ENTITY_TABLE_MAP_KEY);
        if (entityTableSet == null) {
            entityTableSet = new HashSet();
            setup.putObject(ENTITY_TABLE_MAP_KEY, entityTableSet);
        }
        return entityTableSet;
    }

    protected abstract void createTable();

    protected String idName() {
        return this.support.idName();
    }

    protected String valueName() {
        return this.support.defaultValueName();
    }

    protected String beanIdName() {
        return this.support.beanIdName();
    }

    protected String typeName() {
        return this.support.typeName();
    }

    protected abstract boolean updateImpl(int var1, A var2) throws SQLException, BGException;

    public boolean update(int entityId, EntitySpecAttr sa, EntityAttr a) throws SQLException, BGException {
        EntityAttr attr = a;
        boolean result = this.updateImpl(entityId, attr);
        if (this.support.isHistorySupported() && sa.isHistory() && result) {
            this.insertHistory(entityId, sa.getId(), attr);
        }
        return result;
    }

    public abstract void insert(int var1, EntityAttr var2) throws SQLException, BGException;

    public abstract A get(int var1, int var2) throws SQLException;

    protected PreparedStatement getSelectPS(int entityId, int entitySpecAttrId) throws SQLException {
        PreparedStatement selectPS = this.con.prepareStatement("SELECT " + this.valueName() + " FROM " + this.table + " WHERE " + this.idName() + "=? AND " + this.typeName() + "=?");
        selectPS.setInt(1, entityId);
        selectPS.setInt(2, entitySpecAttrId);
        return selectPS;
    }

    protected boolean checkEntitySpecAttrDelete(int entitySpecAttrId) throws SQLException {
        try (PreparedStatement ps = this.con.prepareStatement("SELECT " + this.typeName() + " FROM " + this.table + " WHERE " + this.typeName() + "=? LIMIT 1");){
            ps.setInt(1, entitySpecAttrId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }

    protected PreparedStatement getInsertPS(int entityId, int entitySpecAttrId) throws SQLException {
        PreparedStatement insertPS = this.con.prepareStatement("INSERT INTO " + this.table + " SET " + this.idName() + "=?, " + this.typeName() + "=?, " + this.valueName() + "=?");
        insertPS.setInt(1, entityId);
        insertPS.setInt(2, entitySpecAttrId);
        return insertPS;
    }

    protected PreparedStatement getUpdatePS(int entityId, int entitySpecAttrId) throws SQLException {
        PreparedStatement updatePS = this.con.prepareStatement("UPDATE " + this.table + " SET " + this.valueName() + "=? WHERE " + this.idName() + "=? AND " + this.typeName() + "=? AND ((@oldValue:=" + this.valueName() + ") IS NOT NULL)");
        updatePS.setInt(2, entityId);
        updatePS.setInt(3, entitySpecAttrId);
        return updatePS;
    }

    protected PreparedStatement getDeletePS(int entityId, int entitySpecAttrId) throws SQLException {
        PreparedStatement deletePS = this.con.prepareStatement("DELETE FROM " + this.table + " WHERE " + this.idName() + "=? AND " + this.typeName() + "=?");
        deletePS.setInt(1, entityId);
        deletePS.setInt(2, entitySpecAttrId);
        return deletePS;
    }

    public final boolean delete(int entityId, EntitySpecAttr sa) throws BGException {
        try {
            boolean result = this.deleteImpl(entityId, sa.getId());
            if (this.support.isHistorySupported() && sa.isHistory() && result) {
                this.insertHistory(entityId, sa.getId(), null);
            }
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected boolean deleteImpl(int entityId, int entitySpecAttrId) throws SQLException {
        try (PreparedStatement ps = this.getDeletePS(entityId, entitySpecAttrId);){
            boolean bl = ps.executeUpdate() > 0;
            return bl;
        }
    }

    protected PreparedStatement getInsertHistiryPS() throws SQLException {
        return this.con.prepareStatement("INSERT INTO " + this.table + "_log SET  " + this.idName() + "=?, " + this.typeName() + "=?, val=?, dt_change=?, user_id=?");
    }

    protected void insertHistory(int contractId, int entitySpecAttrId, A attr) throws SQLException {
        try (PreparedStatement ps = this.getInsertHistiryPS();){
            ps.setInt(1, contractId);
            ps.setInt(2, entitySpecAttrId);
            ps.setString(3, attr != null ? attr.toString() : null);
            ps.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
            ps.setInt(5, this.entityAttrDao.userId);
            ps.executeUpdate();
        }
    }
}

