/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDefaultDao;

class EntityAttrEmailDao
extends EntityAttrDefaultDao<EntityAttrEmail> {
    public EntityAttrEmailDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String intTable) {
        super(con, entityAttrDao, intTable);
    }

    @Override
    protected void createTable() {
    }

    @Override
    protected PreparedStatement getSelectPS(int entityId, int entitySpecAttrId) throws SQLException {
        String query = "SELECT email FROM " + this.table + " WHERE " + this.idName() + "=? AND " + this.typeName() + "=?";
        PreparedStatement selectPS = this.con.prepareStatement(query);
        selectPS.setInt(1, entityId);
        selectPS.setInt(2, entitySpecAttrId);
        return selectPS;
    }

    @Override
    protected PreparedStatement getInsertPS(int entityId, int entitySpecAttrId) throws SQLException {
        String query = "INSERT INTO " + this.table + " SET " + this.idName() + "=?, " + this.typeName() + "=?, email=?";
        PreparedStatement insertPS = this.con.prepareStatement(query);
        insertPS.setInt(1, entityId);
        insertPS.setInt(2, entitySpecAttrId);
        return insertPS;
    }

    @Override
    protected PreparedStatement getUpdatePS(int entityId, int entitySpecAttrId) throws SQLException {
        String query = "UPDATE " + this.table + " SET email=? WHERE " + this.idName() + "=? AND " + this.typeName() + "=?";
        PreparedStatement updatePS = this.con.prepareStatement(query);
        updatePS.setInt(2, entityId);
        updatePS.setInt(3, entitySpecAttrId);
        return updatePS;
    }

    @Override
    protected PreparedStatement getDeletePS(int entityId, int entitySpecAttrId) throws SQLException {
        String query = "DELETE FROM " + this.table + " WHERE " + this.idName() + "=? AND " + this.typeName() + "=?";
        PreparedStatement deletePS = this.con.prepareStatement(query);
        deletePS.setInt(1, entityId);
        deletePS.setInt(2, entitySpecAttrId);
        return deletePS;
    }

    @Override
    public EntityAttrEmail get(int entityId, int attrSpecId) throws SQLException {
        EntityAttrEmail result = null;
        try (PreparedStatement ps = this.getSelectPS(entityId, attrSpecId);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                result = EntityAttrEmail.parse((int)entityId, (int)attrSpecId, (String)rs.getString(1));
            }
        }
        return result;
    }

    @Override
    public void insert(int entityId, EntityAttr a) throws SQLException {
        try (PreparedStatement ps = this.getInsertPS(entityId, a.getEntitySpecAttrId());){
            ps.setString(3, ((EntityAttrEmail)a).getData());
            ps.executeUpdate();
        }
    }

    @Override
    public boolean updateImpl(int entityId, EntityAttrEmail attr) throws SQLException {
        String value = attr.getData();
        if (Utils.isBlankString((String)value)) {
            return this.deleteImpl(entityId, attr.getEntitySpecAttrId());
        }
        boolean update = false;
        String oldValue = null;
        try (PreparedStatement ps = this.getSelectPS(entityId, attr.getEntitySpecAttrId());
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                oldValue = rs.getString(1);
                update = true;
            }
        }
        if (update) {
            ps = this.getUpdatePS(entityId, attr.getEntitySpecAttrId());
            try {
                ps.setString(1, value);
                ps.executeUpdate();
                boolean bl = !value.equals(oldValue);
                return bl;
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        ps = this.getInsertPS(entityId, attr.getEntitySpecAttrId());
        try {
            ps.setString(3, value);
            ps.executeUpdate();
            boolean bl = true;
            return bl;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }
}

