/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import bitel.billing.server.contract.bean.ContractParameterManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrMultiList;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDefaultDao;

public class EntityAttrMultiListDao
extends EntityAttrDefaultDao<EntityAttrMultiList> {
    public String itemTable;

    public EntityAttrMultiListDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String table, String listValueTable) {
        super(con, entityAttrDao, table);
        this.itemTable = listValueTable;
    }

    @Override
    protected void createTable() {
    }

    @Override
    protected PreparedStatement getSelectPS(int entityId, int entitySpecAttrId) throws SQLException {
        String query = "SELECT val FROM " + this.table + " WHERE " + this.idName() + "=? AND " + this.typeName() + "=?";
        PreparedStatement selectPS = this.con.prepareStatement(query);
        selectPS.setInt(1, entityId);
        selectPS.setInt(2, entitySpecAttrId);
        return selectPS;
    }

    @Override
    protected PreparedStatement getInsertPS(int entityId, int entitySpecAttrId) throws SQLException {
        String query = "INSERT INTO " + this.table + " SET " + this.idName() + "=?, " + this.typeName() + "=?, val=?";
        PreparedStatement insertPS = this.con.prepareStatement(query);
        insertPS.setInt(1, entityId);
        insertPS.setInt(2, entitySpecAttrId);
        return insertPS;
    }

    @Override
    protected PreparedStatement getUpdatePS(int entityId, int entitySpecAttrId) throws SQLException {
        String query = "UPDATE " + this.table + " SET val=? WHERE " + this.idName() + "=? AND " + this.typeName() + "=?";
        PreparedStatement updatePS = this.con.prepareStatement(query);
        updatePS.setInt(2, entityId);
        updatePS.setInt(3, entitySpecAttrId);
        return updatePS;
    }

    @Override
    public EntityAttrMultiList get(int entityId, int attrSpecId) throws SQLException {
        EntityAttrMultiList result = null;
        try (PreparedStatement ps = this.getSelectPS(entityId, attrSpecId);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                result = new EntityAttrMultiList(entityId, attrSpecId, rs.getString(1), new ArrayList());
            }
        }
        if (result != null) {
            String query = "SELECT val, custom_value FROM " + this.itemTable + " WHERE " + this.idName() + "=? AND " + this.typeName() + "=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setInt(1, entityId);
                ps.setInt(2, attrSpecId);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        result.getValueList().add(new IdTitle(rs.getInt(1), rs.getString(2)));
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void insert(int entityId, EntityAttr attr) throws SQLException, BGException {
        EntityAttrMultiList mList = (EntityAttrMultiList)attr;
        this.clean(mList);
        try (PreparedStatement ps = this.getInsertPS(entityId, mList.getEntitySpecAttrId());){
            ps.setString(3, mList.getTitle());
            ps.executeUpdate();
        }
        this.updateListValues(entityId, mList);
    }

    @Override
    protected boolean updateImpl(int entityId, EntityAttrMultiList attr) throws SQLException, BGException {
        boolean result;
        this.clean(attr);
        if (attr.getValueList() == null || attr.getValueList().size() == 0) {
            return this.deleteImpl(entityId, attr.getEntitySpecAttrId());
        }
        boolean update = false;
        String oldValue = null;
        try (PreparedStatement ps = this.getSelectPS(entityId, attr.getEntitySpecAttrId());
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                oldValue = rs.getString(1);
                update = true;
            }
        }
        if (update) {
            ps = this.getUpdatePS(entityId, attr.getEntitySpecAttrId());
            try {
                ps.setString(1, attr.getTitle());
                update = ps.executeUpdate() == 0;
                result = !attr.getTitle().equals(oldValue);
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        ps = this.getInsertPS(entityId, attr.getEntitySpecAttrId());
        try {
            ps.setString(3, attr.getTitle());
            ps.executeUpdate();
            result = true;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        this.updateListValues(entityId, attr);
        return result;
    }

    private void updateListValues(int entityId, EntityAttrMultiList attr) throws SQLException {
        this.deleteListValues(entityId, attr.getEntitySpecAttrId());
        String query = "INSERT INTO " + this.itemTable + " SET " + this.idName() + "=?, " + this.typeName() + "=?, val=?, custom_value=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, entityId);
            ps.setInt(2, attr.getEntitySpecAttrId());
            for (IdTitle value : attr.getValueList()) {
                ps.setInt(3, value.getId());
                ps.setString(4, value.getTitle() != null ? value.getTitle() : "");
                ps.executeUpdate();
            }
        }
    }

    @Override
    protected boolean deleteImpl(int entityId, int entitySpecAttrId) throws SQLException {
        boolean result = super.deleteImpl(entityId, entitySpecAttrId);
        if (result) {
            this.deleteListValues(entityId, entitySpecAttrId);
        }
        return result;
    }

    private void deleteListValues(int entityId, int entitySpecAttrId) throws SQLException {
        String query = "DELETE FROM " + this.itemTable + " WHERE " + this.idName() + "=? AND " + this.typeName() + "=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, entityId);
            ps.setInt(2, entitySpecAttrId);
            ps.executeUpdate();
        }
    }

    private void clean(EntityAttrMultiList a) throws BGException, SQLException {
        a.setTitle("");
        if (a.getValueList() != null && a.getValueList().size() > 0) {
            Iterator iter = a.getValueList().iterator();
            while (iter.hasNext()) {
                IdTitle el = (IdTitle)iter.next();
                if (el != null && (!Utils.isBlankString((String)el.getTitle()) || el.getId() > 0)) continue;
                iter.remove();
            }
            if (a.getValueList().size() > 0) {
                ArrayList<String> val = new ArrayList<String>(a.getValueList().size());
                try (ContractParameterManager manager = new ContractParameterManager(this.con);){
                    for (IdTitle v : a.getValueList()) {
                        val.add(v.getId() > 0 ? manager.getMultiListTitle(v.getId()) : v.getTitle());
                    }
                }
                Collections.sort(val);
                a.setTitle(Utils.toString(val, (String)";"));
            }
        }
    }
}

