/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductPeriod;

public class ProductPeriodDao
extends AbstractIdDao<ProductPeriod> {
    private static final Logger logger = LogManager.getLogger();
    private PreparedStatement selectVersionPS;
    private PreparedStatement updateFlagsPS;
    private PreparedStatement updatePeriodPS;
    private PreparedStatement listPS;
    private boolean listPSNeedNonActive;

    public ProductPeriodDao(Connection con, int userId) {
        super(con, 0, "inv_product_period");
    }

    private int getVersion() throws SQLException {
        ResultSet rs;
        if (this.selectVersionPS == null) {
            this.selectVersionPS = this.con.prepareStatement("SELECT @vrsn");
        }
        int result = (rs = this.selectVersionPS.executeQuery()).next() ? rs.getInt(1) + 1 : -1;
        rs.close();
        return result;
    }

    private ProductPeriod getFromRS(ResultSet rs, boolean titleLoad) throws SQLException {
        return ProductPeriod.builder().setId(rs.getInt("id")).setContractId(rs.getInt("contractId")).setAccountId(rs.getInt("accountId")).setProductSpecId(rs.getInt("productSpecId")).setProductId(rs.getInt("productId")).setActivationTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("activationTime"))).setTimeFrom(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("timeFrom"))).setTimeTo(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("timeTo"))).setProlongationTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("prolongationTime"))).setFlags(rs.getInt("flags")).build();
    }

    protected ProductPeriod getFromRS(ResultSet rs) throws SQLException {
        return this.getFromRS(rs, false);
    }

    public void update(ProductPeriod b) throws BGException {
        try {
            this.updateImpl(b);
        }
        catch (SQLException e) {
            this.processException(e);
        }
    }

    protected void updateImpl(ProductPeriod productPeriod) throws BGException, SQLException {
        if (productPeriod.getId() <= 0) {
            PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (contractId, accountId, productSpecId, productId, activationTime, timeFrom, timeTo, prolongationTime, flags) VALUES (?,?,?,?,?,?,?,?,?)", 1);
            ps.setInt(1, productPeriod.getContractId());
            ps.setInt(2, productPeriod.getAccountId());
            ps.setInt(3, productPeriod.getProductSpecId());
            ps.setInt(4, productPeriod.getProductId());
            ps.setTimestamp(5, TimeUtils.convertDateToTimestampSeconds((Date)productPeriod.getActivationTime()));
            Timestamp timeFrom = TimeUtils.convertDateToTimestampSeconds((Date)productPeriod.getTimeFrom());
            ps.setTimestamp(6, timeFrom);
            ps.setTimestamp(7, TimeUtils.convertDateToTimestampSeconds((Date)productPeriod.getTimeTo()));
            ps.setTimestamp(8, timeFrom);
            ps.setInt(9, productPeriod.getFlags());
            ps.executeUpdate();
            productPeriod.setId(ServerUtils.lastInsertId(ps));
            ps.close();
        } else {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET timeFrom=?, timeTo=?, flags=?, version=version+1 WHERE id=? AND (@vrsn:=version) IS NOT NULL");
            ps.setTimestamp(1, TimeUtils.convertDateToTimestampSeconds((Date)productPeriod.getTimeFrom()));
            ps.setTimestamp(2, TimeUtils.convertDateToTimestampSeconds((Date)productPeriod.getTimeTo()));
            ps.setInt(3, productPeriod.getFlags());
            ps.setInt(4, productPeriod.getId());
            ps.executeUpdate();
            productPeriod.setVersion(this.getVersion());
            ps.close();
        }
    }

    public int addFlag(int id, int flag) throws SQLException {
        if (this.updateFlagsPS == null) {
            this.updateFlagsPS = this.con.prepareStatement("UPDATE inv_product_period SET flags=flags|(?), version=version+1 WHERE id=? AND (@vrsn:=version) IS NOT NULL");
        }
        this.updateFlagsPS.setInt(1, flag);
        this.updateFlagsPS.setInt(2, id);
        this.updateFlagsPS.executeUpdate();
        return this.getVersion();
    }

    public int updatePeriod(int id, Date time, Date prolongationTime) throws SQLException {
        if (this.updatePeriodPS == null) {
            this.updatePeriodPS = this.con.prepareStatement("UPDATE inv_product_period SET timeTo=?, prolongationTime=?, flags=flags&~(1<<0), version=version+1 WHERE id=? AND (@vrsn:=version) IS NOT NULL");
        }
        this.updatePeriodPS.setTimestamp(1, TimeUtils.convertDateToTimestampSeconds((Date)time));
        this.updatePeriodPS.setTimestamp(2, TimeUtils.convertDateToTimestampSeconds((Date)prolongationTime));
        this.updatePeriodPS.setInt(3, id);
        this.updatePeriodPS.executeUpdate();
        return this.getVersion();
    }

    public List<ProductPeriod> list(int moduleId, int contractId, int accountId, boolean kernel, Date time) throws BGException {
        return this.list(moduleId, contractId, accountId, kernel, time, time, true);
    }

    public List<ProductPeriod> list(int moduleId, int contractId, int accountId, boolean kernel, Date timeFrom, Date timeTo, boolean needNonActive) throws BGException {
        try {
            ArrayList<ProductPeriod> result = new ArrayList<ProductPeriod>();
            PreparedStatement ps = needNonActive == this.listPSNeedNonActive ? this.listPS : null;
            if (ps == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("SELECT product_period.* FROM ").append(this.tableName).append(" AS product_period");
                sb.append(" LEFT JOIN inv_product_spec as spec ON product_period.productSpecId=spec.id ");
                sb.append(" WHERE product_period.contractId=? AND (((? OR product_period.accountId=?) AND (? OR spec.moduleId=?)) OR (? AND spec.moduleId=0))");
                sb.append(" AND (? OR product_period.timeFrom IS NULL OR product_period.timeFrom<=?)");
                sb.append(" AND (? OR product_period.timeTo IS NULL OR product_period.timeTo>=?)");
                if (!needNonActive) {
                    sb.append("\n AND (product_period.timeTo IS NULL OR product_period.timeFrom<product.timeTo)");
                }
                sb.append("\n ORDER BY product_period.timeFrom");
                if (this.listPS != null) {
                    this.listPS.close();
                }
                ps = this.listPS = this.con.prepareStatement(sb.toString());
                this.listPSNeedNonActive = needNonActive;
            }
            ps.setInt(1, contractId);
            ps.setBoolean(2, accountId <= 0);
            ps.setInt(3, accountId);
            ps.setBoolean(4, moduleId <= 0);
            ps.setInt(5, moduleId);
            ps.setBoolean(6, kernel);
            ps.setBoolean(7, timeFrom == null);
            ps.setTimestamp(8, TimeUtils.convertDateToTimestamp((Date)timeFrom));
            ps.setBoolean(9, timeTo == null);
            ps.setTimestamp(10, TimeUtils.convertDateToTimestamp((Date)timeTo));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs, true));
            }
            rs.close();
            return result;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public int deleteByProductId(int contractId, int id) throws BGException {
        return this.delete("contractId=? AND productId=?", new Object[]{contractId, id});
    }

    public List<ProductPeriod> list(int contractId, int productId) throws BGException {
        return this.list("contractId=? AND productId=?", "id", new Object[]{contractId, productId});
    }

    public void recycle() throws BGException {
        if (this.listPS != null) {
            try {
                this.listPS.close();
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            this.listPS = null;
        }
        super.recycle();
    }
}

