/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.server.bean;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Node;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityDao;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecActivationMode;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductDao;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductSpecActivationModeDao;

public class ProductSpecDao
extends AbstractEntityDao<ProductSpec>
implements Directory<ProductSpec> {
    private final ProductSpecActivationModeDao activationModeDao;

    public ProductSpecDao(Connection con, int moduleId) {
        this(con, moduleId, 0);
    }

    public ProductSpecDao(Connection con) {
        this(con, 0, 0);
    }

    public ProductSpecDao(Connection con, int moduleId, int userId) {
        super(con, moduleId, userId, "inv_product_spec", null);
        this.activationModeDao = new ProductSpecActivationModeDao(con, moduleId);
    }

    @Override
    protected ProductSpec getFromRSImpl(ResultSet rs) throws SQLException, BGException {
        int id = rs.getInt("id");
        String data = rs.getString("data");
        data = data.isEmpty() ? "{}" : data;
        JSONObject json = new JSONObject(data);
        ArrayList<ProductSpecActivationModeData> modes = new ArrayList<ProductSpecActivationModeData>();
        JSONArray activationModes = json.optJSONArray("activationModes");
        if (activationModes != null) {
            for (int index = 0; index < activationModes.length(); ++index) {
                JSONObject modeJson = activationModes.getJSONObject(index);
                ProductSpecActivationModeData modeData = new ProductSpecActivationModeData();
                modeData.modeId = modeJson.optInt("modeId");
                modeData.from = TimeUtils.parseDate((String)modeJson.optString("dateFrom"), (String)"dd.MM.yyyy");
                modeData.to = TimeUtils.parseDate((String)modeJson.optString("dateTo"), (String)"dd.MM.yyyy");
                modes.add(modeData);
            }
        } else {
            this.activationModeDao.list(id).forEach(m -> {
                ProductSpecActivationModeData modeData = new ProductSpecActivationModeData();
                modeData.modeId = m.getId();
                modeData.from = m.getDateFrom();
                modeData.to = m.getDateTo();
                modes.add(modeData);
            });
        }
        HashMap modeMap = new HashMap();
        this.activationModeDao.list(modes.stream().map(a -> a.modeId).toList()).forEach(a -> modeMap.put(a.getId(), a));
        ArrayList<ProductSpecActivationMode> productSpecActivationModes = new ArrayList<ProductSpecActivationMode>();
        for (ProductSpecActivationModeData modeData : modes) {
            ProductSpecActivationMode activationMode = (ProductSpecActivationMode)modeMap.get(modeData.modeId);
            if (activationMode == null) continue;
            activationMode = activationMode.clone();
            activationMode.setDateFrom(modeData.from);
            activationMode.setDateTo(modeData.to);
            productSpecActivationModes.add(activationMode);
        }
        return ProductSpec.builder().setId(id).setEntityId(rs.getInt("entityId")).setModuleId(rs.getInt("moduleId")).setParentId(rs.getInt("parentId")).setPeriodic(rs.getBoolean("periodic")).setTitle(rs.getString("title")).setIdentifier(rs.getString("identifier")).setTariffIds(Utils.toIntegerSet((String)rs.getString("tariffIds"))).setContractLabels(Utils.toIntegerSet((String)rs.getString("contractLabels"))).setComment(rs.getString("comment")).setDescription(rs.getString("description")).setDateFrom((java.util.Date)rs.getDate("dateFrom")).setDateTo((java.util.Date)rs.getDate("dateTo")).setDepends(Utils.toIntegerSet((String)rs.getString("depends"))).setIncompatible(Utils.toIntegerSet((String)rs.getString("incompatible"))).setHideForCustomer(rs.getBoolean("hideForCustomer")).setHideForContractLabels(Utils.toIntegerSet((String)rs.getString("hideForContractLabels"))).setHideForContractGroupsMode(rs.getInt("hideForContractGroupsMode")).setActivationByCustomer(rs.getBoolean("activationByCustomer")).setDeactivationByCustomer(rs.getBoolean("deactivationByCustomer")).setNotRealtime(rs.getBoolean("notRealtime")).setPriority(rs.getInt("priority")).setSort(rs.getInt("sort")).setData(data).setActivationModeList(productSpecActivationModes).build();
    }

    protected void updateImpl(ProductSpec productSpec) throws BGException, SQLException {
        boolean insert = productSpec.getId() <= 0;
        String querySet = " SET entityId=?, moduleId=?, parentId=?, periodic=?, title=?, identifier=?, tariffIds=?, contractLabels=?, comment=?, description=?, dateFrom=?, dateTo=?, depends=?, incompatible=?, hideForCustomer=?, hideForContractLabels=?, hideForContractGroupsMode=?, activationByCustomer=?, deactivationByCustomer=?, notRealtime=?, priority=?, data=?";
        PreparedStatement ps = this.con.prepareStatement((insert ? "INSERT INTO " : "UPDATE ") + this.tableName + querySet + (insert ? "" : " WHERE id=?"), 1);
        int index = 1;
        ps.setInt(index++, productSpec.getEntityId());
        ps.setInt(index++, productSpec.getModuleId());
        ps.setInt(index++, productSpec.getParentId());
        ps.setBoolean(index++, productSpec.isPeriodic());
        ps.setString(index++, productSpec.getTitle());
        ps.setString(index++, productSpec.getIdentifier());
        ps.setString(index++, Utils.toString((Iterable)productSpec.getTariffIds()));
        ps.setString(index++, Utils.toString((Iterable)productSpec.getContractLabels()));
        ps.setString(index++, productSpec.getComment());
        ps.setString(index++, productSpec.getDescription());
        ps.setDate(index++, TimeUtils.convertDateToSqlDate((java.util.Date)productSpec.getDateFrom()));
        ps.setDate(index++, TimeUtils.convertDateToSqlDate((java.util.Date)productSpec.getDateTo()));
        ps.setString(index++, Utils.toString((Iterable)productSpec.getDepends()));
        ps.setString(index++, Utils.toString((Iterable)productSpec.getIncompatible()));
        ps.setBoolean(index++, productSpec.isHideForCustomer());
        ps.setString(index++, Utils.toString((Iterable)productSpec.getHideForContractLabels()));
        ps.setInt(index++, productSpec.getHideForContractGroupsMode());
        ps.setBoolean(index++, productSpec.isActivationByCustomer());
        ps.setBoolean(index++, productSpec.isDeactivationByCustomer());
        ps.setBoolean(index++, productSpec.isNotRealtime());
        ps.setInt(index++, productSpec.getPriority());
        ps.setString(index++, productSpec.getData());
        if (!insert) {
            ps.setInt(index, productSpec.getId());
        }
        ps.executeUpdate();
        if (insert) {
            productSpec.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    protected String getQueryById() {
        String query = "SELECT d.*, 0 AS entitySpecId FROM " + this.tableName + " AS d WHERE d.id=?";
        return query;
    }

    @Override
    public ProductSpec get(String title) throws BGException {
        return (ProductSpec)this.get("title=?", new Object[]{title});
    }

    public List<ProductSpec> list(int moduleId, java.util.Date dateFrom, java.util.Date dateTo, String title, List<FilterEntityAttr> entityFilter) throws BGException {
        Date sqlDateFrom = TimeUtils.convertDateToSqlDate((java.util.Date)dateFrom);
        Date sqlDateTo = TimeUtils.convertDateToSqlDate((java.util.Date)dateTo);
        return super.list(true, null, null, null, entityFilter, "(? OR moduleId=?) AND (? OR dateFrom IS NULL OR dateFrom<=?) AND (? OR dateTo IS NULL OR ?<=dateTo) AND (? OR " + this.tableName + ".title LIKE ?)", this.tableName + ".sort, " + this.tableName + ".id", null, moduleId < 0, moduleId, sqlDateTo == null, sqlDateTo, sqlDateFrom == null, sqlDateFrom, Utils.isBlankString((String)title), "%" + title + "%");
    }

    public List<ProductSpec> list(int moduleId) throws BGException {
        return this.list(moduleId, null, null, null, null);
    }

    @Override
    public List<ProductSpec> list() throws BGException {
        return this.list(-1, null, null, null, null);
    }

    public void move(int newParentId, Set<Integer> children) throws BGException {
        if (newParentId < 0 || children == null || children.size() == 0) {
            throw new BGIllegalArgumentException();
        }
        List<ProductSpec> list = this.list();
        for (Integer id : children) {
            ProductSpec child = (ProductSpec)TreeUtils.tree(list, (int)id);
            if (TreeUtils.find((Node)child, (int)newParentId) == null) continue;
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 \u0432 \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0439.");
        }
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET parentId=? WHERE id IN (" + Utils.toString(children) + ")");
            ps.setInt(1, newParentId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public ProductSpec getByIdentifier(String identifier) throws BGException {
        return this.getByIdentifier(identifier, 0);
    }

    public ProductSpec getByIdentifier(String identifier, int moduleId) throws BGException {
        ProductSpec result = null;
        String query = "SELECT " + this.tableName + ".*, entity.entitySpecId, entity.title as entityTitle FROM " + this.tableName + " LEFT JOIN entity ON entity.id=" + this.tableName + ".entityId WHERE " + this.tableName + ".identifier=?" + (String)(moduleId > 0 ? " AND " + this.tableName + ".moduleId=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setString(index++, identifier);
            if (moduleId > 0) {
                ps.setInt(index++, moduleId);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result = (ProductSpec)this.getFromRS(rs, true);
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    @Override
    public int delete(int id) throws BGException {
        try (ProductDao productDao = new ProductDao(this.con, this.userId);){
            productDao.checkProductSpecDelete(id);
            int n = super.delete(id);
            return n;
        }
    }

    public boolean reorder(int srcProductId, int parentProductId, int pos) throws BGException {
        boolean result = true;
        ProductSpec srcProductSpec = (ProductSpec)this.get(srcProductId);
        if (srcProductSpec == null) {
            result = false;
        } else if (srcProductSpec.getParentId() == parentProductId && pos > -1) {
            this.sort(parentProductId, srcProductId, pos);
        } else {
            try (PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET `parentId`=? WHERE `id`=?");){
                ps.setInt(1, parentProductId);
                ps.setInt(2, srcProductId);
                ps.executeUpdate();
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
            this.sort(srcProductSpec.getParentId(), 0, -1);
            this.sort(parentProductId, srcProductId, pos);
        }
        return result;
    }

    private void sort(int parentDeviceId, int srcDeviceId, int pos) throws BGException {
        int srcPos = 0;
        ArrayList<Integer> list = new ArrayList<Integer>();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT `id` FROM " + this.tableName + " WHERE `parentId`=? ORDER BY `sort`, `id`");){
            ps.setInt(1, parentDeviceId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int id = rs.getInt(1);
                    if (srcDeviceId != id) {
                        list.add(id);
                    }
                    srcPos = list.size();
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        if (srcDeviceId > 0) {
            if (pos > -1) {
                list.add(pos - (pos > srcPos ? 1 : 0), srcDeviceId);
            } else {
                list.add(srcDeviceId);
            }
        }
        try (PreparedStatement psUpdate = this.con.prepareStatement("UPDATE " + this.tableName + " SET `sort`=? WHERE `id`=?");){
            for (int index = 0; index < list.size(); ++index) {
                psUpdate.setInt(1, index);
                psUpdate.setInt(2, (Integer)list.get(index));
                psUpdate.executeUpdate();
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    class ProductSpecActivationModeData {
        int modeId;
        java.util.Date from;
        java.util.Date to;

        ProductSpecActivationModeData() {
        }
    }
}

