/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.systems.inventory.resource.common.bean.VlanResource;

public class VlanResourceDao
extends AbstractIdDao<VlanResource> {
    public VlanResourceDao(Connection con, int mid) {
        super(con, mid, "inv_vlan_resource");
    }

    protected VlanResource getFromRS(ResultSet rs) throws SQLException, BGException {
        VlanResource result = new VlanResource();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setVlanFrom(rs.getInt("vlanFrom"));
        result.setVlanTo(rs.getInt("vlanTo"));
        result.setDateFrom((Date)rs.getDate("dateFrom"));
        result.setDateTo((Date)rs.getDate("dateTo"));
        result.setComment(rs.getString("comment"));
        result.setCategoryId(rs.getInt("categoryId"));
        return result;
    }

    protected void updateImpl(VlanResource b) throws BGException, SQLException {
        PreparedStatement ps;
        if (b.getVlanTo() < 0 || b.getVlanFrom() < 0 || b.getVlanTo() < b.getVlanFrom() || Utils.isBlankString((String)b.getTitle())) {
            throw new BGIllegalArgumentException();
        }
        if (b.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (title, vlanFrom, vlanTo, dateFrom, dateTo, comment, categoryId ) VALUES (?,?,?,?,?,?,?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET title=?, vlanFrom=?, vlanTo=?, dateFrom=?, dateTo=?, comment=?, categoryId = ? WHERE id=?");
            ps.setInt(8, b.getId());
        }
        ps.setString(1, b.getTitle());
        ps.setInt(2, b.getVlanFrom());
        ps.setInt(3, b.getVlanTo());
        ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)b.getDateFrom()));
        ps.setDate(5, TimeUtils.convertDateToSqlDate((Date)b.getDateTo()));
        ps.setString(6, b.getComment());
        ps.setInt(7, b.getCategoryId());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    public List<VlanResource> list() throws BGException {
        return this.list(null, "id", new Object[0]);
    }

    public List<VlanResource> list(int categoryId) throws BGException {
        return this.list("categoryId=?", "id", new Object[]{categoryId});
    }

    public List<VlanResource> list(Set<Integer> categoryIds) throws BGException {
        if (categoryIds.size() == 0) {
            return new ArrayList<VlanResource>();
        }
        return this.list("categoryId IN (" + Utils.toString(categoryIds) + ")", "id", new Object[0]);
    }

    public List<VlanResource> list(Set<Integer> categoryIds, Date dateFrom, Date dateTo) throws BGException {
        if (categoryIds.size() == 0) {
            return new ArrayList<VlanResource>();
        }
        String filter = "categoryId IN (" + Utils.toString(categoryIds) + ") ";
        if (dateFrom != null) {
            filter = filter + " AND (dateFrom is NULL or dateFrom <= ?)";
        }
        if (dateTo != null) {
            filter = filter + " AND (dateTo is NULL or dateTo >= ?)";
        }
        if (dateFrom == null && dateTo == null) {
            return this.list(filter, "id", new Object[0]);
        }
        if (dateFrom != null && dateTo == null) {
            return this.list(filter, "id", new Object[]{dateFrom});
        }
        if (dateFrom == null && dateTo != null) {
            return this.list(filter, "id", new Object[]{dateTo});
        }
        return this.list(filter, "id", new Object[]{dateFrom, dateTo});
    }
}

