/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.table.BGUTableRowSorter;

public class ServicesEditor
extends BGPanel
implements ActionListener {
    private String selectedId = null;
    BGButtonPanelOkCancel bGControlPanel_021 = new BGButtonPanelOkCancel();
    BGDialogToolBar toolBar = new BGDialogToolBar();
    JTextField title = new JTextField();
    JCheckBox isusing = new JCheckBox("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f");
    JPanel editorPanel = new JPanel();
    BGTable services = new BGTable();

    public ServicesEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String rb_name = ClientUtils.getRBName(this);
        this.services.setHeader(rb_name, "4");
        this.services.setRowSorter(new BGUTableRowSorter<TableModel>(this.services.getModel()));
        this.toolBar.setDefaultButtons(this, BGDialogToolBar.ButtonData.NEW_ITEM, BGDialogToolBar.ButtonData.EDIT_ITEM, BGDialogToolBar.ButtonData.DELETE_ITEM);
        this.editorPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ServicesEditor.this.setData();
            }
        });
        this.services.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ServicesEditor.this.editItem();
                }
            }
        });
    }

    private void jbInit() throws Exception {
        this.editorPanel.setLayout(new GridBagLayout());
        this.editorPanel.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.title.setMinimumSize(new Dimension(4, 24));
        this.title.setPreferredSize(new Dimension(4, 24));
        this.title.setText("");
        this.bGControlPanel_021.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServicesEditor.this.bGControlPanel_021_actionPerformed(e);
            }
        });
        this.toolBar.setFloatable(false);
        this.editorPanel.add((Component)this.title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        this.editorPanel.add((Component)this.isusing, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        this.editorPanel.add((Component)this.bGControlPanel_021, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.editorPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JScrollPane(this.services), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
    }

    void bGControlPanel_021_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("reset".equals(actionCommand)) {
            this.editItem();
        } else if ("ok".equals(actionCommand)) {
            this.updateData();
        } else if ("cancel".equals(actionCommand)) {
            this.editorPanel.setVisible(false);
        }
    }

    private String getSelectedId() {
        String result = null;
        int pos = this.services.getSelectedRow();
        if (pos > -1) {
            result = (String)this.services.getValueAt(pos, 0);
        }
        return result;
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("GetServices");
        request.setAttribute("mid", this.getId());
        this.setDocument(TransferManager.getDocument(request));
    }

    private void updateData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("UpdateService");
        request.setAttribute("title", this.title.getText());
        request.setAttribute("mid", this.getId());
        request.setAttribute("id", this.selectedId);
        request.setAttribute("isusing", this.isusing.getModel().isSelected() ? "1" : "0");
        if (ClientUtils.checkStatus(TransferManager.getDocument(request))) {
            this.editorPanel.setVisible(false);
            this.setData();
        }
    }

    @Override
    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus(doc)) {
            this.services.updateData(XMLUtils.getNode(doc, "table"));
            this.editorPanel.setVisible(false);
        }
    }

    @Override
    public void newItem() {
        this.title.setText("\u041d\u043e\u0432\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430");
        this.selectedId = "new";
        this.editorPanel.setVisible(true);
    }

    @Override
    public void deleteItem() {
        String id = this.getSelectedId();
        if (id == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0443\u043d\u043a\u0442 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f!");
        } else {
            int code = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0443\u0441\u043b\u0443\u0433\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0);
            if (code == 0) {
                Request request = new Request();
                request.setModule(this.module);
                request.setAction("DeleteService");
                request.setAttribute("id", id);
                ClientUtils.checkStatus(TransferManager.getDocument(request));
            }
            this.setData();
        }
    }

    @Override
    public void editItem() {
        int pos = this.services.getSelectedRow();
        if (pos < 0) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0443\u043d\u043a\u0442 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
        } else {
            this.selectedId = (String)this.services.getValueAt(pos, 0);
            this.title.setText((String)this.services.getValueAt(pos, 1));
            this.isusing.setSelected((Boolean)this.services.getValueAt(pos, 2));
            this.editorPanel.setVisible(true);
        }
    }
}

