/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import ru.bitel.bgbilling.client.common.BGCalendarButton;
import ru.bitel.common.TimeUtils;

public class BGControlPanelDateAndHours
extends JPanel {
    private Integer hourTo = 0;
    private Integer hoFrom = -1;
    private Date date;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private BGCalendarButton dayButton = new BGCalendarButton();
    List<ActionListener> actionList = new ArrayList<ActionListener>();

    public BGControlPanelDateAndHours() {
        this.setLayout(new GridBagLayout());
        GregorianCalendar date = new GregorianCalendar();
        ((Calendar)date).add(5, -2);
        TimeUtils.clearCalendarHour(date);
        this.dayButton.putClientProperty("date", date);
        this.dayButton.setText(TimeUtils.format((Calendar)date, "dd.MM.yyyy"));
        JToggleButton firstButton = this.addButton(0, -1);
        firstButton.setSelected(true);
        this.add((Component)firstButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.addButton(-1, -2), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.addButton(-2, -4), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.addButton(-4, -8), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.addButton(-8, -24), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.dayButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.dayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BGControlPanelDateAndHours.this.setPeriod(1, 1, BGControlPanelDateAndHours.this.dayButton.getCalendar().getTime());
                BGControlPanelDateAndHours.this.performAction();
            }
        });
        this.dayButton.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("updateCalendar")) {
                    if (BGControlPanelDateAndHours.this.dayButton.getCalendar() == null) {
                        GregorianCalendar date = new GregorianCalendar();
                        ((Calendar)date).add(5, -2);
                        TimeUtils.clearCalendarHour(date);
                        BGControlPanelDateAndHours.this.dayButton.putClientProperty("date", date);
                        BGControlPanelDateAndHours.this.dayButton.setText(TimeUtils.format((Calendar)date, "dd.MM.yyyy"));
                    }
                    BGControlPanelDateAndHours.this.setPeriod(1, 1, BGControlPanelDateAndHours.this.dayButton.getCalendar().getTime());
                    BGControlPanelDateAndHours.this.performAction();
                }
            }
        });
        this.buttonGroup.add(this.dayButton);
    }

    private void performAction() {
        for (ActionListener listener : this.actionList) {
            listener.actionPerformed(new ActionEvent(this, 0, "ok"));
        }
    }

    private JToggleButton addButton(final int hourTo, final int hourFrom) {
        JToggleButton button = new JToggleButton(-hourTo + " - " + -hourFrom);
        button.setToolTipText(button.getText() + " \u0447\u0430\u0441\u043e\u0432 \u043d\u0430\u0437\u0430\u0434");
        button.setMargin(new Insets(2, 2, 2, 2));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BGControlPanelDateAndHours.this.setPeriod(hourTo, hourFrom, null);
                BGControlPanelDateAndHours.this.performAction();
                BGControlPanelDateAndHours.this.dayButton.clearOldCalendar();
            }
        });
        this.buttonGroup.add(button);
        return button;
    }

    private void setPeriod(Integer hourTo, Integer hourFrom, Date date) {
        this.hoFrom = hourFrom;
        this.hourTo = hourTo;
        this.date = date;
    }

    public Date getTimeFrom() {
        if (this.date != null) {
            return this.date;
        }
        GregorianCalendar now = new GregorianCalendar();
        ((Calendar)now).add(11, this.hoFrom);
        return now.getTime();
    }

    public Date getTimeTo() {
        if (this.date != null) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(this.date);
            ((Calendar)cal).add(5, 1);
            return cal.getTime();
        }
        GregorianCalendar now = new GregorianCalendar();
        ((Calendar)now).add(11, this.hourTo);
        return now.getTime();
    }

    public void addActionListener(ActionListener listener) {
        this.actionList.add(listener);
    }

    public Integer getHourTo() {
        return -this.hourTo.intValue();
    }

    public Integer getHourFrom() {
        return -this.hoFrom.intValue();
    }

    public Date getDate() {
        return this.date;
    }
}

