/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common.table;

import bitel.billing.module.contract.ContractEditor;
import bitel.billing.module.contract.ContractSubPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.tree.TreeNode;
import ru.bitel.bgbilling.client.util.ClientUtils;

public class BGTreeNode
extends TreeNode<BGTreeNode> {
    protected static final Icon folderIcon = ClientUtils.getIcon("node.png");
    protected static final Icon leafIcon = ClientUtils.getIcon("leaf.png");
    private String title = null;
    private final Class<? extends ContractSubPanel> panelClass;
    private ContractSubPanel component = null;
    private Object[] values = null;
    protected Map<String, Object> attribute = new HashMap<String, Object>(8);
    protected final Icon icon;
    protected boolean editable;
    List<BGTreeNode> groupNode = new ArrayList<BGTreeNode>();

    public List<BGTreeNode> getGroupNode() {
        return this.groupNode;
    }

    public void setGroupNode(List<BGTreeNode> groupNode) {
        this.groupNode = groupNode;
    }

    public BGTreeNode() {
        this(null, null);
    }

    public BGTreeNode(String title, Object value) {
        this(title, value, null);
    }

    public BGTreeNode(String title, Object value, Class<? extends ContractSubPanel> panelClass) {
        this(title, value, panelClass, null);
    }

    public BGTreeNode(String title, Object value, Class<? extends ContractSubPanel> panelClass, String icon) {
        this.title = title;
        this.values = new Object[1];
        this.values[0] = value;
        this.panelClass = panelClass;
        this.loaded = true;
        this.icon = icon != null ? ClientUtils.getIcon(icon) : null;
        this.id = this.hashCode();
    }

    public Class<? extends ContractSubPanel> getPanelClass() {
        return this.panelClass;
    }

    public void setAttribute(String key, Object value) {
        if (key != null && value != null) {
            this.attribute.put(key, value);
        }
    }

    public Object getAttribute(String key) {
        return key != null ? this.attribute.get(key) : null;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setValue(Object[] values) {
        this.values = values;
    }

    public void setValueAt(Object value, int column) {
        if (this.values != null && column - 1 > -1 && column - 1 < this.values.length) {
            this.values[column - 1] = value;
        }
    }

    @Override
    public Object getValueAt(int column) {
        if (column == 0 && this.title != null) {
            return this;
        }
        if (this.values != null && column - 1 > -1 && column - 1 < this.values.length) {
            return this.values[column - 1];
        }
        return null;
    }

    public String toString() {
        return this.title == null ? "" : this.title;
    }

    @Override
    public Icon getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        if (this.isLeaf()) {
            return leafIcon;
        }
        return folderIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContractSubPanel getComponent(JPanel parentPanel, ContractEditor parent) {
        if (this.component == null && this.panelClass != null) {
            boolean isCreated = false;
            for (BGTreeNode gNode : this.groupNode) {
                if (!gNode.isComponentCreated()) continue;
                this.component = gNode.getComponent(parentPanel, parent);
                this.id = gNode.getId();
                isCreated = true;
                break;
            }
            if (!isCreated) {
                ClientContext context = new ClientContext("kernel", 0, parent.getContractId(), null, null);
                ClientContext.push(context);
                try {
                    Constructor<?>[] constructors;
                    for (Constructor<?> constructor : constructors = this.panelClass.getConstructors()) {
                        if (constructor.getParameterCount() != 1 || !constructor.getParameterTypes()[0].equals(JPanel.class)) continue;
                        this.component = (ContractSubPanel)constructor.newInstance(parentPanel);
                    }
                    if (this.component == null) {
                        this.component = this.panelClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    parentPanel.add((Component)this.component, String.valueOf(this.id));
                    this.component.setParentComponent(parent);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    ClientContext.pop();
                }
            }
        }
        return this.component;
    }

    public boolean isComponentCreated() {
        return this.component != null;
    }

    public ContractSubPanel showComponent(JPanel parentPanel, CardLayout parentLayout, ContractEditor parent) {
        ContractSubPanel result = this.getComponent(parentPanel, parent);
        if (result != null) {
            parentLayout.show(parentPanel, String.valueOf(this.id));
        }
        return result;
    }

    public ContractSubPanel actionPerformed(EventObject e, JPanel parentPanel, CardLayout parentLayout, ContractEditor parent) {
        return e instanceof TreeSelectionEvent ? this.showComponent(parentPanel, parentLayout, parent) : null;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    private int getId() {
        return this.id;
    }
}

