/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.print.HtmlPrinter;
import bitel.billing.module.contract.ContractEditor;
import bitel.billing.module.contract.ContractPanel;
import bitel.billing.module.contract.ContractPanel_Card;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGEmailDialog;

public class ContractPanel_Card1
extends ContractPanel {
    private static final String VIEWER_TAB = "viewer";
    private static final String XML_TAB = "xml";
    private String html;
    private JPanel xmlPanel = new JPanel();
    private JPanel htmlPanel = new JPanel();
    private JTextArea xmlText = new JTextArea();
    private JTextPane textPane = new JTextPane();

    public ContractPanel_Card1(ContractEditor editor, ContractPanel_Card parent) {
        this.init(editor);
        this.htmlPanel.setLayout(new GridBagLayout());
        this.htmlPanel.add((Component)new JScrollPane(this.textPane), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.htmlPanel.setVisible(true);
        this.xmlText.setEditable(false);
        this.xmlPanel.setLayout(new GridBagLayout());
        this.xmlPanel.add((Component)new JScrollPane(this.xmlText), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.xmlPanel.setVisible(false);
        this.textPane.setContentType("text/html");
        this.textPane.setEditable(false);
        JPanel bodyPanel = new JPanel(new CardLayout());
        bodyPanel.add((Component)this.htmlPanel, VIEWER_TAB);
        bodyPanel.add((Component)this.xmlPanel, XML_TAB);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getButtonPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)bodyPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    private JPanel getButtonPanel() {
        JButton xmlButton = new JButton("XML");
        xmlButton.addActionListener(e -> {
            boolean visible = this.xmlPanel.isVisible();
            if (!visible) {
                this.setXML();
            }
            this.xmlPanel.setVisible(!visible);
            this.htmlPanel.setVisible(visible);
        });
        BGButtonPanel buttonPanel = new BGButtonPanel(BGButtonPanel.PRINT_M, BGButtonPanel.SAVE_M, BGButtonPanel.EMAIL_M);
        buttonPanel.addActionListener(e -> this.buttonPanel_actionPerformed(e));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)xmlButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 25), 0, 0));
        panel.add((Component)buttonPanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        panel.add(Box.createHorizontalStrut(8), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    public void buttonPanel_actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command != null) {
            if (BGButtonPanel.SAVE_M.equals(command)) {
                BGFileChooser fch = new BGFileChooser(this);
                if (fch.showSaveDialog() == 0) {
                    try {
                        ClientUtils.saveHtmlFile(this.html, fch.getSelectedFile());
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }
            } else if (BGButtonPanel.EMAIL_M.equals(command)) {
                BGEmailDialog dialog = new BGEmailDialog();
                dialog.addPropertyChangeListener(evt -> {
                    if (evt.getPropertyName().equals("selectEmail")) {
                        Request request = this.getRequest();
                        request.setAttribute("email", String.valueOf(evt.getNewValue()));
                        request.setAttribute("email_subject", "\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
                        if (ClientUtils.checkStatus(this.getDocument(request))) {
                            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u0438\u0441\u044c\u043c\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
                        }
                    }
                });
                dialog.loadEmailListFromContractParameter(this.getContractId(), 0);
                dialog.setVisible(true);
            } else if (BGButtonPanel.PRINT_M.equals(command)) {
                new HtmlPrinter(this.html, 800, 600);
            }
        }
    }

    @Override
    public void setData() {
        Request request = this.getRequest();
        request.setAttribute("contentType", "html");
        try {
            this.html = TransferManager.getString(request);
            this.html = this.html.replaceAll("<[Mm][Ee][Tt][Aa](.)+?>", "");
            this.textPane.setText(this.html);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void setXML() {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("ContractCardXml");
        request.setAttribute("cid", this.getContractId());
        request.setAttribute("contentType", XML_TAB);
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.xmlText.setText(XMLUtils.serializeToString(doc, true));
        }
    }

    private Request getRequest() {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("ContractCard");
        request.setAttribute("cid", this.getContractId());
        request.setAttribute("contentType", "html");
        return request;
    }
}

