/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.AWTViewer;
import bitel.billing.module.common.BGFileFilter;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.contract.ContractEditor;
import bitel.billing.module.contract.ContractPanel;
import bitel.billing.module.contract.ContractPanel_Card;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.util.stream.Stream;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractCard;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGEmailDialog;
import ru.bitel.common.client.BGUComboBox;

public class ContractPanel_Card2
extends ContractPanel {
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private AWTViewer viewer = new AWTViewer();
    private JComboBox<ComboBoxItem> scale = new JComboBox();
    private JButton xmlButton = new JButton();
    private BGUComboBox<ContractCard> card = new BGUComboBox();
    private CardLayout cardLayout = new CardLayout();
    private JPanel bodyPanel = new JPanel(this.cardLayout);
    private JPanel xmlPanel = new JPanel(new GridBagLayout());
    private JTextArea xmlText = new JTextArea();
    private static final String VIEWER_TAB = "viewer";
    private static final String XML_TAB = "xml";
    private ContractService contractService = null;
    private ContractPanel_Card parent = null;

    public ContractPanel_Card2(ContractEditor editor, ContractPanel_Card parent) {
        this.init(editor);
        this.jbInit();
        this.pagePanel.setKey(this.getClass().getName());
        this.parent = parent;
    }

    private void jbInit() {
        this.xmlButton.setText("XML");
        this.xmlText.setEditable(false);
        this.scale.removeAllItems();
        Stream.of(25, 50, 75, 100, 125, 150, 175, 200).forEach(a -> this.scale.addItem(new ComboBoxItem(a, String.valueOf(a))));
        this.scale.setSelectedIndex(3);
        BGButtonPanel controlPanel = new BGButtonPanel(BGButtonPanel.PRINT_M, BGButtonPanel.SAVE_M, BGButtonPanel.EMAIL_M);
        controlPanel.addActionListener(e -> this.controlActionPerformed(e));
        int gridx = 0;
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)this.xmlButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 30, 0, 5), 0, 0));
        topPanel.add((Component)controlPanel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 30, 0, 5), 0, 0));
        topPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        topPanel.add((Component)new JLabel(" \u0420\u0430\u0437\u043c\u0435\u0440: "), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
        topPanel.add(this.scale, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        topPanel.add((Component)this.pagePanel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.xmlPanel.add((Component)new JScrollPane(this.xmlText), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.bodyPanel.add((Component)this.viewer, VIEWER_TAB);
        this.bodyPanel.add((Component)this.xmlPanel, XML_TAB);
        this.viewer.setVisible(true);
        this.xmlPanel.setVisible(false);
        this.setLayout(new GridBagLayout());
        this.add(this.card, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 15, 5, 5), 0, 0));
        this.add((Component)topPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 15), 0, 0));
        this.add((Component)this.bodyPanel, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.xmlButton.addActionListener(e -> this.xmlButton_actionPerformed(e));
        this.scale.addItemListener(e -> this.scale_itemStateChanged(e));
        this.pagePanel.addPropertyChangeListener(e -> this.pages_propertyChange(e));
        this.card.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.showCard();
            }
        });
        try {
            this.viewer.setScaleFactor(1.0);
        }
        catch (BGException bGException) {
            // empty catch block
        }
        this.viewer.setMouseScaleListener(new AWTViewer.MouseScaleListener(){

            @Override
            public void scaleUp() {
                if (ContractPanel_Card2.this.scale.getSelectedIndex() < ContractPanel_Card2.this.scale.getItemCount() - 1) {
                    ContractPanel_Card2.this.scale.setSelectedIndex(ContractPanel_Card2.this.scale.getSelectedIndex() + 1);
                }
            }

            @Override
            public void scaleDown() {
                if (ContractPanel_Card2.this.scale.getSelectedIndex() > 0) {
                    ContractPanel_Card2.this.scale.setSelectedIndex(ContractPanel_Card2.this.scale.getSelectedIndex() - 1);
                }
            }
        });
    }

    private void controlActionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command != null) {
            if (BGButtonPanel.SAVE_M.command.equals(command)) {
                BGFileChooser fch = new BGFileChooser(this);
                fch.addChoosableFileFilter(new BGFileFilter("pdf", "PDF"));
                if (fch.showSaveDialog() == 0) {
                    ContractCard item = (ContractCard)this.card.getSelectedItem();
                    if (item == null) {
                        return;
                    }
                    Request request = this.getRequest(item.getId());
                    request.setAttribute("contentType", "application/pdf");
                    byte[] out = this.getBytes(request);
                    try {
                        ClientUtils.saveBinaryFile(out, fch.getSelectedFile(), ".pdf");
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }
            } else if (BGButtonPanel.EMAIL_M.command.equals(command)) {
                ContractCard item = (ContractCard)this.card.getSelectedItem();
                if (item == null) {
                    return;
                }
                BGEmailDialog dialog = new BGEmailDialog();
                dialog.addPropertyChangeListener(evt -> {
                    if (evt.getPropertyName().equals("selectEmail")) {
                        Request request = this.getRequest(item.getId());
                        request.setAttribute("maildest", String.valueOf(evt.getNewValue()));
                        if (ClientUtils.checkStatus(this.getDocument(request))) {
                            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u0438\u0441\u044c\u043c\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
                        }
                    }
                });
                dialog.loadEmailListFromContractParameter(this.getContractId(), 0);
                dialog.setVisible(true);
            } else if (BGButtonPanel.PRINT_M.command.equals(command)) {
                this.viewer.print();
            }
        }
    }

    void scale_itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 2) {
            return;
        }
        ComboBoxItem selectedScaleValue = (ComboBoxItem)this.scale.getSelectedItem();
        if (selectedScaleValue != null) {
            try {
                this.viewer.setScaleFactor((double)((Integer)selectedScaleValue.getObject()).intValue() / 100.0);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                ClientUtils.showErrorMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u043c\u0430\u0441\u0448\u0442\u0430\u0431\u0430 (\u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u043c?)");
            }
        }
    }

    void pages_propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName != null && propertyName.startsWith("to")) {
            try {
                this.viewer.showPage(this.pagePanel.getPageIndex() - 1);
            }
            catch (BGException e1) {
                e1.printStackTrace();
                ClientUtils.showErrorMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b " + this.pagePanel.getPageIndex() + " (\u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u043c?)");
            }
        }
    }

    void xmlButton_actionPerformed(ActionEvent e) {
        boolean visible = this.xmlPanel.isVisible();
        if (!visible) {
            this.setXML(((ContractCard)this.card.getSelectedItem()).getId());
        }
        this.xmlPanel.setVisible(!visible);
        this.viewer.setVisible(visible);
    }

    @Override
    public void setData() {
        if (!this.init) {
            this.init();
        }
        this.showCard();
    }

    public void init() {
        this.init = true;
        try {
            this.card.setData(this.getContractService().contractCardList(this.getContractId()));
            this.parent.setActiveTab(this.card.getData().isEmpty() ? 1 : 2);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    public void showCard() {
        Request request;
        Document doc;
        ContractCard item = (ContractCard)this.card.getSelectedItem();
        if (item != null && ClientUtils.checkStatus(doc = TransferManager.getDocument(request = this.getRequest(item.getId())))) {
            try {
                this.viewer.setData(doc);
                this.pagePanel.setPageIndex(1);
                this.pagePanel.setPageCount(this.viewer.getNumberOfPages() > 0 ? this.viewer.getNumberOfPages() : 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Request getRequest(String type) {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("ContractCard2");
        request.setAttribute("cid", this.getContractId());
        request.setAttribute("type", type);
        return request;
    }

    private void setXML(String type) {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("ContractCardXml");
        request.setAttribute("cid", this.getContractId());
        request.setAttribute("type", type);
        request.setAttribute("contentType", XML_TAB);
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.xmlText.setText(XMLUtils.serializeToString(doc, true));
        }
    }

    private ContractService getContractService() {
        if (this.contractService == null) {
            this.contractService = this.getContext().getPort(ContractService.class, 0);
        }
        return this.contractService;
    }
}

