/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.CheckListCellRenderer;
import bitel.billing.module.common.ListItem;
import bitel.billing.module.contract.ContractSubPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventSubscriber;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractEmailEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttrType;

public class ContractSubPanel_Password
extends ContractSubPanel
implements EventSubscriber<UpdateContractEmailEvent> {
    private BGTableModel<Element> tableModel = null;
    private JCheckBox generate = new JCheckBox("\u0430\u0432\u0442\u043e");
    private JPasswordField password = new JPasswordField();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private BGControlPanelListSelect emailList = new BGControlPanelListSelect();
    private JTextArea customEmails = new JTextArea(5, 10);
    private JLabel recordCountLabel = new JLabel();

    public ContractSubPanel_Password() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EventBus.subscribe(UpdateContractEmailEvent.class, (EventSubscriber)this);
    }

    public void onEvent(UpdateContractEmailEvent event) {
        if (event.getContractId() == this.getContractId()) {
            this.setEmailData();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getSendPasswordPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.getLogPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
    }

    private JPanel getSendPasswordPanel() {
        this.customEmails.setMargin(new Insets(3, 3, 3, 3));
        CheckListCellRenderer<ListItem> cellRenderer = new CheckListCellRenderer<ListItem>(){

            @Override
            public void setText(String text) {
                StringBuilder str = new StringBuilder("<html><div style='font-size: 15pt; font-style: italic; margin-top: 3px; margin-left: 3px;'>").append(text.startsWith("<") ? "?????" : "").append(text.replaceFirst("<", "</div><div style='font-size: 11pt; color: #a0a0a0;'>&lt;")).append("</div></html>");
                super.setText(str.toString());
            }
        };
        this.emailList.getList().setCellRenderer((ListCellRenderer<ListItem>)cellRenderer);
        BGButton sendButton = new BGButton("\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c");
        sendButton.addActionListener(this::sendButton_actionPerformed);
        JPanel customEmailPanel = new JPanel(new GridBagLayout());
        Dimension dimension = customEmailPanel.getPreferredSize();
        dimension.setSize(dimension.width, 200);
        customEmailPanel.setMinimumSize(dimension);
        customEmailPanel.setPreferredSize(dimension);
        customEmailPanel.setBorder(new BGTitleBorder(" \u0414\u0440\u0443\u0433\u0438\u0435 e-mail \u0430\u0434\u0440\u0435\u0441\u0430  "));
        customEmailPanel.add((Component)new JScrollPane(this.customEmails), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        customEmailPanel.add((Component)new CommentLabel("( \u043a\u0430\u0436\u0434\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 \u043d\u0430 \u043d\u043e\u0432\u043e\u0439 \u0441\u0442\u0440\u043e\u043a\u0435 )"), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        TitlePanel panel = new TitlePanel(" \u0412\u044b\u0441\u043b\u0430\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c \u043d\u0430 e-mail ");
        dimension = panel.getPreferredSize();
        dimension.setSize(350, dimension.height);
        panel.setMinimumSize(dimension);
        panel.setPreferredSize(dimension);
        panel.add((Component)this.emailList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)customEmailPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)sendButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getLogPanel() {
        this.tableModel = new BGTableModel<Element>("contractPasswordLog"){

            @Override
            protected void initColumns() {
                this.addColumn("\u0414\u0430\u0442\u0430", 200, 200, 200, "dt", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
                this.addColumn("\u0418\u0441\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c", -1, -1, -1, "userName", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            }
        };
        final BGUTable table = new BGUTable(this.tableModel);
        table.setSelectionMode(0);
        table.getRowSorter().addRowSorterListener(new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent event) {
                if (event.getType() == RowSorterEvent.Type.SORT_ORDER_CHANGED) {
                    ContractSubPanel_Password.this.pagePanel.setPageIndex(1);
                    ContractSubPanel_Password.this.setData(table.getRowSorter().getSortKeys());
                }
            }
        });
        this.password.setText("");
        this.password.setMinimumSize(new Dimension(110, 24));
        this.password.setPreferredSize(new Dimension(114, 24));
        this.password.setColumns(20);
        this.password.setHorizontalAlignment(0);
        BGButton BOK = new BGButton("OK");
        BOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContractSubPanel_Password.this.saveButton_actionPerformed(e);
            }
        });
        JPanel editPasswordPanel = new JPanel(new GridBagLayout());
        editPasswordPanel.add((Component)new JLabel("\u041f\u0430\u0440\u043e\u043b\u044c:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        editPasswordPanel.add((Component)this.password, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        editPasswordPanel.add((Component)this.generate, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        editPasswordPanel.add((Component)BOK, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.pagePanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                String propertyName = event.getPropertyName();
                if (propertyName != null && propertyName.startsWith("to")) {
                    ContractSubPanel_Password.this.setData(table.getRowSorter().getSortKeys());
                }
            }
        });
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)editPasswordPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this.recordCountLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        topPanel.add((Component)this.pagePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)topPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)new JScrollPane(table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        return panel;
    }

    @Override
    public void setData() {
        this.setData(null);
    }

    protected void setData(List<? extends RowSorter.SortKey> sortList) {
        this.setEmailData();
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ContractPassword");
        request.setContractId(this.getContractId());
        request.setPage(this.pagePanel);
        if (sortList != null) {
            StringBuilder sortOrder = new StringBuilder();
            for (RowSorter.SortKey sortKey : sortList) {
                if (sortKey.getSortOrder() == SortOrder.UNSORTED) continue;
                sortOrder.append(this.tableModel.getIdentifier(sortKey.getColumn())).append(":").append(sortKey.getSortOrder().ordinal()).append(";");
            }
            request.setAttribute("sortOrder", sortOrder.toString());
        }
        this.setDocument(this.getDocument(request));
    }

    public void setEmailData() {
        try {
            DefaultListModel<ListItem> model = this.emailList.getListModel();
            model.clear();
            Map<Integer, EntityAttr> map = this.getContext().getPort(ContractService.class).contractParameterMapByType(this.getContractId(), EntitySpecAttrType.EMAIL.getCode()).getMap();
            map.forEach((a, b) -> ((EntityAttrEmail)b).getContactList().stream().forEach(c -> model.addElement(new ListItem(c.toString()))));
            this.customEmails.setText("");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus(doc)) {
            Element tableElement = XMLUtils.selectElement(doc, "//table");
            ArrayList<Element> list = new ArrayList<Element>();
            for (Element rowElement : XMLUtils.selectElements(tableElement, "data/row")) {
                list.add(rowElement);
            }
            this.tableModel.setData(list);
            this.pagePanel.setPageCount(tableElement);
            this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + tableElement.getAttribute("recordCount"));
        }
    }

    private void sendButton_actionPerformed(ActionEvent e) {
        StringBuffer list = new StringBuffer();
        DefaultListModel model = (DefaultListModel)this.emailList.getList().getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            ListItem item = (ListItem)model.elementAt(i);
            if (!item.isSelected()) continue;
            list.append(item.getText());
            list.append("\n");
        }
        list.append(this.customEmails.getText());
        if (list.length() == 0) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u0435 \u043e\u0434\u0438\u043d \u0430\u0434\u0440\u0435\u0441!");
        } else {
            try {
                this.getContext().getPort(ContractService.class).sendWebPasswordOfContractToEmail(list.toString(), this.getContractId());
                ClientUtils.showMessageDialog("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e");
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    private void saveButton_actionPerformed(ActionEvent e) {
        char[] pswd1 = this.password.getPassword();
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("UpdateContractPassword");
        request.setContractId(this.getContractId());
        request.setAttribute("value", new String(pswd1));
        if (this.generate.isSelected()) {
            request.setAttribute("set_pswd", "1");
        }
        if (ClientUtils.checkStatus(this.getDocument(request))) {
            this.setData();
        }
    }

    class CommentLabel
    extends JLabel {
        public CommentLabel(String text) {
            super(text);
            this.setFont(new Font("SansSerif", 2, 10));
            this.setForeground(Color.DARK_GRAY);
        }
    }

    class TitlePanel
    extends JPanel {
        TitlePanel(String borderTitle) {
            this.setLayout(new GridBagLayout());
            this.setBorder(new BGTitleBorder(borderTitle));
        }
    }
}

