/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.contract.PaymentAndChargeEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractBalance;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.BalanceService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.table.BGTableModel;

public class PaymentDistributePanel
extends BGPanel {
    public static final int DISTRIBUTE_MODE = 0;
    public static final int PAYMENT_MODE = 1;
    private BGTableModel<ClassForTable> model = null;
    private BGUTable table = new BGUTable(this.model);
    private BGTextField sumCost = null;
    private int mode;

    public PaymentDistributePanel(int mode, JDialog parentDialog) {
        this.mode = mode;
        this.parentDialog = parentDialog;
        this.model = new BGTableModel<ClassForTable>("", ClassForTable.class){

            @Override
            protected void initColumns() {
                this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 100, 100, -1, "title", false);
                this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 100, 100, -1, "comment", false);
                this.addColumn("\u0411\u0430\u043b\u0430\u043d\u0441/\u0421\u0430\u043b\u044c\u0434\u043e", BigDecimal.class, 50, 50, -1, "saldoSum", false);
                this.addColumn("\u0421\u0443\u043c\u043c\u0430", BigDecimal.class, 50, 50, -1, "sum", false, true, DecimalTableCellRenderer.DEFAULT());
            }
        };
        this.table = new BGUTable(this.model);
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new BGTitleBorder(" \u0420\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 "));
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        if (this.mode == 1) {
            JPanel sumPanel = new JPanel(new GridBagLayout());
            sumPanel.add((Component)new JLabel("\u0418\u0442\u043e\u0433\u043e:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.sumCost = new BGTextField(15);
            this.sumCost.setEditable(false);
            this.sumCost.setHorizontalAlignment(4);
            this.sumCost.setToolTipText("\u041e\u0431\u0449\u0430\u044f \u0437\u0430\u0434\u043e\u043b\u0436\u0435\u043d\u043d\u043e\u0441\u0442\u044c:");
            sumPanel.add((Component)this.sumCost, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 0, 15), 0, 0));
            this.sumCost.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && PaymentDistributePanel.this.sumCost.getText().substring(0, 1).equals("-") && PaymentDistributePanel.this.parentDialog instanceof PaymentAndChargeEditor) {
                        ((PaymentAndChargeEditor)PaymentDistributePanel.this.parentDialog).setSumma(PaymentDistributePanel.this.sumCost.getText().substring(1));
                    }
                }
            });
            this.add((Component)sumPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 5, 5, 5), 0, 0));
        }
    }

    @Override
    public void setData() {
        try {
            Pattern pattern = null;
            try {
                String reg = this.getSetup().get("dbinfo.payment.show.balance.invisible.subcontracts.mask", null);
                pattern = reg != null ? Pattern.compile(reg) : null;
            }
            catch (Exception e) {
                String mes = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0435 \u043e\u0442\u0432\u0435\u0447\u0430\u044e\u0449\u0438\u0439 \u0437\u0430 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0441\u0443\u0431. \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u043f\u0440\u0438 \u0440\u0430\u0441\u043f\u0440. \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439. \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 - client.gui.payment.show.balance.invisible.subcontracts.mask";
                ClientUtils.showErrorMessageDialog(mes);
            }
            ArrayList<ClassForTable> list = new ArrayList<ClassForTable>();
            boolean creditVisible = this.getSetup().getBoolean("dbinfo.payment.show.balance.for.credit.contract", false);
            int year = Calendar.getInstance().get(1);
            int month = Calendar.getInstance().get(2) + 1;
            for (Contract contract : this.getContext().getPort(ContractService.class).contractSubList(this.getContractId(), 1, this.mode == 1)) {
                if (pattern != null && contract.getId() != this.getContractId() && pattern.matcher(contract.getTitle()).matches()) continue;
                list.add(new ClassForTable(contract, creditVisible, year, month));
            }
            this.model.setData(list);
            if (this.mode == 1) {
                this.generateTotal();
            }
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void generateTotal() {
        BigDecimal fullSumma = BigDecimal.ZERO;
        for (ClassForTable c : this.model.getRows()) {
            fullSumma = fullSumma.add(c.sum);
        }
        this.sumCost.setText(Utils.formatBigDecimalSumm(fullSumma));
    }

    public void summaChanged(String summa) {
        if (this.mode == 1) {
            BigDecimal fullSumma = Utils.parseBigDecimal(summa, BigDecimal.ZERO);
            int rowCount = this.table.getRowCount();
            int row = 0;
            for (int i = 0; i < rowCount; ++i) {
                row = this.setup.getInt("payment.distribution.mode", 0) == 0 ? i : rowCount - 1 - i;
                this.model.getRows().get(row).setSum(BigDecimal.ZERO);
                BigDecimal debt = this.model.getRows().get(row).getSaldoSum();
                if (debt.compareTo(BigDecimal.ZERO) >= 0 || fullSumma.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal toPay = debt.negate().min(fullSumma);
                this.model.getRows().get(row).setSum(toPay);
                fullSumma = fullSumma.subtract(toPay);
            }
            if (fullSumma.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal sum = this.model.getRows().get(0).getSum();
                sum = sum.add(fullSumma);
                this.model.getRows().get(0).setSum(sum);
            }
            this.table.repaint();
        }
    }

    public int getRowCount() {
        return this.model.getRowCount();
    }

    public String getDistribution() {
        StringBuilder result = new StringBuilder();
        for (ClassForTable val : this.model.getRows()) {
            result.append(val.getStringForDistribution());
        }
        if (result.length() > 0) {
            return result.substring(0, result.length() - 1);
        }
        return result.toString();
    }

    public String checkValidDistribution(String summa) {
        BigDecimal total = BigDecimal.ZERO;
        for (ClassForTable val : this.model.getRows()) {
            total = total.add(val.distributionSum == null ? BigDecimal.ZERO : val.distributionSum);
        }
        BigDecimal payment = Utils.parseBigDecimal(summa, BigDecimal.ZERO);
        if (this.mode == 1) {
            if (total.compareTo(payment) != 0) {
                return "\u041d\u0435\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0432\u043d\u043e\u0441\u0438\u043c\u043e\u0439 \u0441\u0443\u043c\u043c\u044b \u0438 \u0441\u0443\u043c\u043c\u044b \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439. \u0412\u043d\u043e\u0441\u0438\u043c\u0430\u044f \u0441\u0443\u043c\u043c\u0430: " + Utils.formatBigDecimalSumm(payment) + ". \u0420\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435: " + Utils.formatBigDecimalSumm(total);
            }
        } else if (total.compareTo(payment) >= 0) {
            return "\u0421\u0443\u043c\u043c\u0430 \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0431\u043e\u043b\u044c\u0448\u0435 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430. \u0421\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0435 \u0441\u0440\u0435\u0434\u0441\u0442\u0432\u0430: " + Utils.formatBigDecimalSumm(payment) + ". \u0420\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435: " + Utils.formatBigDecimalSumm(total);
        }
        return "ok";
    }

    public class ClassForTable
    extends Contract {
        public BigDecimal distributionSum = BigDecimal.ZERO;
        public BigDecimal sum = BigDecimal.ZERO;

        public ClassForTable(Contract contract, boolean creditVisible, int year, int month) throws BGException {
            this.id = contract.getId();
            this.title = contract.getTitle();
            this.setComment(contract.getComment());
            ContractBalance balance = PaymentDistributePanel.this.getContext().getPort(BalanceService.class).contractBalanceGet(this.id, year, month);
            this.sum = contract.getBalanceMode() == 0 && !creditVisible ? balance.toSaldo() : balance.toBalance();
        }

        String getStringForDistribution() {
            return this.id + ":" + Utils.formatBigDecimalSumm(this.distributionSum) + ",";
        }

        public BigDecimal getSum() {
            return this.distributionSum;
        }

        public void setSum(BigDecimal sum) {
            this.distributionSum = sum;
        }

        public BigDecimal getSaldoSum() {
            return this.sum;
        }

        public void setSaldoSum(BigDecimal saldoSum) {
            this.sum = saldoSum;
        }
    }
}

