/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.contract.ParameterEditor;
import jakarta.xml.ws.Holder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.PhoneUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;

public class PhoneEditor
extends ParameterEditor {
    private static final String KEY_PREFIX = "contract.parameter.phone.prefix";
    private BGTextField phoneField = null;
    private List<Phone> phones = new ArrayList<Phone>();
    private JPanel panelInScroll = new JPanel(new GridBagLayout());
    private JScrollPane scrollPane = new JScrollPane(this.panelInScroll);
    private BGButton bgButtonAdd = new BGButton();
    private Font font = new Font("Dialog", 0, 14);
    private int countPhone = -1;
    private int customLengthNumber = -1;
    private String formats = "";
    private PhonePopup phonePopup = null;
    private KeyListener keyListener = null;
    private FocusListener focusListener = null;
    private DocumentListener documentListener = null;
    private MouseListenerJButtonDelete mouseListenerJButtonDelete = new MouseListenerJButtonDelete();

    public PhoneEditor() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void jbInit() throws Exception {
        this.keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (PhoneEditor.this.phonePopup != null) {
                    if (keyEvent.getKeyCode() == 27) {
                        PhoneEditor.this.phonePopup.getPopup().hide();
                        PhoneEditor.this.phonePopup = null;
                    } else if (keyEvent.getKeyCode() == 40) {
                        PhoneEditor.this.phonePopup.selectedMove(1);
                    } else if (keyEvent.getKeyCode() == 38) {
                        PhoneEditor.this.phonePopup.selectedMove(-1);
                    } else if (keyEvent.getKeyCode() == 10) {
                        PhoneEditor.this.phonePopup.select();
                    }
                }
            }
        };
        this.focusListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (PhoneEditor.this.phonePopup != null) {
                    PhoneEditor.this.phonePopup.getPopup().hide();
                    PhoneEditor.this.phonePopup = null;
                }
                ((BGTextField)focusEvent.getSource()).getDocument().removeDocumentListener(PhoneEditor.this.getDocumentListener());
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                PhoneEditor.this.phoneField = (BGTextField)focusEvent.getSource();
                PhoneEditor.this.phoneField.getDocument().addDocumentListener(PhoneEditor.this.getDocumentListener());
            }
        };
        this.bgButtonAdd.setIcon(ClientUtils.getIcon("item_add.png"));
        this.bgButtonAdd.setBorder(null);
        this.bgButtonAdd.setToolTipText("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0442\u0435\u043b\u0435\u0444\u043e\u043d");
        this.bgButtonAdd.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                String lastPhones;
                String[] splitPhones = null;
                boolean flag = false;
                if (PhoneEditor.this.countPhone != 0 && (splitPhones = (lastPhones = PhoneEditor.this.phones.get((int)(PhoneEditor.this.countPhone - 1)).phone.getText()).split("\\s*[()+]\\s*")).length != 0 && lastPhones.length() != 0) {
                    flag = true;
                }
                if (PhoneEditor.this.countPhone == 0) {
                    flag = true;
                }
                if (flag) {
                    PhoneEditor.this.phones.add(new Phone(PhoneEditor.this.keyListener, PhoneEditor.this.focusListener, PhoneEditor.this.mouseListenerJButtonDelete));
                    ++PhoneEditor.this.countPhone;
                    PhoneEditor.this.paintPanelInScroll();
                }
            }
        });
        this.bgButtonAdd.setPreferredSize(new Dimension(30, 20));
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.bgButtonAdd, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.scrollPane, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private DocumentListener getDocumentListener() {
        if (this.documentListener == null) {
            this.documentListener = new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    PhoneEditor.this.setTextPhoneField();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    PhoneEditor.this.setTextPhoneField();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    PhoneEditor.this.setTextPhoneField();
                }
            };
        }
        return this.documentListener;
    }

    private void setTextPhoneField() {
        String phoneText = this.phoneField.getText().replaceAll("[^\\d]", "");
        if (phoneText.length() > 11 && phoneText.length() > this.customLengthNumber) {
            phoneText = phoneText.substring(0, Math.max(11, this.customLengthNumber));
        }
        if (phoneText.length() > 14) {
            phoneText = phoneText.substring(0, 14);
        }
        phoneText = PhoneUtils.getPhones(new EntityAttrPhone(0, 0, phoneText, ""), this.formats);
        if (this.phonePopup == null) {
            ClientSetup setup = ClientSetup.getInstance();
            String prefix = setup.get("dbinfo.contract.parameter.phone.prefix." + this.id, setup.get("dbinfo.contract.parameter.phone.prefix", null));
            this.phonePopup = new PhonePopup(this.phoneField, prefix);
            if (prefix != null && !prefix.isEmpty()) {
                this.phonePopup.getPopup().show();
            }
        }
        this.phonePopup.update(phoneText);
        if (this.phoneField.getText().equals(phoneText)) {
            return;
        }
        SwingUtilities.invokeLater(new UpdatePhoneField(this.phoneField, phoneText));
    }

    private void paintPanelInScroll() {
        this.panelInScroll.removeAll();
        if (this.phones.isEmpty()) {
            IntStream.range(0, this.countPhone).forEach(i -> this.phones.add(new Phone(this.keyListener, this.focusListener, this.mouseListenerJButtonDelete)));
        }
        int gridy = 0;
        int ins = 0;
        for (int i2 = 0; i2 < this.phones.size(); ++i2) {
            this.panelInScroll.add((Component)this.phones.get(i2), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(ins, 5, 5, 5), 0, 0));
            ins = 0;
        }
        this.panelInScroll.add(Box.createVerticalGlue(), new GridBagConstraints(0, gridy, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.panelInScroll.repaint();
        this.panelInScroll.updateUI();
    }

    @Override
    public boolean updateData() {
        String lastPhones;
        String[] splitPhones;
        if (this.countPhone > 0 && (splitPhones = (lastPhones = this.phones.get((int)(this.countPhone - 1)).phone.getText()).split("\\s*[()+]\\s*")).length == 0) {
            this.phones.remove(this.countPhone - 1);
            --this.countPhone;
        }
        boolean result = false;
        StringBuilder errorMessage = new StringBuilder();
        Request request = new Request();
        request.setAction("UpdatePhoneInfo");
        request.setModule(this.module);
        request.setContractId(this.getContractId());
        request.setAttribute("pid", this.id);
        for (int i = 0; i < this.countPhone && errorMessage.length() == 0; ++i) {
            String phone = this.phones.get((int)i).phone.getText().replaceAll("[^\\d]", "").trim();
            request.setAttribute("phone" + (i + 1), phone);
            request.setAttribute("comment" + (i + 1), this.phones.get((int)i).comment.getText().trim());
            request.setAttribute("count", this.countPhone);
            if (phone.length() != 0 && (phone.length() == 11 || phone.length() == this.customLengthNumber)) continue;
            errorMessage.append(" - \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0446\u0438\u0444\u0440 \u0432 \u043d\u043e\u043c\u0435\u0440\u0435 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430, \u043d\u0435 \u0440\u0430\u0432\u043d\u043e 11 " + (String)(this.customLengthNumber != 11 ? "\u0438\u043b\u0438 \u043d\u0435 \u0440\u0430\u0432\u043d\u043e " + this.customLengthNumber : ""));
        }
        if (errorMessage.length() == 0) {
            result = ClientUtils.checkStatus(TransferManager.getDocument(request));
            EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
        } else {
            ClientUtils.showErrorMessageDialog(errorMessage.toString());
        }
        return result;
    }

    @Override
    public void setData() {
        try {
            this.formats = this.getContext().getWebService(ContractParameterService.class, 0).paramPhoneFormats();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("GetPhoneInfo");
        request.setContractId(this.getContractId());
        request.setAttribute("pid", this.id);
        this.setDocument(TransferManager.getDocument(request));
    }

    @Override
    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus(doc)) {
            Element phoneElem = XMLUtils.selectElement(doc, "//phone");
            this.countPhone = Utils.parseInt(phoneElem.getAttribute("count"), 0);
            this.customLengthNumber = Utils.parseInt(phoneElem.getAttribute("customLengthNumber"), 11);
            this.customLengthNumber = this.customLengthNumber > 14 ? 14 : this.customLengthNumber;
            this.phones.clear();
            if (this.countPhone == 0) {
                ++this.countPhone;
            }
            this.paintPanelInScroll();
            for (int i = 0; i < this.countPhone; ++i) {
                String phone = XMLUtils.getAttribute(phoneElem, "phone" + (i + 1), "");
                this.phoneField = this.phones.get((int)i).phone;
                this.phoneField.setText(PhoneUtils.getPhones(new EntityAttrPhone(0, 0, phone, ""), this.formats));
                this.phones.get((int)i).comment.setText(XMLUtils.getAttribute(phoneElem, "comment" + (i + 1), ""));
            }
        }
    }

    class PhonePopup
    extends JPanel {
        private int index;
        private Popup popup;
        private String[] prefix;
        private List<JLabel> labels;
        private BGTextField phoneField;
        private Color color;
        private Color selectedColor;

        PhonePopup(BGTextField phoneField, String prefixs) {
            super(new GridBagLayout());
            this.index = -1;
            this.prefix = null;
            this.labels = new ArrayList<JLabel>();
            this.color = new Color(240, 240, 240);
            this.selectedColor = new Color(200, 200, 255);
            this.setBackground(this.color);
            this.phoneField = phoneField;
            int gridy = 0;
            int height = 0;
            if (prefixs != null) {
                for (String p : this.prefix = prefixs.split(",")) {
                    JLabel label = new JLabel(p);
                    label.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
                    label.setOpaque(true);
                    label.setBackground(this.color);
                    this.labels.add(label);
                    this.add((Component)this.labels.get(gridy), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                    height += label.getPreferredSize().height;
                }
            }
            this.setPreferredSize(new Dimension(phoneField.getSize().width, height));
        }

        Popup getPopup() {
            if (this.popup == null) {
                Point p = this.phoneField.getLocationOnScreen();
                PopupFactory popupFactory = PopupFactory.getSharedInstance();
                this.popup = popupFactory.getPopup(this.phoneField, this, p.x, p.y + this.phoneField.getSize().height);
            }
            return this.popup;
        }

        void update(String text) {
            Holder i = new Holder((Object)0);
            this.labels.forEach(e -> {
                e.setText(this.getPhone(this.prefix[(Integer)i.value], text));
                i.value = (Integer)i.value + 1;
            });
        }

        void select() {
            if (this.index > -1) {
                this.phoneField.setText(this.labels.get(this.index).getText());
                this.popup.hide();
            }
        }

        private String getPhone(String prefix, String value) {
            Object phoneText = prefix + value.replaceAll("[^\\d]", "");
            if (((String)phoneText).length() > 11 && ((String)phoneText).length() > PhoneEditor.this.customLengthNumber) {
                phoneText = ((String)phoneText).substring(0, Math.max(11, PhoneEditor.this.customLengthNumber));
            }
            if (((String)phoneText).length() > 14) {
                phoneText = ((String)phoneText).substring(0, 14);
            }
            return PhoneUtils.getPhones(new EntityAttrPhone(0, 0, (String)phoneText, ""), PhoneEditor.this.formats);
        }

        void selectedMove(int step) {
            this.index += step;
            if (this.index < 0) {
                this.index = this.labels.size() - 1;
            } else if (this.index > this.labels.size() - 1) {
                this.index = 0;
            }
            this.labels.forEach(e -> e.setBackground(this.color));
            this.labels.get(this.index).setBackground(this.selectedColor);
        }
    }

    private class MouseListenerJButtonDelete
    extends MouseAdapter {
        private MouseListenerJButtonDelete() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0435\u043b\u0435\u0444\u043e\u043d?", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0, 3) == 0) {
                PhoneEditor.this.phones.remove(PhoneEditor.this.phones.stream().filter(e -> e.buttonDelete == mouseEvent.getSource()).findFirst().orElse(null));
                --PhoneEditor.this.countPhone;
                PhoneEditor.this.paintPanelInScroll();
                PhoneEditor.this.scrollPane.repaint();
                PhoneEditor.this.scrollPane.updateUI();
            }
        }
    }

    class UpdatePhoneField
    implements Runnable {
        private BGTextField phoneField;
        private String text;

        public UpdatePhoneField(BGTextField phoneField, String text) {
            this.phoneField = phoneField;
            this.text = text;
        }

        @Override
        public void run() {
            this.phoneField.setText(this.text);
        }
    }

    class Phone
    extends JPanel {
        BGTextField phone;
        BGTextField comment;
        JButton buttonDelete;

        Phone(KeyListener keyListener, FocusListener focusListener, MouseListenerJButtonDelete mouseListenerJButtonDelete) {
            super(new GridBagLayout());
            this.phone = new BGTextField();
            this.comment = new BGTextField();
            this.buttonDelete = new JButton("X");
            this.buttonDelete.addMouseListener(mouseListenerJButtonDelete);
            this.phone.setFont(PhoneEditor.this.font);
            this.phone.setMinimumSize(new Dimension(180, 0));
            this.phone.setPreferredSize(new Dimension(180, 0));
            this.phone.addKeyListener(keyListener);
            this.phone.addFocusListener(focusListener);
            this.comment.setFont(PhoneEditor.this.font);
            this.add((Component)this.buttonDelete, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 10, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.phone, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.comment, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 11, 1, new Insets(0, 5, 0, 5), 0, 0));
        }
    }
}

