/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.RowData;

public class ContractParameterGroupEditor
extends BGPanel {
    private BGUTable groupTable = null;
    private GroupTableModel groupTableModel = new GroupTableModel();
    private ContractParameterService contractParameterService = null;

    public ContractParameterGroupEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.groupTable = new BGUTable(this.groupTableModel);
        this.groupTable.setSelectionMode(0);
        this.groupTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    ContractParameterGroupEditor.this.editItem();
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder(" \u0413\u0440\u0443\u043f\u043f\u044b \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 "));
        panel.add((Component)new JScrollPane(this.groupTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.setVisible(true);
        this.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private ContractParameterService getContractParameterService() {
        if (this.contractParameterService == null) {
            this.contractParameterService = this.getContext().getPort(ContractParameterService.class);
        }
        return this.contractParameterService;
    }

    @Override
    public void setData() {
        try {
            ArrayList data = new ArrayList();
            JSONArray array = new JSONArray(this.getContractParameterService().contractParameterGroupJson());
            array.forEach(a -> data.add(new RowData((JSONObject)a)));
            this.groupTableModel.setData(data);
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }

    @Override
    public void deleteItem() {
        RowData rowData = (RowData)this.groupTableModel.getSelectedRow();
        if (rowData != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0433\u0440\u0443\u043f\u043f\u0443 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 2) == 0) {
            try {
                int id = rowData.getJson().optInt("id");
                this.getContractParameterService().contractParameterGroupDelete(id);
                this.getContractParameterService().contractParameterGroupUpdateLink(id, new HashSet<Integer>());
                this.setData();
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog(e);
            }
        }
    }

    @Override
    public void newItem() {
        new GroupParameterEditor("\u041d\u043e\u0432\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432", new RowData("{title: '\u041d\u043e\u0432\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430'}")).getDialog().setVisible(true);
    }

    @Override
    public void editItem() {
        RowData rowData = (RowData)this.groupTableModel.getSelectedRow();
        if (rowData != null) {
            new GroupParameterEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0433\u0440\u0443\u043f\u043f\u044b \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432", rowData).getDialog().setVisible(true);
        }
    }

    class GroupTableModel
    extends BGTableModel<RowData> {
        private static final String FIELD_ID = "id";
        private static final String FIELD_TITLE = "title";
        private static final String FIELD_PATTERNS = "patterns";
        private static final String FIELD_CONTRACTS = "contracts";

        public GroupTableModel() {
            super("contractParameterGroupEditorGroup");
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041a\u043e\u0434", 80, 80, 80, FIELD_ID, true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 150, -1, -1, FIELD_TITLE, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u041a\u043e\u043b-\u0432\u043e \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", 200, 200, 200, FIELD_PATTERNS, true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
            this.addColumn("\u041a\u043e\u043b-\u0432\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", 150, 150, 150, FIELD_CONTRACTS, true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
        }

        @Override
        public Object getValue(RowData rowData, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            JSONObject json = rowData.getJson();
            switch (identifier) {
                case "id": 
                case "patterns": 
                case "contracts": {
                    return json.optInt(identifier);
                }
                case "title": {
                    return json.optString(identifier);
                }
            }
            throw new IllegalArgumentException("Unexpected value: " + identifier);
        }
    }

    class GroupParameterEditor
    extends BGEditorDialog<RowData> {
        private BGTextField title;
        private BGUList<IdTitle> selected;
        private BGUList<IdTitle> available;
        private List<ContractParameterGroupAttr> list;
        private Set<Integer> selectedIds;

        public GroupParameterEditor(String title, RowData data) {
            super(title, data);
            this.title = new BGTextField();
            this.selected = new BGUList();
            this.available = new BGUList();
            this.list = null;
            this.selectedIds = new HashSet<Integer>();
        }

        @Override
        public void doDialogPanel() {
            int gridy = 0;
            this.panel.add((Component)this.getTitlePanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.getSelectPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            try {
                this.list = ContractParameterGroupEditor.this.getContractParameterService().contractParameterGroupAttrList();
                JSONObject json = ((RowData)this.data).getJson();
                this.title.setText(json.optString("title"));
                this.selectedIds = Utils.toIntegerSet(json.optString("parameterIds"));
                this.setLists();
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog(e);
            }
        }

        private void setLists() {
            this.selected.setData(this.list.stream().filter(a -> this.selectedIds.contains(a.getId())).map(a -> new IdTitle(a.getId(), a.getTitle())).toList());
            this.available.setData(this.list.stream().filter(a -> !this.selectedIds.contains(a.getId())).map(a -> new IdTitle(a.getId(), a.getTitle())).toList());
        }

        private JPanel getTitlePanel() {
            int gridx = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)this.title, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            return panel;
        }

        private JPanel getSelectPanel() {
            Dimension dimension = new Dimension(400, 300);
            JScrollPane selectedPane = new JScrollPane(this.selected);
            selectedPane.setMinimumSize(dimension);
            selectedPane.setPreferredSize(dimension);
            JScrollPane availablePane = new JScrollPane(this.available);
            availablePane.setMinimumSize(dimension);
            availablePane.setPreferredSize(dimension);
            int gridx = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b:"), new GridBagConstraints(gridx, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 5, 3, 5), 0, 0));
            panel.add((Component)selectedPane, new GridBagConstraints(gridx++, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)this.getButtonPanel(), new GridBagConstraints(gridx++, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)new JLabel("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b:"), new GridBagConstraints(gridx, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 5, 3, 5), 0, 0));
            panel.add((Component)availablePane, new GridBagConstraints(gridx++, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            return panel;
        }

        private JPanel getButtonPanel() {
            BGButton add = new BGButton("<<<");
            add.addActionListener(e -> {
                this.available.getSelectedValuesList().forEach(a -> this.selectedIds.add(a.getId()));
                this.setLists();
            });
            BGButton del = new BGButton(">>>");
            del.addActionListener(e -> {
                this.selected.getSelectedValuesList().forEach(a -> this.selectedIds.remove(a.getId()));
                this.setLists();
            });
            int gridy = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)add, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)del, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            panel.add(Box.createGlue(), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            return panel;
        }

        @Override
        public boolean doApply() throws Exception {
            if (Utils.isBlankString(this.title.getText())) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435.");
                return false;
            }
            try {
                ContractParameterGroup contractParameterGroup = new ContractParameterGroup();
                contractParameterGroup.setId(((RowData)this.data).getJson().optInt("id"));
                contractParameterGroup.setTitle(this.title.getText());
                contractParameterGroup.setId(ContractParameterGroupEditor.this.getContractParameterService().contractParameterGroupUpdate(contractParameterGroup));
                ContractParameterGroupEditor.this.getContractParameterService().contractParameterGroupUpdateLink(contractParameterGroup.getId(), this.selectedIds);
                ContractParameterGroupEditor.this.setData();
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog(e);
            }
            return true;
        }
    }
}

