/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import bitel.billing.module.common.BGBorderFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;

public class DirectoryEditor
extends BGTabPanel {
    public static final String TAB_ID = "directoryEditor";
    private final String rb_name = "bitel.billing.module.contract.directory.setup";
    private JPanel editorContainer = new JPanel(new GridBagLayout());
    private DefaultListModel<DirectoryListItem> listModel = new DefaultListModel();
    private JList<DirectoryListItem> directoryList = new JList<DirectoryListItem>(this.listModel);
    private BGSplitPaneNoBorder splitPanel = null;

    public DirectoryEditor() {
        super(TAB_ID, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u043e\u0432");
        this.module = "admin";
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        for (String key : ClientUtils.getValueFromResourceBundle("bitel.billing.module.contract.directory.setup", "directory.ids").split(";")) {
            String prefix = "directory." + key + ".";
            try {
                String title = ClientUtils.getValueFromResourceBundle("bitel.billing.module.contract.directory.setup", prefix.concat("title"));
                String className = ClientUtils.getValueFromResourceBundle("bitel.billing.module.contract.directory.setup", prefix.concat("class"));
                if (title == null || className == null) continue;
                this.listModel.addElement(new DirectoryListItem(className, title));
            }
            catch (Exception title) {
                // empty catch block
            }
        }
        for (BGPlugInElement extension : BGPluginManagerClient.getManager().getExtensions(DirectoryEditor.class.getCanonicalName(), true)) {
            Element extensionElement = extension.getElement();
            BGPluginClient plugin = (BGPluginClient)extension.getPlugin();
            NodeList list = extensionElement.getElementsByTagName("directory");
            for (int index = 0; index < list.getLength(); ++index) {
                Element directory = (Element)list.item(index);
                try {
                    String title = plugin.getResourceString(directory.getAttribute("title"));
                    String className = directory.getAttribute("class");
                    this.listModel.addElement(new DirectoryListItem(className, title));
                    continue;
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
        }
        this.showDir();
    }

    private void jbInit() throws Exception {
        this.directoryList.setBorder(BGBorderFactory.createEmptyBorder());
        this.directoryList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    DirectoryEditor.this.showDir();
                }
            }
        });
        JPanel jPanel1 = new JPanel(new GridBagLayout());
        jPanel1.setBorder(new BGTitleBorder(" \u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0438 "));
        jPanel1.add((Component)new JScrollPane(this.directoryList), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.splitPanel = new BGSplitPaneNoBorder(1, jPanel1, (Component)this.editorContainer, 300L);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.splitPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        DirectoryListItem listItem = this.directoryList.getSelectedValue();
        try {
            JPanel panel = listItem.getPanel();
            if (panel != null && panel.isVisible()) {
                if (panel instanceof BGPanel) {
                    ((BGPanel)panel).actionPerformed(event);
                } else if (panel instanceof BGUPanel) {
                    ((BGUPanel)panel).performAction(event.getActionCommand());
                }
            }
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void showDir() {
        DirectoryListItem listItem = this.directoryList.getSelectedValue();
        if (listItem != null) {
            try {
                JPanel panel = listItem.getPanel();
                if (panel != null) {
                    int divide = this.splitPanel.getDividerLocation();
                    this.editorContainer.setVisible(false);
                    this.editorContainer.removeAll();
                    this.editorContainer.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                    this.editorContainer.updateUI();
                    this.editorContainer.setVisible(true);
                    this.splitPanel.setDividerLocation(divide);
                    if (panel instanceof BGPanel) {
                        ((BGPanel)panel).setData();
                    } else if (panel instanceof BGUPanel) {
                        ((BGUPanel)panel).performAction("refresh");
                    }
                }
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    private class DirectoryListItem {
        private String className;
        private String title;
        private JPanel panel;

        public DirectoryListItem(String className, String title) {
            this.className = className;
            this.title = title;
        }

        public JPanel getPanel() throws BGException {
            if (this.panel == null) {
                try {
                    this.panel = (JPanel)Class.forName(this.className).newInstance();
                    if (this.panel instanceof BGPanel) {
                        ((BGPanel)this.panel).init(DirectoryEditor.this.module, DirectoryEditor.this.getModuleId());
                    }
                }
                catch (Exception ex) {
                    throw new BGException(ex);
                }
            }
            return this.panel;
        }

        public String toString() {
            return this.title;
        }
    }
}

