/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.BalanceBaseType;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ChargeType;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentTypeItem;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ChargeService;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.PaymentService;
import ru.bitel.common.client.treetable.BGTreeTableModel;

public class TreeTypesEditor
extends BGPanel {
    private int mode;
    private String nameEditor;
    private BooleanRenderer renderer = new BooleanRenderer();
    private List<Integer> cutIdList = new ArrayList<Integer>();
    private BGUTreeTable treeTable;
    private PaymentTypeModel model = new PaymentTypeModel();

    public TreeTypesEditor(String nameEditor, int mode) {
        this.nameEditor = nameEditor;
        this.mode = mode;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void jbInit() throws Exception {
        this.treeTable = new BGUTreeTable(this.model);
        this.treeTable.setRowSorter(null);
        this.treeTable.setSelectionMode(0);
        JPanel tablePanel = new JPanel(new GridBagLayout());
        tablePanel.setBorder(new BGTitleBorder(this.nameEditor));
        this.treeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TreeTypesEditor.this.editItem();
                }
            }
        });
        tablePanel.add((Component)new JScrollPane(this.treeTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)tablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.treeTable.getColumnModel().getColumn(0).setPreferredWidth(1000);
        this.treeTable.getColumnModel().getColumn(1).setMinWidth(40);
        this.treeTable.getColumnModel().getColumn(1).setPreferredWidth(40);
        JPopupMenu menu = new JPopupMenu();
        ActionListener actionListener = e -> {
            if ("cutItem".equals(e.getActionCommand())) {
                this.cutIdList.clear();
                this.model.getSelectedRows().forEach(item -> this.cutIdList.add(item.getId()));
            } else if ("insertItem".equals(e.getActionCommand())) {
                PaymentTypeItem node = (PaymentTypeItem)this.model.getSelectedRow();
                int upId = node != null ? node.getId() : 0;
                try {
                    if (this.mode == 0) {
                        this.getContext().getPort(PaymentService.class).paymentTypeMove(upId, this.cutIdList);
                    } else if (this.mode == 1 || this.mode == 16) {
                        this.getContext().getPort(ChargeService.class).chargeTypeMove(upId, this.cutIdList);
                    }
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
                this.cutIdList.clear();
                this.setData();
            }
        };
        JMenuItem cutItem = new JMenuItem("\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c");
        cutItem.setActionCommand("cutItem");
        cutItem.addActionListener(actionListener);
        JMenuItem insertItem = new JMenuItem("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c");
        insertItem.setActionCommand("insertItem");
        insertItem.addActionListener(actionListener);
        menu.add(cutItem);
        menu.add(insertItem);
        this.addPopupMenu(menu);
    }

    public final void addPopupMenu(final JPopupMenu menu) {
        this.treeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.evaluatePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.evaluatePopup(e);
            }

            private void evaluatePopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    menu.show(TreeTypesEditor.this.treeTable, e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    public void setData() {
        try {
            if (this.mode == 0) {
                this.model.setData(this.getContext().getPort(PaymentService.class).paymentTypeTree(-1, true));
            } else {
                this.model.setData(this.getContext().getPort(ChargeService.class).chargeTypeTree(-1, this.mode == 16, true));
            }
            this.treeTable.expand();
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "newItem": {
                PaymentTypeItem node = (PaymentTypeItem)this.model.getSelectedRow();
                if (node == null || 0 == node.getType()) {
                    ClientUtils.showErrorMessageDialog("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e");
                    return;
                }
                BalanceBaseType balanceBaseType = null;
                if (this.mode == 0) {
                    balanceBaseType = new PaymentType();
                } else if (this.mode == 1 || this.mode == 16) {
                    balanceBaseType = new ChargeType();
                }
                balanceBaseType.setId(-1);
                balanceBaseType.setParentId(node.getId());
                balanceBaseType.setTitle("");
                new TypeEditor("\u041d\u043e\u0432\u044b\u0439 \u0442\u0438\u043f", balanceBaseType).getDialog().setVisible(true);
                break;
            }
            case "editItem": {
                this.editItem();
                break;
            }
            case "deleteItem": {
                this.deleteItem();
                break;
            }
            case "refresh": {
                this.setData();
            }
        }
    }

    @Override
    public void deleteItem() {
        PaymentTypeItem node = (PaymentTypeItem)this.model.getSelectedRow();
        if (node == null || 0 == node.getId()) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
            return;
        }
        if (node.getChildren() != null && node.getChildren().size() > 0) {
            ClientUtils.showErrorMessageDialog("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e");
            return;
        }
        if (!ClientUtils.confirmDelete(node.getTitle())) {
            return;
        }
        try {
            if (this.mode == 0) {
                this.getContext().getDirectory(PaymentType.class).delete(node.getId());
            } else if (this.mode == 1 || this.mode == 16) {
                this.getContext().getDirectory(ChargeType.class).delete(node.getId());
            }
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.setData();
    }

    @Override
    public void editItem() {
        PaymentTypeItem node = (PaymentTypeItem)this.model.getSelectedRow();
        if (node == null || 0 == node.getId()) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
            return;
        }
        new TypeEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0438\u043f\u0430", node).getDialog().setVisible(true);
    }

    private class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private JPanel component = new JPanel();
        private JComponent curruntComponent;

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.curruntComponent = row == 0 ? this.component : this;
            this.curruntComponent.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            this.curruntComponent.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            this.curruntComponent.setBorder(hasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : this.noFocusBorder);
            this.setSelected(value != null && (Boolean)value != false);
            return this.curruntComponent;
        }
    }

    class PaymentTypeModel
    extends BGTreeTableModel<PaymentTypeItem> {
        public PaymentTypeModel() {
            super(PaymentTypeModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", PaymentTypeItem.class, 300, -1, -1, "title", true);
            this.addColumn("\u041a\u043e\u0434", 80, 80, 80, "id", true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
            this.addColumn("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0435\u043c\u044b\u0439", 150, 150, 150, "editable", true);
        }

        @Override
        public Object getValue(PaymentTypeItem val, int column) throws BGException {
            return column == 1 && val == this.root ? "" : super.getValue(val, column);
        }

        @Override
        public TableCellRenderer getTableCellRenderer(int columnIndex) {
            return columnIndex == 2 ? TreeTypesEditor.this.renderer : super.getTableCellRenderer(columnIndex);
        }

        @Override
        public boolean isLeaf(Object node) {
            return ((PaymentTypeItem)node).getType() == 0;
        }
    }

    class TypeEditor
    extends BGEditorDialog<BalanceBaseType> {
        private JTextField title;
        private JCheckBox editable;
        private ButtonGroup buttonGroup;
        private JRadioButton rbGroup;
        private JRadioButton rbGroupItem;

        public TypeEditor(String title, BalanceBaseType data) {
            super(title, data);
            this.title = new JTextField(40);
            this.editable = new JCheckBox("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0435\u043c\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442");
            this.buttonGroup = new ButtonGroup();
            this.rbGroup = new JRadioButton("\u0413\u0440\u0443\u043f\u043f\u0430");
            this.rbGroupItem = new JRadioButton("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u0433\u0440\u0443\u043f\u043f\u044b");
        }

        @Override
        public void doDialogPanel() {
            this.title.setMinimumSize(new Dimension(4, 24));
            this.title.setPreferredSize(new Dimension(4, 24));
            this.buttonGroup.add(this.rbGroup);
            this.buttonGroup.add(this.rbGroupItem);
            this.panel.add((Component)new JLabel("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 0, 0, 5), 0, 0));
            this.panel.add((Component)this.editable, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.rbGroup, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.rbGroupItem, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.title.setText(((BalanceBaseType)this.data).getTitle());
            this.editable.setSelected(((BalanceBaseType)this.data).getEditable());
            this.rbGroupItem.setEnabled(((BalanceBaseType)this.data).getType() != 1 || ((PaymentTypeItem)this.data).getChildren() == null || ((PaymentTypeItem)this.data).getChildren().isEmpty());
            this.buttonGroup.setSelected(((BalanceBaseType)this.data).getType() == 1 ? this.rbGroup.getModel() : this.rbGroupItem.getModel(), true);
        }

        @Override
        public boolean doApply() throws Exception {
            if (this.title.getText().trim().length() == 0) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435");
                return false;
            }
            if (TreeTypesEditor.this.mode == 0) {
                TreeTypesEditor.this.getContext().getDirectory(PaymentType.class).update(new PaymentType(((BalanceBaseType)this.data).getId(), this.title.getText().trim(), this.rbGroup.isSelected() ? 1 : 0, this.editable.isSelected(), ((BalanceBaseType)this.data).getParentId()));
            } else if (TreeTypesEditor.this.mode == 1 || TreeTypesEditor.this.mode == 16) {
                TreeTypesEditor.this.getContext().getDirectory(ChargeType.class).update(new ChargeType(((BalanceBaseType)this.data).getId(), this.title.getText().trim(), this.rbGroup.isSelected() ? 1 : 0, this.editable.isSelected(), ((BalanceBaseType)this.data).getParentId(), TreeTypesEditor.this.mode == 16));
            }
            TreeTypesEditor.this.setData();
            return super.doApply();
        }
    }
}

