/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.hierarchy;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelContractSelect;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.ListItem;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.common.Utils;

public class HierarchyPanel
extends BGPanel {
    private static final Font font = new Font("Arial", 1, 16);
    private int superId;
    private JList<ListItem> subList = new JList();
    private JLabel superLabel = new JLabel();
    private JLabel labelDepend = new JLabel();
    private CardLayout cardLayout = new CardLayout();
    private BGControlPanelContractSelect contractSelectFreeMode = new BGControlPanelContractSelect(false);
    private BGControlPanelContractSelect contractSelectSuperMode = new BGControlPanelContractSelect(false);
    private BGComboBox<ComboBoxItem> subModeFreeMode = new BGComboBox();
    private BGComboBox<ComboBoxItem> subModeSuperMode = new BGComboBox();

    public HierarchyPanel() {
        this.jbInit();
    }

    private void jbInit() {
        this.superLabel.setHorizontalAlignment(0);
        JButton setSuperButton = new JButton("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440");
        JButton addSubButton = new JButton("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u044b");
        JPanel freePanel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c");
        label.setFont(font);
        freePanel.add((Component)label, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        freePanel.add((Component)this.contractSelectFreeMode, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        freePanel.add(this.subModeFreeMode, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        freePanel.add((Component)setSuperButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        freePanel.add((Component)addSubButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        freePanel.add(Box.createVerticalStrut(2), new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 10, 3, new Insets(5, 5, 5, 5), 0, 0));
        JButton openSub = new JButton("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440");
        JButton freeSub = new JButton("\u041e\u0441\u0432\u043e\u0431\u043e\u0434\u0438\u0442\u044c \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440");
        JButton addSub = new JButton("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440");
        JPanel superPanel = new JPanel(new GridBagLayout());
        label = new JLabel("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u043c \u0434\u043b\u044f");
        label.setFont(font);
        this.subList.setVisibleRowCount(4);
        superPanel.add((Component)label, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        superPanel.add((Component)new JScrollPane(this.subList), new GridBagConstraints(0, 1, 2, 3, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
        superPanel.add((Component)openSub, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        superPanel.add((Component)freeSub, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        superPanel.add(Box.createVerticalStrut(2), new GridBagConstraints(1, 3, 2, 1, 0.0, 1.0, 10, 3, new Insets(5, 5, 0, 5), 0, 0));
        superPanel.add((Component)this.contractSelectSuperMode, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        superPanel.add(this.subModeSuperMode, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        superPanel.add((Component)addSub, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        JPanel subPanel = new JPanel(new GridBagLayout());
        JButton openButton = new JButton("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440");
        JButton freeButton = new JButton("\u041e\u0441\u0432\u043e\u0431\u043e\u0434\u0438\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
        this.labelDepend.setHorizontalAlignment(0);
        this.labelDepend.setFont(font);
        this.superLabel.setFont(font);
        subPanel.add((Component)this.labelDepend, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        subPanel.add((Component)this.superLabel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        subPanel.add((Component)openButton, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 10, 2, new Insets(15, 5, 0, 5), 0, 0));
        subPanel.add((Component)freeButton, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 10, 2, new Insets(15, 5, 0, 5), 0, 0));
        subPanel.add(Box.createVerticalStrut(2), new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 3, new Insets(0, 5, 0, 5), 0, 0));
        this.setLayout(this.cardLayout);
        this.add((Component)subPanel, "sub");
        this.add((Component)freePanel, "free");
        this.add((Component)superPanel, "super");
        this.subModeFreeMode.addItem(new ComboBoxItem(0, "\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0439 \u0431\u0430\u043b\u0430\u043d\u0441"));
        this.subModeFreeMode.addItem(new ComboBoxItem(1, "\u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0439 \u0431\u0430\u043b\u0430\u043d\u0441"));
        this.subModeSuperMode.addItem(new ComboBoxItem(0, "\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0439 \u0431\u0430\u043b\u0430\u043d\u0441"));
        this.subModeSuperMode.addItem(new ComboBoxItem(1, "\u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0439 \u0431\u0430\u043b\u0430\u043d\u0441"));
        addSubButton.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u0443\u0431\u043e\u0433\u043e\u0432\u043e\u0440\u0430?", "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", 0) == 0) {
                this.addSub(this.contractSelectFreeMode, this.subModeFreeMode);
            }
        });
        this.subList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    HierarchyPanel.this.openSub();
                }
            }
        });
        openSub.addActionListener(e -> this.openSub());
        openButton.addActionListener(e -> this.openContract(this.superId));
        setSuperButton.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440?", "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", 0) == 0) {
                this.setSuper(this.subModeFreeMode);
            }
        });
        freeButton.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u041e\u0441\u0432\u043e\u0431\u043e\u0434\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u0434\u043e\u0433\u043e\u0432\u043e\u0440?", "\u041e\u0441\u0432\u043e\u0431\u043e\u0436\u0434\u0435\u043d\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", 0) == 0) {
                this.freeThis();
            }
        });
        addSub.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430?", "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", 0) == 0) {
                this.addSub(this.contractSelectSuperMode, this.subModeSuperMode);
            }
        });
        freeSub.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u041e\u0441\u0432\u043e\u0431\u043e\u0434\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430?", "\u041e\u0441\u0432\u043e\u0431\u043e\u0436\u0434\u0435\u043d\u0438\u0435 \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", 0) == 0) {
                this.freeSub();
            }
        });
    }

    @Override
    public void setData() {
        try {
            List<Contract> list = this.getContext().getPort(ContractService.class).contractSubList(this.getContractId(), -1, true);
            Contract contract = list.get(0);
            String status = "free";
            if (contract.isSuper()) {
                status = "super";
                DefaultListModel<ListItem> model = new DefaultListModel<ListItem>();
                for (Contract sub : list) {
                    if (sub == contract) continue;
                    ListItem li = new ListItem((sub.getBalanceSubMode() == 0 ? "[\u0417] " : "[\u041d] ") + sub.getTitle() + " [" + sub.getComment() + "]", false);
                    li.setAttribute("id", sub.getId());
                    model.addElement(li);
                }
                this.subList.setModel(model);
            } else if (contract.isSub()) {
                status = "sub";
                this.superId = contract.getSuperCid();
                Contract superContract = this.getContext().getPort(ContractService.class).contractGet(contract.getSuperCid());
                this.superLabel.setText((String)(superContract != null ? superContract.getTitle() + " [" + superContract.getComment() + "]" : ""));
                byte mode = contract.getBalanceSubMode();
                Object modeStr = "???";
                if (mode == 0 || mode == 1) {
                    modeStr = "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u043c \u0441 " + (mode == 0 ? "\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u043c" : "\u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u043c") + " \u0431\u0430\u043b\u0430\u043d\u0441\u043e\u043c \u0434\u043b\u044f";
                }
                this.labelDepend.setText((String)modeStr);
            }
            this.cardLayout.show(this, status);
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    @Override
    public void init(String module, int mid) {
        super.init(module, mid);
        this.contractSelectFreeMode.init(module, mid);
        this.contractSelectFreeMode.setIgnoredCid(this.getContractId());
        this.contractSelectSuperMode.init(module, mid);
        this.contractSelectSuperMode.setIgnoredCid(this.getContractId());
    }

    private void setSuper(BGComboBox<ComboBoxItem> subMode) {
        String superId = this.contractSelectFreeMode.getContracts();
        if (Utils.isBlankString(superId) || superId.indexOf(",") >= 0) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0434\u0438\u043d \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440!");
            return;
        }
        Request request = new Request();
        request.setModule("contract.hierarchy");
        request.setAction("AddSub");
        request.setAttribute("super", superId);
        request.setAttribute("sub", this.getContractId());
        request.setAttribute("sub_mode", ClientUtils.getIdFromComboBox(subMode));
        if (ClientUtils.checkStatus(this.getDocument(request))) {
            this.setData();
            EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
        }
    }

    private void addSub(BGControlPanelContractSelect contractSelect, BGComboBox<ComboBoxItem> subMode) {
        String subIdList = contractSelect.getContracts();
        if (Utils.isBlankString(subIdList)) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u044b!");
            return;
        }
        boolean wasAdd = false;
        StringTokenizer st = new StringTokenizer(subIdList, ",");
        while (st.hasMoreTokens()) {
            Request req = new Request();
            req.setModule("contract.hierarchy");
            req.setAction("AddSub");
            req.setAttribute("super", this.getContractId());
            req.setAttribute("sub", st.nextToken().trim());
            req.setAttribute("sub_mode", ClientUtils.getIdFromComboBox(subMode));
            if (!ClientUtils.checkStatus(this.getDocument(req))) continue;
            wasAdd = true;
            EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
        }
        if (wasAdd) {
            this.setData();
        }
    }

    private void freeThis() {
        Request req = new Request();
        req.setModule("contract.hierarchy");
        req.setAction("FreeContract");
        req.setContractId(this.getContractId());
        if (ClientUtils.checkStatus(this.getDocument(req))) {
            this.setData();
            EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
        }
    }

    private void freeSub() {
        int id;
        ListItem li = this.subList.getSelectedValue();
        int n = id = li != null ? (Integer)li.getAttribute("id") : -1;
        if (id > 0) {
            Request req = new Request();
            req.setModule("contract.hierarchy");
            req.setAction("FreeContract");
            req.setContractId(id);
            if (ClientUtils.checkStatus(this.getDocument(req))) {
                this.setData();
                EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
            }
        }
    }

    private void openSub() {
        ListItem li = this.subList.getSelectedValue();
        if (li == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440!");
            return;
        }
        this.openContract((Integer)li.getAttribute("id"));
    }
}

