/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.object;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.contract.object.ObjectEditor;
import bitel.billing.module.contract.object.TypeSelectPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectType;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectService;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ObjectTypeService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.ListItem;
import ru.bitel.common.model.SearchResult;

public class ContractObjectEditor
extends BGPanel
implements ActionListener {
    private static final String module = "contract.object";
    private BGTextField filterTitle;
    private BGComboBox<ListItem> filterType;
    private BGControlPanelPages pages;
    private JLabel records;
    private CardLayout cardLayout;
    private ObjectEditor objectEditor;
    private TypeSelectPanel typeSelect;
    private final ContractObjectTableModel objectTableModel = new ContractObjectTableModel(ContractObjectTableModel.class.getName());
    private List<ObjectType> types;
    private ContractObjectService contractObjectService;
    private ObjectTypeService objectTypeService;
    private BGUTable table;
    final JPopupMenu popupMenu = new JPopupMenu();

    public void build() {
        this.cardLayout = new CardLayout();
        this.objectEditor = new ObjectEditor();
        this.typeSelect = new TypeSelectPanel();
        this.jbInit();
        this.cardLayout.show(this, "editor");
    }

    private void jbInit() {
        this.filterTitle = new BGTextField(20);
        this.filterType = new BGComboBox();
        this.pages = new BGControlPanelPages();
        this.pages.init();
        this.records = new JLabel();
        this.table = new BGUTable(this.objectTableModel);
        this.table.setSelectionMode(0);
        this.addListenersToComponets();
        this.initTransferContractPopup(this.popupMenu, this.table, "MoveObject", "id", "oid");
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons(this);
        toolBar.setToolBar(new String[]{"newItem", "copyItem", "deleteItem", "separator", "upItem", "downItem"});
        toolBar.setFloatable(false);
        toolBar.setOrientation(1);
        toolBar.compact();
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)this.filterTitle, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)new JLabel("\u0422\u0438\u043f: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
        filterPanel.add(this.filterType, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)this.records, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 20), 0, 0));
        filterPanel.add((Component)this.pages, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel tablePanel = new JPanel(new GridBagLayout());
        tablePanel.setBorder(new BGTitleBorder(" \u041e\u0431\u044a\u0435\u043a\u0442\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 "));
        tablePanel.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 10, 3, new Insets(30, 0, 0, 5), 0, 0));
        tablePanel.add((Component)filterPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        tablePanel.add((Component)new JScrollPane(this.table), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.setLayout(this.cardLayout);
        this.add((Component)new BGSplitPaneNoBorder(0, tablePanel, (Component)this.objectEditor, 300L), "editor");
        this.add((Component)this.typeSelect, "type_select");
    }

    private void addListenersToComponets() {
        this.filterTitle.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                String title = ContractObjectEditor.this.filterTitle.getText();
                if (title != null && title.length() >= 3) {
                    ContractObjectEditor.this.pages.setPageIndex(1);
                    ContractObjectEditor.this.setData();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                String title = ContractObjectEditor.this.filterTitle.getText();
                if (title == null || title.length() == 0) {
                    ContractObjectEditor.this.pages.setPageIndex(1);
                    ContractObjectEditor.this.setData();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.filterTitle.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    ContractObjectEditor.this.pages.setPageIndex(1);
                    ContractObjectEditor.this.setData();
                }
            }
        });
        this.filterType.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                this.pages.setPageIndex(1);
                this.setData();
            }
        });
        this.pages.addPropertyChangeListener(event -> {
            if (event.getPropertyName().startsWith("to")) {
                this.setData();
            }
        });
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting() && this.objectTableModel.getSelectedRow() != null) {
                this.id = String.valueOf(((ContractObject)((Object)((Object)this.objectTableModel.getSelectedRow()))).getId());
                this.openObject();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ContractObjectEditor.this.table.getSelectedRow() == ContractObjectEditor.this.table.rowAtPoint(e.getPoint()) && SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 1) {
                    ContractObjectEditor.this.popupMenu.show(ContractObjectEditor.this.table, e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("upItem".equals(actionCommand)) {
            this.orderItem(true);
        } else if ("downItem".equals(actionCommand)) {
            this.orderItem(false);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public void setData() {
        try {
            int typeId = -1;
            if (this.filterType.getItemCount() == 0) {
                DefaultComboBoxModel<IdTitle> model = new DefaultComboBoxModel<IdTitle>();
                model.addElement(new IdTitle(-1, "\u041b\u044e\u0431\u043e\u0439"));
                this.types = this.getObjectTypeService().objectTypeList(false);
                for (ObjectType objectType : this.types) {
                    model.addElement(new IdTitle(objectType.getId(), objectType.getTitle()));
                }
                this.filterType.setModel(model);
            } else {
                typeId = this.filterType.getSelectedItem().getId();
            }
            SearchResult<ContractObject> searchResult = this.getContractObjectService().contractObjectTable(this.getContractId(), this.filterTitle.getText(), typeId, this.pages.getPage());
            this.objectTableModel.setData(searchResult.getList(), true);
            this.pages.setPage(searchResult.getPage());
            this.records.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + (searchResult != null ? searchResult.getPage().getRecordCount() : 0));
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    @Override
    public void deleteItem() {
        this.getObjectId();
        if (this.id != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            try {
                this.getContractObjectService().contractObjectDelete(this.getContractId(), Integer.parseInt(this.id));
                EventBus.publish((Object)new UpdateContractTreeEvent(0, this.getContractId()));
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog(e);
            }
            this.setData();
            this.id = null;
            this.objectEditor.setId(null);
            this.objectEditor.setData();
        }
    }

    @Override
    public void copyItem() {
        this.getObjectId();
        if (this.id != null) {
            int dialogResult = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043d\u0430 \u043d\u043e\u0432\u044b\u0439 \u043e\u0431\u044a\u0435\u043a\u0442?", "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430", 0, 3);
            boolean clonePeriod = dialogResult == 0;
            try {
                this.getContractObjectService().contractObjectClone(this.getContractId(), Integer.parseInt(this.id), clonePeriod);
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog(e);
            }
            this.setData();
        }
    }

    @Override
    public void editItem() {
        this.getObjectId();
        if (this.id != null) {
            this.openObject();
        }
    }

    @Override
    public void newItem() {
        this.typeSelect.setData();
        this.cardLayout.show(this, "type_select");
    }

    public void orderItem(boolean up) {
        try {
            this.getObjectId();
            if (this.id != null) {
                this.getContractObjectService().contractObjectOrder(this.getContractId(), Integer.parseInt(this.id), up);
            }
            this.setData();
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }

    private void getObjectId() {
        this.id = String.valueOf(((ContractObject)((Object)this.objectTableModel.getSelectedRow())).getId());
        if (this.id == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0431\u044a\u0435\u043a\u0442!");
        }
    }

    @Override
    public void init(String module, int mid) {
        super.init(module, mid);
        this.objectEditor.init(module, mid);
        this.objectEditor.setContractObjectEditor(this);
        this.typeSelect.init(module, mid);
        this.typeSelect.setContractObjectEditor(this);
    }

    @Override
    public void setContractId(int id) {
        super.setContractId(id);
        this.objectEditor.setContractId(id);
    }

    private void openObject() {
        if (this.id != null) {
            this.objectEditor.setId(this.id);
            this.objectEditor.setData();
            this.cardLayout.show(this, "editor");
        }
    }

    public void selectedTypeForNewObject(String type) {
        try {
            ContractObject contractObject = new ContractObject();
            contractObject.setTypeId(Integer.parseInt(type));
            contractObject.setContractId(this.getContractId());
            int newId = this.getContractObjectService().contractObjectUpdate(this.getContractId(), contractObject);
            contractObject.setId(newId);
            this.id = String.valueOf(newId);
            this.setData();
            EventBus.publish((Object)new UpdateContractTreeEvent(0, this.getContractId()));
            this.openObject();
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }

    public void typeSelectCanceled() {
        this.cardLayout.show(this, "editor");
    }

    public ContractObjectTableModel getObjectTableModel() {
        return this.objectTableModel;
    }

    private ContractObjectService getContractObjectService() {
        if (this.contractObjectService == null) {
            this.contractObjectService = this.getContext().getPort(ContractObjectService.class, 0);
        }
        return this.contractObjectService;
    }

    private ObjectTypeService getObjectTypeService() {
        if (this.objectTypeService == null) {
            this.objectTypeService = this.getContext().getPort(ObjectTypeService.class, 0);
        }
        return this.objectTypeService;
    }

    class ContractObjectTableModel
    extends BGTableModel<ContractObject> {
        public ContractObjectTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 180, 180, 180, "period", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0422\u0438\u043f", 150, 180, 200, "typeId", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, -1, -1, "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValueAt(ContractObject contractObject, int column) throws BGException {
            switch (column) {
                case 1: {
                    StringBuilder sb = new StringBuilder();
                    if (contractObject.getDateFrom() != null) {
                        sb.append(TimeUtils.formatDate(contractObject.getDateFrom()));
                        if (contractObject.getDateTo() != null) {
                            sb.append(" - ").append(TimeUtils.formatDate(contractObject.getDateTo()));
                        } else {
                            sb.append(" - ...");
                        }
                    }
                    return sb.toString();
                }
                case 2: {
                    if (Utils.isEmptyCollection(ContractObjectEditor.this.types)) {
                        ContractObjectEditor.this.types = ContractObjectEditor.this.getObjectTypeService().objectTypeList(false);
                    }
                    return ContractObjectEditor.this.types.stream().filter(t -> t.getId() == contractObject.getTypeId()).findAny().map(IdTitle::getTitle).orElse("<\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d>");
                }
            }
            return super.getValueAt(contractObject, column);
        }

        @Override
        public void setSelectedRows(List<ContractObject> selected) {
            ListSelectionModel selectionModel = this.table.getSelectionModel();
            selectionModel.clearSelection();
            if (Utils.notEmptyCollection(selected)) {
                selectionModel.setValueIsAdjusting(true);
                Set set = selected.stream().mapToInt(Id::getId).boxed().collect(Collectors.toSet());
                int size = this.getRowCount();
                for (int i = 0; i < size; ++i) {
                    if (!set.contains(((ContractObject)((Object)this.getRows().get(i))).getId())) continue;
                    if (this.table.getRowSorter() != null) {
                        int row = this.table.getRowSorter().convertRowIndexToView(i);
                        selectionModel.addSelectionInterval(row, row);
                        continue;
                    }
                    selectionModel.addSelectionInterval(i, i);
                }
                selectionModel.setValueIsAdjusting(false);
            }
        }
    }
}

