/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.object;

import bitel.billing.module.common.ListItem;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.AbstractBGUPanel;

public class DirectoryEditor
extends BGTabPanel {
    public static final String TAB_ID = "objectDirectoryEditor";
    private CardLayout cardLayout = new CardLayout();
    private JPanel directoryPanel = new JPanel();
    private JList<ListItem> directoryList = new JList();

    public DirectoryEditor() {
        super(TAB_ID, "\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432");
        this.module = "contract.object";
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.directoryList.setModel(new DefaultListModel());
        int i = 0;
        while (true) {
            String prefix = "directory." + i + ".";
            try {
                String title = ClientUtils.getValueFromResourceBundle(this.rb_name, prefix.concat("title"));
                String className = ClientUtils.getValueFromResourceBundle(this.rb_name, prefix.concat("class"));
                Object directoryClass = Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.directoryPanel.add(String.valueOf(i), (Component)directoryClass);
                if (directoryClass instanceof BGPanel) {
                    panel = (BGPanel)directoryClass;
                    ((BGPanel)panel).init(this.module, this.getModuleId());
                    if (i == 0) {
                        ((BGPanel)panel).setData();
                    }
                } else if (directoryClass instanceof BGUPanel) {
                    panel = (BGUPanel)directoryClass;
                    if (i == 0) {
                        ((AbstractBGUPanel)panel).performAction("refresh");
                    }
                }
                ((DefaultListModel)this.directoryList.getModel()).addElement(new ListItem(title));
            }
            catch (Exception ex) {
                break;
            }
            ++i;
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new BGTitleBorder(" \u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0438 "));
        jPanel.add((Component)new JScrollPane(this.directoryList), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.directoryPanel.setLayout(this.cardLayout);
        this.directoryList.addListSelectionListener(e -> this.listValueChanged(e));
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, jPanel, (Component)this.directoryPanel, 300L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Component panel = null;
        for (int i = 0; i < this.directoryPanel.getComponentCount(); ++i) {
            panel = this.directoryPanel.getComponent(i);
            if (!panel.isVisible()) continue;
            if (panel instanceof BGPanel) {
                ((BGPanel)panel).actionPerformed(e);
                break;
            }
            if (!(panel instanceof BGUPanel)) continue;
            String actionCommand = e.getActionCommand();
            if ("newItem".equals(actionCommand)) {
                ((BGUPanel)panel).performAction("new");
                break;
            }
            if ("editItem".equals(actionCommand)) {
                ((BGUPanel)panel).performAction("edit");
                break;
            }
            if ("deleteItem".equals(actionCommand)) {
                ((BGUPanel)panel).performAction("delete");
                break;
            }
            if (!"refresh".equals(actionCommand)) break;
            ((BGUPanel)panel).performAction("refresh");
            break;
        }
    }

    private void listValueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting() || this.directoryList.isSelectionEmpty()) {
            return;
        }
        int index = this.directoryList.getSelectedIndex();
        Component panel = this.directoryPanel.getComponent(index);
        if (panel instanceof BGPanel) {
            ((BGPanel)panel).setData();
        } else if (panel instanceof BGUPanel) {
            ((BGUPanel)panel).performAction("refresh");
        }
        this.cardLayout.show(this.directoryPanel, String.valueOf(index));
    }
}

