/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.object;

import bitel.billing.module.common.ListItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ListValue;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ParameterObjectTypeService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class ListValueDirectory
extends BGPanel
implements ActionListener {
    private DefaultListModel<ListItem> paramModel = new DefaultListModel();
    private DefaultListModel<ListItem> valuesModel = new DefaultListModel();
    private JList<ListItem> paramList = new JList<ListItem>(this.paramModel);
    private JList<ListItem> valuesList = new JList<ListItem>(this.valuesModel);
    private BGTextField valueTitle_TF = new BGTextField();
    private JPanel editor = new JPanel(new GridBagLayout());
    private ParameterObjectTypeService parameterObjectTypeService;

    public ListValueDirectory() {
        this.jbInit();
        this.editor.setVisible(false);
        ClientUtils.addShowCodeListener(this.valuesList);
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        JSplitPane mainSplit = new JSplitPane();
        mainSplit.setOrientation(0);
        mainSplit.setDividerSize(4);
        mainSplit.setDividerLocation(500);
        JPanel paramViewer = new JPanel(new GridBagLayout());
        this.add((Component)mainSplit, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        mainSplit.setTopComponent(new JScrollPane(this.paramList));
        mainSplit.setBottomComponent(paramViewer);
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons(this);
        toolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem"});
        toolBar.setFloatable(false);
        toolBar.setOrientation(1);
        paramViewer.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        paramViewer.add((Component)new JScrollPane(this.valuesList), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramViewer.add((Component)this.editor, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.editor.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.editor.add((Component)this.valueTitle_TF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 10), 0, 0));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        this.editor.add((Component)okCancel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        okCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListValueDirectory.this.stopValueEdit(e.getActionCommand().equals("ok"));
            }
        });
        this.paramList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ListValueDirectory.this.showValues();
            }
        });
        this.valuesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ListValueDirectory.this.actionPerformed(new ActionEvent(this, 0, "editItem"));
                }
            }
        });
    }

    @Override
    public void setData() {
        try {
            ClientUtils.buildList(this.paramList, this.getParameterObjectTypeService().getListParameters());
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void showValues() {
        int selectedParameterId = Utils.parseInt(ClientUtils.getIdFromList(this.paramList), -1);
        if (selectedParameterId > 0) {
            try {
                ClientUtils.buildList(this.valuesList, this.getParameterObjectTypeService().getValuesForListParameter(selectedParameterId));
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
        this.editor.setVisible(false);
    }

    private void startValueEdit() {
        this.editor.setVisible(true);
    }

    private void stopValueEdit(boolean save) {
        if (save) {
            String paramId = ClientUtils.getIdFromList(this.paramList);
            String title = this.valueTitle_TF.getText();
            if (paramId == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440!");
                return;
            }
            if (Utils.isBlankString(title)) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!");
                return;
            }
            try {
                ListValue value = new ListValue();
                value.setId(Integer.parseInt(this.id));
                value.setParamId(Integer.parseInt(paramId));
                value.setTitle(title);
                this.getParameterObjectTypeService().updateListParameterValue(value);
                this.editor.setVisible(false);
                this.showValues();
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        } else {
            this.editor.setVisible(false);
        }
    }

    private void deleteValue() {
        int valueId = Utils.parseInt(ClientUtils.getIdFromList(this.valuesList), -1);
        if (valueId > 0 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            try {
                this.getParameterObjectTypeService().deleteListParameterValue(valueId);
                this.showValues();
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command != null) {
            if (command.equals("newItem")) {
                this.id = "0";
                this.valueTitle_TF.setText("");
                this.startValueEdit();
            }
            if (command.equals("editItem")) {
                ListItem li = this.valuesList.getSelectedValue();
                if (li == null) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!");
                    return;
                }
                this.id = (String)li.getAttribute("id");
                this.valueTitle_TF.setText(li.getText());
                this.startValueEdit();
            } else if (command.equals("deleteItem")) {
                this.deleteValue();
            }
        }
    }

    private ParameterObjectTypeService getParameterObjectTypeService() {
        if (this.parameterObjectTypeService == null) {
            this.parameterObjectTypeService = this.getContext().getPort(ParameterObjectTypeService.class, 0);
        }
        return this.parameterObjectTypeService;
    }
}

