/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.object;

import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.table.BGTableModel;

public class ObjectModuleEditor
extends BGPanel {
    private BGDialogToolBar propertyToolBar = new BGDialogToolBar();
    private BGDialogToolBar moduleToolBar = new BGDialogToolBar();
    private JTabbedPane tabPanel = new JTabbedPane();
    private ObjectModuleTableModel tableModel = new ObjectModuleTableModel();
    private BGUTable table = new BGUTable(this.tableModel);
    private boolean ignoreStateChange = false;

    public ObjectModuleEditor() {
        this.jbInit();
    }

    private void jbInit() {
        this.tabPanel.addTab("\u0421\u0432\u043e\u0434\u043d\u0430\u044f", new JScrollPane(this.table));
        this.propertyToolBar.setOrientation(1);
        this.propertyToolBar.setMargin(new Insets(5, 5, 0, 5));
        this.propertyToolBar.setBorderPainted(false);
        this.propertyToolBar.setFloatable(false);
        this.moduleToolBar.setOrientation(1);
        this.moduleToolBar.setMargin(new Insets(5, 5, 0, 5));
        this.moduleToolBar.setBorderPainted(false);
        this.moduleToolBar.setFloatable(false);
        this.tabPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ObjectModuleEditor.this.ignoreStateChange) {
                    return;
                }
                Component selectedComponent = ObjectModuleEditor.this.tabPanel.getSelectedComponent();
                if (selectedComponent instanceof JScrollPane) {
                    ObjectModuleEditor.this.setData();
                } else {
                    ((ServicePanel)selectedComponent).initModuleToollBar(ObjectModuleEditor.this.moduleToolBar);
                    ((ServicePanel)selectedComponent).setData();
                }
            }
        });
        this.buildPropertyToolBar();
        JPanel tollBarPanel = new JPanel(new GridBagLayout());
        tollBarPanel.add((Component)this.propertyToolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        tollBarPanel.add((Component)this.moduleToolBar, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)tollBarPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tabPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void buildPropertyToolBar() {
        PropertyToolBarActionListener actionListener = new PropertyToolBarActionListener();
        this.propertyToolBar.setDefaultButtons(actionListener);
        this.propertyToolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem", "separator", "refresh"});
        this.moduleToolBar.setActionListener(actionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData() {
        if (this.id == null || this.id.equals("0")) {
            return;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ObjectModuleTable");
        request.setAttribute("object_id", this.id);
        for (int i = this.tabPanel.getTabCount() - 1; i > 0; --i) {
            this.ignoreStateChange = true;
            this.tabPanel.removeTabAt(i);
            this.ignoreStateChange = false;
        }
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            ArrayList list = new ArrayList();
            XMLUtils.selectElements(doc, "//table/data/row").forEach(e -> list.add(e));
            this.tableModel.setData(list);
            Element modulesEl = XMLUtils.selectElement(doc, "//modules");
            NodeList moduleList = modulesEl.getElementsByTagName("module");
            int size = moduleList.getLength();
            for (int i = 0; i < size; ++i) {
                Element moduleEl = (Element)moduleList.item(i);
                int moduleId = Utils.parseInt(moduleEl.getAttribute("id"));
                String clientPack = moduleEl.getAttribute("pack_client");
                String moduleTitle = moduleEl.getAttribute("title");
                try {
                    Class<?> clazz = Class.forName(clientPack + ".ServicePropertiesPanel");
                    String rb_name = clazz.getPackage().getName() + ".setup";
                    String module = ClientUtils.getValueFromResourceBundle(rb_name, "module.id", this.module);
                    ClientContext context = new ClientContext(module, moduleId, this.getContractId(), Utils.parseInt(this.id), rb_name);
                    ClientContext.push(context);
                    try {
                        ServicePanel servicePanel = (ServicePanel)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                        servicePanel.setContext(context);
                        servicePanel.init(this.getContractId(), moduleId, Utils.parseInt(this.id));
                        this.ignoreStateChange = true;
                        this.tabPanel.addTab(moduleTitle, servicePanel);
                        this.ignoreStateChange = false;
                        continue;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        continue;
                    }
                    finally {
                        ClientContext.pop();
                    }
                }
                catch (ClassNotFoundException e3) {
                    ClientUtils.showErrorMessageDialog("\u041a\u043b\u0430\u0441\u0441 " + clientPack + ".ServicePropertiesPanel \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
                }
            }
        }
        this.tabPanel.setSelectedIndex(0);
    }

    class ObjectModuleTableModel
    extends BGTableModel<Element> {
        public ObjectModuleTableModel() {
            super(ObjectModuleTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041c\u043e\u0434\u0443\u043b\u044c", 150, 150, 150, "module", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0443\u0449\u043d\u043e\u0441\u0442\u044c", 150, 200, 250, "data", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 150, 180, 200, "period", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 100, 150, -1, "comment", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class PropertyToolBarActionListener
    implements ActionListener {
        PropertyToolBarActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component selectedComponent = ObjectModuleEditor.this.tabPanel.getSelectedComponent();
            if (selectedComponent instanceof ServicePanel) {
                ((ServicePanel)selectedComponent).actionPerformed(e);
            }
        }
    }
}

