/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.object;

import bitel.billing.module.common.CalendarDialog;
import bitel.billing.module.contract.object.ContractObjectEditor;
import bitel.billing.module.contract.object.table.ContractObjectAddressEditor;
import bitel.billing.module.contract.object.table.ObjectParameterTableRow;
import bitel.billing.module.contract.object.table.TableObjectParameters;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParameterHistoryEntry;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectService;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamAddressEditorDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamEditorData;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamListEditorDialog;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.common.bean.EntityType;

public class ObjectParamEditor
extends BGPanel {
    private TableObjectParameters tableObjectParameters = new TableObjectParameters();
    private ContractObjectAddressEditor addressEditor = new ContractObjectAddressEditor();
    private ContractObjectEditor contractObjectEditor;
    private BGTextField title_TF = new BGTextField();
    private BGControlPanelPeriodNoB period = new BGControlPanelPeriodNoB();
    private BGUTable historyTable = null;
    private ObjectParamHistoryTableModel historyTableModel = new ObjectParamHistoryTableModel();
    private CardLayout tableLayout = new CardLayout();
    private JPanel tablePanel = null;
    private int selectedPid = -1;
    private int selectedPt = -1;
    private Directory<UserInfo> userDirectory;

    public ObjectParamEditor() {
        this.historyTable = new BGUTable(this.historyTableModel);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tableObjectParameters.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ObjectParamEditor.this.tableObject_mouseClicked(e);
            }
        });
        this.tableObjectParameters.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "doEnterEditing");
        this.tableObjectParameters.getActionMap().put("doEnterEditing", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectParamEditor.this.tableObject_enterPressed();
            }
        });
        ((DefaultTableModel)this.tableObjectParameters.getModel()).addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ObjectParameterTableRow row;
                int parameterType;
                if (ObjectParamEditor.this.fl && ObjectParamEditor.this.tableObjectParameters.getRowCount() > 0 && ((parameterType = (row = (ObjectParameterTableRow)ObjectParamEditor.this.tableObjectParameters.getValueAt(e.getFirstRow(), 0)).getParameterType()) == 1 || parameterType == 5)) {
                    int pid = row.getParameterId();
                    int objectId = Utils.parseInt(ObjectParamEditor.this.id, -1);
                    try {
                        if (parameterType == 1) {
                            EntityAttrText attrText = new EntityAttrText(objectId, pid, (String)ObjectParamEditor.this.tableObjectParameters.getValueAt(e.getFirstRow(), 1));
                            ObjectParamEditor.this.getContext().getPort(ContractObjectService.class).textParameterValueUpdate(ObjectParamEditor.this.getContractId(), attrText);
                        } else if (parameterType == 5) {
                            EntityAttrBoolean attrBoolean = new EntityAttrBoolean(objectId, pid, ((Boolean)ObjectParamEditor.this.tableObjectParameters.getValueAt(e.getFirstRow(), 1)).booleanValue());
                            ObjectParamEditor.this.getContext().getPort(ContractObjectService.class).flagParameterValueUpdate(ObjectParamEditor.this.getContractId(), attrBoolean);
                        }
                        ObjectParamEditor.this.refreshPanels();
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }
            }
        });
    }

    private void jbInit() throws Exception {
        this.userDirectory = this.getContext().getDirectory(UserInfo.class, 0);
        JButton updateButton = new JButton("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c");
        updateButton.addActionListener(e -> this.updateObject());
        JPanel namePanel = new JPanel(new GridBagLayout());
        namePanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        namePanel.add((Component)this.period, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        namePanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 0, 0));
        namePanel.add((Component)this.title_TF, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        namePanel.add((Component)updateButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 5), 0, 0));
        JPanel historyPanel = new JPanel(new GridBagLayout());
        JButton deleteHistory = new JButton("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0438\u0441\u0442\u043e\u0440\u0438\u044e");
        deleteHistory.addActionListener(e -> this.clearContractHistory());
        JButton returnButton = new JButton(" \u041a \u0441\u043f\u0438\u0441\u043a\u0443 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 ");
        returnButton.addActionListener(e -> this.tableLayout.show(this.tablePanel, "param"));
        historyPanel.add((Component)new JScrollPane(this.historyTable), new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        historyPanel.add((Component)deleteHistory, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 15, 5, 0), 0, 0));
        historyPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        historyPanel.add((Component)returnButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 15), 0, 0));
        JPanel paramPanel = new JPanel(new GridBagLayout());
        paramPanel.setLayout(new GridBagLayout());
        paramPanel.add((Component)namePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        paramPanel.add((Component)new JScrollPane(this.tableObjectParameters), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tablePanel = new JPanel(this.tableLayout);
        this.tablePanel.add((Component)paramPanel, "param");
        this.tablePanel.add((Component)historyPanel, "history");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.tablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void setData() {
        ContractObject contractObject = null;
        try {
            if (this.id != null && (contractObject = this.getContext().getPort(ContractObjectService.class, 0).contractObjectGetById(this.getContractId(), Integer.parseInt(this.id))) != null) {
                this.period.setDateString1(TimeUtils.formatDate(contractObject.getDateFrom()));
                this.period.setDateString2(TimeUtils.formatDate(contractObject.getDateTo()));
                this.title_TF.setText(contractObject.getTitle());
                this.loadObjectParams();
            }
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }

    public void loadObjectParams() {
        this.fl = false;
        try {
            this.tableObjectParameters.setRowsData(this.getContext().getWebService(ContractObjectService.class, 0).contractObjectParameters(this.getContractId(), Utils.parseInt(this.id)));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.fl = true;
    }

    private void tableObject_enterPressed() {
        int row = this.tableObjectParameters.getSelectedRow();
        if (row > -1) {
            this.openEditor(row);
        }
    }

    private void tableObject_mouseClicked(MouseEvent e) {
        if ((e.getModifiers() & 0x10) == 0) {
            return;
        }
        int row = this.tableObjectParameters.getSelectedRow();
        if (e.getClickCount() == 2 && row > -1) {
            this.openEditor(row);
        } else if (e.getClickCount() == 1 && row > -1) {
            ObjectParameterTableRow tr = (ObjectParameterTableRow)this.tableObjectParameters.getValueAt(row, 0);
            int col = this.tableObjectParameters.getSelectedColumn();
            if (col == 2) {
                this.tableLayout.show(this.tablePanel, "history");
                this.renewHistoryTable(tr.getParameterId(), tr.getParameterType());
            }
        }
    }

    private void openEditor(int row) {
        ObjectParameterTableRow tableRow = (ObjectParameterTableRow)this.tableObjectParameters.getValueAt(row, 0);
        int parameterType = tableRow.getParameterType();
        int parameterId = tableRow.getParameterId();
        ContractParamEditorData data = new ContractParamEditorData();
        data.setEntityType(EntityType.OBJECT_PARAMETER);
        data.setClientContext(this.getContext());
        data.setContractId(this.getContractId());
        data.setObjectId(Utils.parseInt(this.id));
        data.setParameterId(parameterId);
        data.setParameterTitle(tableRow.getTitle());
        if (parameterType != -1) {
            if (parameterType == 4) {
                new ContractParamAddressEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0442\u0438\u043f\u0430 \"\u0410\u0434\u0440\u0435\u0441\"", data).getDialog().setVisible(true);
                this.refreshPanels();
                this.addressEditor.setId(String.valueOf(parameterId));
                this.addressEditor.setObjectId(this.id);
                this.addressEditor.setData();
            } else if (parameterType == 3) {
                String dateStr = (String)tableRow.getValue();
                SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
                GregorianCalendar dt = new GregorianCalendar();
                try {
                    dt.setTime(format.parse(dateStr));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CalendarDialog calendar = new CalendarDialog();
                calendar.setCalendar(dt);
                calendar.setModal(true);
                if (calendar.showDialog().equals("ok")) {
                    try {
                        EntityAttrDate attrDate = new EntityAttrDate(Utils.parseInt(this.id, -1), parameterId, calendar.getCalendar() != null ? calendar.getCalendar().getTime() : null);
                        this.getContext().getPort(ContractObjectService.class).dateParameterValueUpdate(this.getContractId(), attrDate);
                        this.refreshPanels();
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }
            } else if (parameterType == 2) {
                new ContractParamListEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0442\u0438\u043f\u0430 \"\u0421\u043f\u0438\u0441\u043e\u043a\"", data).getDialog().setVisible(true);
                this.refreshPanels();
            } else if (parameterType == 1) {
                this.tableObjectParameters.editCellAt(row, 1);
            } else if (parameterType == 5) {
                this.tableObjectParameters.setValueAt((Boolean)this.tableObjectParameters.getValueAt(row, 1) != false ? Boolean.FALSE : Boolean.TRUE, row, 1);
            }
        }
    }

    @Override
    public void init(String module, int mid) {
        super.init(module, mid);
        this.addressEditor.init(this.module, mid);
    }

    public void setContractObjectEditor(ContractObjectEditor contractObjectEditor) {
        this.contractObjectEditor = contractObjectEditor;
    }

    private void updateObject() {
        try {
            ContractObject contractObject = (ContractObject)((Object)this.contractObjectEditor.getObjectTableModel().getSelectedRow());
            contractObject.setTitle(this.title_TF.getText());
            contractObject.setDateFrom(this.period.getDateFrom());
            contractObject.setDateTo(this.period.getDateTo());
            this.getContext().getPort(ContractObjectService.class, 0).contractObjectUpdate(this.getContractId(), contractObject);
            this.refreshPanels();
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }

    private void refreshPanels() {
        this.setData();
        this.contractObjectEditor.setData();
    }

    private void renewHistoryTable(int parameterId, int parameterType) {
        try {
            this.historyTableModel.setData(this.getContext().getPort(ContractObjectService.class).getParameterHistory(this.getContractId(), Utils.parseInt(this.id, -1), parameterId, parameterType));
            this.selectedPid = parameterId;
            this.selectedPt = parameterType;
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    protected void clearContractHistory() {
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0438\u0441\u0442\u043e\u0440\u0438\u044e \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 2) == 0) {
            try {
                this.getContext().getPort(ContractObjectService.class).clearParameterHistory(this.getContractId(), Utils.parseInt(this.id, -1), this.selectedPid, this.selectedPt);
                this.renewHistoryTable(this.selectedPid, this.selectedPt);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    class ObjectParamHistoryTableModel
    extends BGTableModel<ParameterHistoryEntry> {
        public ObjectParamHistoryTableModel() {
            super(ObjectParamEditor.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u0414\u0430\u0442\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f", 100, 150, 200, "date", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 10, 500, -1, "value", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u041a\u0442\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u043b", 100, 150, 200, "user", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
        }

        @Override
        public Object getValue(ParameterHistoryEntry val, int column) throws BGException {
            switch (column) {
                case 0: {
                    return TimeUtils.formatFullDate(val.getDate());
                }
                case 1: {
                    if (ObjectParamEditor.this.selectedPt == 3) {
                        return val.getValue() == null ? "[\u0423\u0414\u0410\u041b\u0415\u041d\u041e]" : val.getValue();
                    }
                    if (ObjectParamEditor.this.selectedPt == 5) {
                        return "1".equals(val.getValue()) ? "\u0412\u043a\u043b\u044e\u0447\u0435\u043d\u043e" : "\u041e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043e";
                    }
                    return val.getValue();
                }
                case 2: {
                    UserInfo user = ObjectParamEditor.this.userDirectory.get(Utils.parseInt(val.getUser(), -2));
                    return user != null ? user.getName() : "\u041d\u0435 \u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e";
                }
            }
            return super.getValue(val, column);
        }
    }
}

