/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.object;

import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.BGTextArea;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectType;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ObjectTypeService;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class ObjectTypeDirectory
extends BGPanel {
    private ObjectTypeTableModel objectTypeTableModel = new ObjectTypeTableModel();
    private ObjectTypeService objectTypeService;

    public ObjectTypeDirectory() {
        this.jbInit();
    }

    private void jbInit() {
        BGUTable table = new BGUTable(this.objectTypeTableModel);
        table.setSelectionMode(0);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ObjectTypeDirectory.this.editItem();
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    @Override
    public void setData() {
        try {
            this.objectTypeTableModel.setData(this.getObjectTypeService().objectTypeList(false));
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    @Override
    public void deleteItem() {
        ObjectType objectType = (ObjectType)this.objectTypeTableModel.getSelectedRow();
        if (objectType != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0438\u043f?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            try {
                this.getObjectTypeService().typeDelete(objectType.getId());
                objectType = null;
                this.setData();
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog(e);
            }
        }
    }

    @Override
    public void editItem() {
        ObjectType objectType = (ObjectType)this.objectTypeTableModel.getSelectedRow();
        if (objectType != null) {
            new ObjectTypeEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0438\u043f\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430", objectType).getDialog().setVisible(true);
        }
    }

    @Override
    public void newItem() {
        new ObjectTypeEditor("\u041d\u043e\u0432\u044b\u0439 \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430", new ObjectType()).getDialog().setVisible(true);
    }

    private ObjectTypeService getObjectTypeService() {
        if (this.objectTypeService == null) {
            this.objectTypeService = this.getContext().getPort(ObjectTypeService.class, 0);
        }
        return this.objectTypeService;
    }

    class ObjectTypeTableModel
    extends BGTableModel<ObjectType> {
        public ObjectTypeTableModel() {
            super(ObjectTypeTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 300, 500, "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041c\u0430\u043a\u0440\u043e\u0441", 100, 500, 800, "nameMakros", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u043a\u0440\u044b\u0442\u044b\u0439", 80, 80, 80, "hidden", true);
        }
    }

    class ObjectTypeEditor
    extends BGEditorDialog<ObjectType> {
        private BGTextField titleField;
        private BGTextField macrosField;
        private BGTextArea commentTextArea;
        private JCheckBox hiddenCheckBox;
        private BGControlPanelListSelect modules;

        public ObjectTypeEditor(String title, ObjectType data) {
            super(title, data);
            this.titleField = new BGTextField(40);
            this.macrosField = new BGTextField(40);
            this.commentTextArea = new BGTextArea(4, 40);
            this.hiddenCheckBox = new JCheckBox("\u0421\u043a\u0440\u044b\u0442");
            this.modules = new BGControlPanelListSelect();
        }

        @Override
        public void doDialogPanel() {
            this.panel.setLayout(new GridLayout(1, 2, 10, 0));
            this.panel.add(this.getLeftPanel());
            this.panel.add(this.getRightPanel());
            try {
                List<BGModule> moduleList = ObjectTypeDirectory.this.getContext().getPort(ModuleService.class, 0).moduleList();
                ClientUtils.buildList(this.modules.getList(), moduleList);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            this.titleField.setText(((ObjectType)this.data).getTitle());
            this.macrosField.setText(((ObjectType)this.data).getNameMakros());
            this.commentTextArea.setText(((ObjectType)this.data).getComment());
            this.hiddenCheckBox.setSelected(((ObjectType)this.data).isHidden());
            this.modules.setListValues(Utils.toString(((ObjectType)this.data).getModuleList()));
        }

        private JPanel getLeftPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.titleField, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041c\u0430\u043a\u0440\u043e\u0441: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.macrosField, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)BGSwingUtilites.wrapScrollPane(this.commentTextArea, 400, 80), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.hiddenCheckBox, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getRightPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041c\u043e\u0434\u0443\u043b\u0438: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.modules, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
            return panel;
        }

        @Override
        public boolean doApply() throws Exception {
            String title = this.titleField.getText();
            if (Utils.isBlankString(title)) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435!");
                return false;
            }
            ((ObjectType)this.data).setTitle(title);
            ((ObjectType)this.data).setNameMakros(this.macrosField.getText());
            ((ObjectType)this.data).setComment(this.commentTextArea.getText());
            ((ObjectType)this.data).setHidden(this.hiddenCheckBox.isSelected());
            ((ObjectType)this.data).setModuleList(this.modules.getListIds());
            try {
                ObjectTypeDirectory.this.getObjectTypeService().typeUpdate((ObjectType)this.data);
                ObjectTypeDirectory.this.setData();
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            return super.doApply();
        }
    }
}

