/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.object;

import bitel.billing.module.common.ListItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectTypeParameter;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ObjectTypeService;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ParameterObjectTypeService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class ObjectTypeParamDirectory
extends BGPanel
implements ActionListener {
    private DefaultListModel<ListItem> typeModel = new DefaultListModel();
    private JList<ListItem> typeList = new JList<ListItem>(this.typeModel);
    private BGUComboBox<IdTitle> paramSelectComboBox = new BGUComboBox();
    private JPanel editor = new JPanel(new GridBagLayout());
    private ObjectTypeParamTableModel tableModel = new ObjectTypeParamTableModel(ObjectTypeParamTableModel.class.getName());
    private ParameterObjectTypeService parameterObjectTypeService;

    public ObjectTypeParamDirectory() {
        this.jbInit();
        this.editor.setVisible(false);
    }

    private void jbInit() {
        BGUTable paramTable = new BGUTable(this.tableModel);
        paramTable.setSelectionMode(0);
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons(this);
        toolBar.setToolBar(new String[]{"newItem", "deleteItem", "separator", "upItem", "downItem"});
        toolBar.setFloatable(false);
        toolBar.setOrientation(1);
        JPanel paramViewer = new JPanel(new GridBagLayout());
        paramViewer.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        paramViewer.add((Component)new JScrollPane(paramTable), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramViewer.add((Component)this.editor, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        BGSplitPaneNoBorder mainSplit = new BGSplitPaneNoBorder(0, new JScrollPane(this.typeList), (Component)paramViewer, 500L);
        this.editor.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.editor.add(this.paramSelectComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 10), 0, 0));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> this.stopParamAdd(e.getActionCommand().equals("ok")));
        this.editor.add((Component)okCancel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.typeList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.showParams();
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)mainSplit, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    @Override
    public void setData() {
        try {
            ClientUtils.buildList(this.typeList, this.getContext().getPort(ObjectTypeService.class, 0).objectTypeList(false));
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }

    private void showParams() {
        int objectTypeId = Utils.parseInt(ClientUtils.getIdFromList(this.typeList), -1);
        if (objectTypeId > 0) {
            try {
                this.tableModel.setData(this.getParameterObjectTypeService().objectTypeParameterList(objectTypeId));
                this.editor.setVisible(false);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    private void startParamAdd() {
        int typeId = Utils.parseInt(ClientUtils.getIdFromList(this.typeList), -1);
        if (typeId > 0) {
            try {
                ArrayList<IdTitle> avaliableTypes = new ArrayList<IdTitle>();
                avaliableTypes.add(new IdTitle(-1, "---"));
                avaliableTypes.addAll(this.getParameterObjectTypeService().getAvaliableTypeForObjectType(typeId));
                this.paramSelectComboBox.setData(avaliableTypes);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            this.editor.setVisible(true);
        }
    }

    private void stopParamAdd(boolean add) {
        if (add) {
            int objectTypeId = Utils.parseInt(ClientUtils.getIdFromList(this.typeList), -1);
            int selectedParameterId = ((IdTitle)this.paramSelectComboBox.getSelectedItem()).getId();
            if (selectedParameterId <= 0) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440!");
                return;
            }
            try {
                this.getParameterObjectTypeService().updateLinkParameterWithObjectType(objectTypeId, selectedParameterId, true);
                this.editor.setVisible(false);
                this.showParams();
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        } else {
            this.editor.setVisible(false);
        }
    }

    private void deleteParam() {
        int objectTypeId = Utils.parseInt(ClientUtils.getIdFromList(this.typeList), -1);
        ObjectTypeParameter objectTypeParameter = (ObjectTypeParameter)this.tableModel.getSelectedRow();
        if (objectTypeId > 0 && objectTypeParameter != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0443 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u043a \u0442\u0438\u043f\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            try {
                this.getParameterObjectTypeService().updateLinkParameterWithObjectType(objectTypeId, objectTypeParameter.getParameterId(), false);
                this.showParams();
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    private void move(boolean up) {
        int typeId = Utils.parseInt(ClientUtils.getIdFromList(this.typeList), -1);
        ObjectTypeParameter objectTypeParameter = (ObjectTypeParameter)this.tableModel.getSelectedRow();
        if (typeId > 0 && objectTypeParameter != null) {
            try {
                this.getParameterObjectTypeService().parameterMoving(typeId, objectTypeParameter.getParameterId(), up);
                this.showParams();
                List rows = this.tableModel.getRows();
                for (int i = rows.size() - 1; i >= 0; --i) {
                    if (objectTypeParameter.getParameterId() != ((ObjectTypeParameter)rows.get(i)).getParameterId()) continue;
                    this.tableModel.setSelectedRow((ObjectTypeParameter)rows.get(i));
                    break;
                }
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String command = actionEvent.getActionCommand();
        if (command != null) {
            if (command.equals("newItem")) {
                this.startParamAdd();
            } else if (command.equals("deleteItem")) {
                this.deleteParam();
            } else if (command.equals("upItem")) {
                this.move(true);
            } else if (command.equals("downItem")) {
                this.move(false);
            }
        }
    }

    private ParameterObjectTypeService getParameterObjectTypeService() {
        if (this.parameterObjectTypeService == null) {
            this.parameterObjectTypeService = this.getContext().getPort(ParameterObjectTypeService.class, 0);
        }
        return this.parameterObjectTypeService;
    }

    class ObjectTypeParamTableModel
    extends BGTableModel<ObjectTypeParameter> {
        public ObjectTypeParamTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("ID", 80, 80, 80, "parameterId", true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0422\u0438\u043f", 150, 150, 150, "parameterTypeTitle", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", -1, -1, -1, "parameterTitle", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }
}

