/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.object;

import bitel.billing.module.common.ListItem;
import bitel.billing.module.contract.object.ContractObjectEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ObjectTypeService;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class TypeSelectPanel
extends BGPanel {
    private JCheckBox showHiddenCB = new JCheckBox("\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0441\u043a\u0440\u044b\u0442\u044b\u0435");
    private JList<ListItem> typeList = new JList();
    private ContractObjectEditor contractObjectEditor;

    public TypeSelectPanel() {
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new BGTitleBorder(" \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0431\u044a\u0435\u043a\u0442 "));
        this.showHiddenCB.setSelected(false);
        this.add((Component)this.showHiddenCB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JScrollPane(this.typeList), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        this.add((Component)okCancel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        okCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("ok")) {
                    TypeSelectPanel.this.okPressed();
                } else {
                    TypeSelectPanel.this.cancelPressed();
                }
            }
        });
        this.typeList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TypeSelectPanel.this.okPressed();
                }
            }
        });
        this.showHiddenCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypeSelectPanel.this.init = false;
                TypeSelectPanel.this.setData();
            }
        });
    }

    @Override
    public void setData() {
        if (!this.init) {
            this.init = true;
            try {
                ClientUtils.buildList(this.typeList, this.getContext().getPort(ObjectTypeService.class).objectTypeList(!this.showHiddenCB.isSelected()));
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    public void setContractObjectEditor(ContractObjectEditor contractObjectEditor) {
        this.contractObjectEditor = contractObjectEditor;
    }

    private void okPressed() {
        String type = ClientUtils.getIdFromList(this.typeList);
        if (type == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f!");
            return;
        }
        this.contractObjectEditor.selectedTypeForNewObject(type);
    }

    private void cancelPressed() {
        this.contractObjectEditor.typeSelectCanceled();
    }
}

