/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.status;

import bitel.billing.module.contract.ContractEditor;
import bitel.billing.module.contract.ContractSubPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.PeriodTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.status.client.ClientStatusUtil;
import ru.bitel.bgbilling.kernel.contract.status.client.StatusControlPanel;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatusLog;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class ContractSubPanel_Status
extends ContractSubPanel {
    private List<Status> statusList = new ArrayList<Status>();
    private List<Status> statusOnlyManualList = new ArrayList<Status>();
    private BGControlPanelPages pages = new BGControlPanelPages();
    private StatusTableModel statusTableModel = new StatusTableModel();
    private StatusLogTableModel statusLogTableModel = new StatusLogTableModel();
    private StatusControlPanel statusControl = new StatusControlPanel();

    public ContractSubPanel_Status() {
        this.jbInit();
    }

    private void jbInit() {
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(0, new JScrollPane(new BGUTable(this.statusTableModel)), (Component)this.getStatusLogPanel(), 300L);
        this.statusControl.addActionListener(e -> this.changeStatus());
        this.setLayout(new GridBagLayout());
        this.add((Component)this.statusControl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)splitPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getStatusLogPanel() {
        this.pages.addPropertyChangeListener(a -> {
            if (a.getPropertyName().startsWith("to")) {
                this.loadStatusLogData();
            }
        });
        BGPanel panel = new BGPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)this.pages, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)new JScrollPane(new BGUTable(this.statusLogTableModel)), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        BGSwingUtilites.wrapBorder(panel, "\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432");
        return panel;
    }

    @Override
    public void init(ContractEditor editor) {
        super.init(editor);
    }

    @Override
    public void setData() {
        this.pages.setPageIndex(1);
        try {
            this.statusOnlyManualList = this.getContext().getWebService(ContractStatusService.class, 0).getStatusList(true);
            this.statusList = this.getContext().getWebService(ContractStatusService.class, 0).getStatusList(false);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.statusControl.setStatusList(this.statusOnlyManualList);
        Async.of(() -> {
            try {
                SearchResult<ContractStatus> searchResult = this.getContext().getWebService(ContractStatusService.class, 0).contractStatusSearch(this.getContractId(), new Page(1, 20));
                this.statusTableModel.setData(searchResult.getList());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        });
        this.loadStatusLogData();
    }

    private void loadStatusLogData() {
        Async.of(() -> {
            try {
                SearchResult<ContractStatusLog> searchResult = this.getContext().getWebService(ContractStatusService.class, 0).contractStatusLogSearch(this.getContractId(), this.pages.getPage());
                this.statusLogTableModel.setData(searchResult.getList());
                this.pages.setPage(searchResult.getPage());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        });
    }

    private void changeStatus() {
        if (this.statusControl.getDateFrom() == null) {
            ClientUtils.showErrorMessageDialog("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430");
            return;
        }
        int[] cids = new int[]{this.getContractId()};
        ClientStatusUtil.changeStatusOnServer(this, this.getContext(), cids, this.statusControl.getStatusId(), this.statusControl.getDateFrom(), this.statusControl.getDateTo(), this.statusControl.getComment());
        this.setData();
        EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
    }

    class StatusTableModel
    extends BGTableModel<ContractStatus> {
        public StatusTableModel() {
            super(StatusTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 100, 200, 200, "period", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 100, 200, 300, "status", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
        }

        @Override
        public Object getValueAt(ContractStatus val, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("status".equals(identifier)) {
                return ContractSubPanel_Status.this.statusList.stream().filter(a -> a.getId() == val.getStatus()).map(a -> a.getGuiTitle()).findFirst().orElse("#" + val.getStatus());
            }
            if ("period".equals(identifier)) {
                return new Period(val.getDateFrom(), val.getDateTo());
            }
            return super.getValueAt(val, column);
        }
    }

    class StatusLogTableModel
    extends BGTableModel<ContractStatusLog> {
        private Directory<UserInfo> directory;

        public StatusLogTableModel() {
            super(StatusLogTableModel.class.getName());
            this.directory = null;
            try {
                this.directory = ContractSubPanel_Status.this.getContext().getDirectory(UserInfo.class);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 100, 200, 200, "period", false).setTableCellRenderer(PeriodTableCellRenderer.DEFAULT);
            this.addColumn("\u0414\u0430\u0442\u0430", 200, 200, 200, "date", false).setTableCellRenderer(DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 100, 200, 300, "status", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 100, 200, 300, "userId", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
        }

        @Override
        public Object getValueAt(ContractStatusLog val, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("userId".equals(identifier)) {
                UserInfo userInfo = this.directory.get(val.getUserId());
                return userInfo != null ? userInfo.getGuiTitle() : "??? [ID#" + val.getUserId() + "]";
            }
            if ("status".equals(identifier)) {
                return ContractSubPanel_Status.this.statusList.stream().filter(a -> a.getId() == val.getStatus()).map(a -> a.getGuiTitle()).findFirst().orElse("#" + val.getStatus());
            }
            if ("period".equals(identifier)) {
                return new Period(val.getDate1(), val.getDate2());
            }
            return super.getValue(val, column);
        }
    }
}

