/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ru.bitel.bgbilling.client.common.AbstractActionTabbedConfig;
import ru.bitel.bgbilling.client.common.BGDraggableTabbedPane;
import ru.bitel.bgbilling.client.common.BGSplitPane;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.ClosedTabs;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.GroupParent;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.IdTitle;

public class BGServiceConfig
extends BGUTabPanel
implements GroupParent {
    private JComponent tabPane;
    private CardLayout layout;
    private boolean tabbed;
    private BGUList<IdTitle> list;
    private List<IdTitle> listData;
    private ClientContext ctx;
    private String prefix;
    private Object closeObject;
    private Set<Component> settedComponents = new HashSet<Component>();

    @Override
    public ClientContext getContext() {
        return this.ctx;
    }

    public void initPanel(String prefix, ClientContext ctx, String tabId, boolean tabbed) {
        this.prefix = prefix;
        this.ctx = ctx;
        this.tabbed = tabbed;
        this.setTabId(tabId);
        if (tabbed) {
            this.list = null;
            this.listData = null;
            this.layout = null;
            this.tabPane = new BGDraggableTabbedPane();
        } else {
            this.list = new BGUList();
            this.list.setSelectionMode(0);
            this.listData = new ArrayList<IdTitle>();
            this.layout = new CardLayout();
            this.tabPane = new JPanel(this.layout);
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        ResourceBundle rb = ResourceBundle.getBundle(this.getContext().getResourceBundleName());
        try {
            if (this.getTabTitle() == null) {
                this.setTabTitle(rb.getString("module.title"));
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        int i = 1;
        String moduleTab = null;
        try {
            moduleTab = rb.getString(prefix + ".tab");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (moduleTab != null) {
            ArrayList<String> tabsList = new ArrayList<String>();
            for (String tabIndex : moduleTab.split(" ")) {
                tabsList.add(tabIndex);
            }
            String userTabOrder = ClientSetup.getInstance().getUserConfig().get(((BGDraggableTabbedPane)this.tabPane).getKey());
            if (userTabOrder != null) {
                ArrayList<String> list = new ArrayList<String>();
                for (String tabIndex : userTabOrder.split(" ")) {
                    if (!tabsList.contains(tabIndex)) continue;
                    list.add(tabIndex);
                    tabsList.remove(tabIndex);
                }
                list.addAll(tabsList);
                tabsList = list;
            }
            Iterator iterator = tabsList.iterator();
            while (iterator.hasNext()) {
                String tabIndex;
                if (!this.addTab(prefix, i == 1, rb, tabIndex = (String)iterator.next())) continue;
                ++i;
            }
        } else {
            while (this.addTab(prefix, i == 1, rb, String.valueOf(i))) {
                ++i;
            }
        }
        if (this.list != null) {
            this.list.setData(this.listData);
            if (this.listData.size() > 0) {
                this.list.setSelectedIndex(0);
            }
            this.list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    BGServiceConfig.this.layout.show(BGServiceConfig.this.tabPane, ((IdTitle)BGServiceConfig.this.list.getSelectedValue()).getTitle());
                    BGServiceConfig.this.jTabbedPane_stateChanged(BGServiceConfig.this.getSelected());
                }
            });
        }
        if (this.tabPane instanceof BGDraggableTabbedPane) {
            ((JTabbedPane)this.tabPane).addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Component component = ((JTabbedPane)BGServiceConfig.this.tabPane).getSelectedComponent();
                    BGServiceConfig.this.jTabbedPane_stateChanged(component);
                }
            });
        }
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (e.getID() == 1400 && e.getChangeFlags() == 4L && e.getChanged().isVisible()) {
                    BGServiceConfig.this.shownNotify();
                }
            }
        });
    }

    @Override
    public boolean performAction(String action) {
        if (this.tabbed) {
            ServiceConfigPane serviceConfigPane = (ServiceConfigPane)((JTabbedPane)this.tabPane).getSelectedComponent();
            JPanel current = serviceConfigPane.get();
            if (current instanceof BGUPanel) {
                boolean result = ((BGUPanel)current).performAction(action);
                if ("refresh".equals(action)) {
                    this.settedComponents.add(serviceConfigPane);
                }
                return result;
            }
            ((ServiceConfigTabbedPanel)current).actionPerformed(new ActionEvent("", 0, action));
            return true;
        }
        int size = this.tabPane.getComponentCount();
        for (int i = 0; i < size; ++i) {
            Component current = this.tabPane.getComponent(i);
            if (!current.isVisible()) continue;
            if ((current = ((ServiceConfigPane)current).get()) instanceof BGUPanel) {
                return ((BGUPanel)current).performAction(action);
            }
            ((ServiceConfigTabbedPanel)current).actionPerformed(new ActionEvent("", 0, action));
            return true;
        }
        return super.performAction(action);
    }

    @Override
    protected void shownNotify() {
        Component c = this.getSelected();
        if (c != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(c);
        }
    }

    private boolean addTab(String prefix, boolean run, ResourceBundle rb, String tabIndex) {
        boolean flag = true;
        prefix = (String)prefix + ".tab." + tabIndex + ".";
        try {
            String title = rb.getString(((String)prefix).concat("title"));
            String className = rb.getString(((String)prefix).concat("class"));
            ServiceConfigPane pane = new ServiceConfigPane(tabIndex, className, run);
            this.tabPane.add((Component)pane, title);
            if (run) {
                pane.get();
            }
            if (this.listData != null) {
                this.listData.add(new IdTitle(0, title));
            }
        }
        catch (MissingResourceException ex) {
            flag = false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            flag = false;
        }
        return flag;
    }

    @Override
    protected void jbInit() {
        if (this.tabbed) {
            this.setLayout(new BorderLayout());
            this.add((Component)this.tabPane, "Center");
            ((BGDraggableTabbedPane)this.tabPane).setKey("BGDraggableTabbedPane:" + this.getContext().getModule() + ":" + this.getContext().getModuleId() + ":" + BGServiceConfig.class.getName());
        } else {
            BGSplitPane splitPane = new BGSplitPane();
            this.setLayout(new BorderLayout());
            this.add((Component)splitPane, "Center");
            splitPane.setLeftComponent(BGSwingUtilites.wrapEmptyBorder(new JScrollPane(this.list)));
            splitPane.setRightComponent(this.tabPane);
            ActionMap actionMap = this.getActionMap();
            actionMap.put("tab.current.switch.next", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int idx = BGServiceConfig.this.list.getSelectedIndex();
                    if (++idx >= BGServiceConfig.this.list.getModel().getSize()) {
                        idx = 0;
                    }
                    if (idx < BGServiceConfig.this.list.getModel().getSize()) {
                        BGServiceConfig.this.list.setSelectedIndex(idx);
                    }
                }
            });
            actionMap.put("tab.current.switch.prev", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int idx = BGServiceConfig.this.list.getSelectedIndex();
                    if (--idx < 0) {
                        idx = BGServiceConfig.this.list.getModel().getSize() - 1;
                    }
                    if (idx < BGServiceConfig.this.list.getModel().getSize()) {
                        BGServiceConfig.this.list.setSelectedIndex(idx);
                    }
                }
            });
            InputMap inputMap = this.getInputMap(1);
            inputMap.put(KeyStroke.getKeyStroke(93, 512), "tab.current.switch.next");
            inputMap.put(KeyStroke.getKeyStroke(91, 512), "tab.current.switch.prev");
        }
    }

    public void setData() {
        Component component = this.getSelected();
        JPanel panel = ((ServiceConfigPane)component).get();
        if (panel instanceof ServiceConfigTabbedPanel) {
            ((ServiceConfigTabbedPanel)panel).setData();
        } else if (panel instanceof BGUPanel) {
            BGUPanel bguPanel = (BGUPanel)panel;
            bguPanel.addAfterJbInitTask(() -> {
                Action a = panel.getActionMap().get("refresh");
                if (a != null) {
                    a.actionPerformed(new ActionEvent(this, 0, "refresh"));
                } else if (panel instanceof AbstractBGUPanel) {
                    ((AbstractBGUPanel)panel).performAction("refresh");
                }
            });
        }
    }

    private Component getSelected() {
        if (this.tabPane != null) {
            if (this.tabPane instanceof JTabbedPane) {
                return ((JTabbedPane)this.tabPane).getSelectedComponent();
            }
            int size = this.tabPane.getComponentCount();
            for (int i = 0; i < size; ++i) {
                Component c = this.tabPane.getComponent(i);
                if (!c.isVisible()) continue;
                return c;
            }
        }
        return null;
    }

    private void jTabbedPane_stateChanged(Component component) {
        if (this.isVisible() && !this.settedComponents.contains(component)) {
            this.setData();
            this.settedComponents.add(component);
        }
    }

    public BGUPanel getTab(Class<?> clazz) {
        BGUPanel result = null;
        if (this.tabPane instanceof JTabbedPane) {
            JTabbedPane tabPane = (JTabbedPane)this.tabPane;
            int tabCount = tabPane.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                Component comp = tabPane.getComponentAt(i);
                if (comp instanceof ServiceConfigPane) {
                    comp = ((ServiceConfigPane)comp).get();
                }
                if (comp == null || !comp.getClass().getName().equals(clazz.getName())) continue;
                result = (BGUPanel)comp;
                break;
            }
        }
        return result;
    }

    public ServiceConfigTabbedPanel getTab(String className) {
        ServiceConfigTabbedPanel result = null;
        if (this.tabPane instanceof JTabbedPane) {
            JTabbedPane tabPane = (JTabbedPane)this.tabPane;
            int tabCount = tabPane.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                Component comp = tabPane.getComponentAt(i);
                if (comp instanceof ServiceConfigPane) {
                    comp = ((ServiceConfigPane)comp).get();
                }
                if (!comp.getClass().getName().equals(className)) continue;
                result = (ServiceConfigTabbedPanel)comp;
                break;
            }
        } else {
            int size = this.tabPane.getComponentCount();
            for (int i = 0; i < size; ++i) {
                Component comp = this.tabPane.getComponent(i);
                if (comp instanceof ServiceConfigPane) {
                    comp = ((ServiceConfigPane)comp).get();
                }
                if (!comp.getClass().getName().equals(className)) continue;
                result = (ServiceConfigTabbedPanel)comp;
                break;
            }
        }
        return result;
    }

    public void selectTab(String className) {
        JComponent jComponent = this.tabPane;
        if (jComponent instanceof JTabbedPane) {
            JTabbedPane tabPane = (JTabbedPane)jComponent;
            int tabCount = tabPane.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                Component comp = tabPane.getComponentAt(i);
                if (comp instanceof ServiceConfigPane) {
                    comp = ((ServiceConfigPane)comp).get();
                }
                if (!comp.getClass().getName().equals(className)) continue;
                tabPane.setSelectedIndex(i);
                break;
            }
        } else {
            int size = this.tabPane.getComponentCount();
            for (int i = 0; i < size; ++i) {
                Component comp = this.tabPane.getComponent(i);
                if (comp instanceof ServiceConfigPane) {
                    comp = ((ServiceConfigPane)comp).get();
                }
                if (!comp.getClass().getName().equals(className)) continue;
                this.layout.show(this.tabPane, comp.getName());
                break;
            }
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setCloseObject(Object closeObject) {
        this.closeObject = closeObject;
    }

    @Override
    public boolean onClosing() {
        boolean result = true;
        result = this.closeObject instanceof AbstractActionTabbedConfig ? ((AbstractActionTabbedConfig)this.closeObject).onClosing() : super.onClosing();
        ClosedTabs.getInstance().put(this);
        return result;
    }

    public class ServiceConfigPane
    extends JPanel {
        private volatile JPanel panel;
        private String tabIndex;

        private ServiceConfigPane(String tabIndex, String className, boolean run) {
            super(new GridLayout());
            this.tabIndex = tabIndex;
            ClientContext ctx = BGServiceConfig.this.getContext();
            try {
                this.setPanel(this.doInBackgroundImpl(className, ctx));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private JPanel doInBackgroundImpl(String className, ClientContext ctx) throws Exception {
            Class[] constructorSignature = new Class[]{ClientContext.class};
            JPanel panel = null;
            try {
                Class<?> clazz = Class.forName(className);
                try {
                    panel = (JPanel)clazz.getConstructor(constructorSignature).newInstance(ctx);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (panel == null) {
                    panel = (JPanel)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                if (panel instanceof BGUTabPanel) {
                    BGUTabPanel bgPanel = (BGUTabPanel)panel;
                    bgPanel.setTabId(BGServiceConfig.this.getTabId());
                    bgPanel.setTabTitle("config");
                } else if (panel instanceof BGTabPanel) {
                    BGTabPanel bgPanel = (BGTabPanel)panel;
                    bgPanel.init(ctx.getModule(), ctx.getModuleId());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (panel == null) {
                System.err.println("Class not found: " + className);
            }
            return panel;
        }

        private void setPanel(JPanel panel) {
            this.panel = panel;
            this.add(panel);
            this.updateUI();
        }

        public JPanel get() {
            try {
                return this.panel;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public String getTabIndex() {
            return this.tabIndex;
        }
    }
}

