/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import bitel.billing.module.admin.DBInfo;
import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.DBInfoManager;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFactory;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.handler.HandlerResolver;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.PortInfo;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.container.ws.common.WSClient;
import ru.bitel.bgbilling.kernel.container.ws.common.WSLinkedClient;
import ru.bitel.bgbilling.kernel.directory.api.client.ClientDirectoryFactory;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Result;

public class ClientContext
extends WSClient
implements WSLinkedClient,
Cloneable {
    private String module;
    private final int moduleId;
    private final int contractId;
    private String rb_name;
    private Document moduleDoc;
    private int objectId;
    private int customerId;
    private JSONObject customer;
    private Map<String, Object> webServiceMap = new HashMap<String, Object>();
    private static final boolean debug = System.getProperty("bgbilling.transfer.debug", "false").equals("true");
    static final ThreadLocal<Deque<ClientContext>> nestedContext = new ThreadLocal<Deque<ClientContext>>(){

        @Override
        protected Deque<ClientContext> initialValue() {
            return new LinkedList<ClientContext>();
        }
    };
    private static Map<WSClient.WSKey, WSClient.WSService> serviceMap = new ConcurrentHashMap<WSClient.WSKey, WSClient.WSService>();

    public static void push(ClientContext name) {
        nestedContext.get().offer(name);
    }

    public static void pop() {
        nestedContext.get().pollLast();
    }

    public static ClientContext get() {
        return nestedContext.get().peekLast();
    }

    public ClientContext(ClientContext clientContext, String module, int moduleId, String resourceBundleName) {
        super(true);
        this.module = module;
        this.moduleId = moduleId;
        this.contractId = clientContext.getContractId();
        this.rb_name = resourceBundleName;
        if (this.rb_name != null) {
            this.moduleDoc = (Document)ClientSetup.getInstance().getObject(this.rb_name);
        }
        this.objectId = clientContext.getObjectId();
        this.customer = clientContext.getCustomer();
        this.customerId = clientContext.getCustomerId();
    }

    public ClientContext(String module, int moduleId, int contractId, int objectId, String rb_name) {
        super(true);
        this.module = module;
        this.moduleId = moduleId;
        this.contractId = contractId;
        this.rb_name = rb_name;
        this.moduleDoc = (Document)ClientSetup.getInstance().getObject(rb_name);
        this.objectId = objectId;
    }

    public ClientContext(String module, int moduleId, int contractId, String rb_name, Document moduleDoc) {
        super(true);
        this.module = module;
        this.moduleId = moduleId;
        this.contractId = contractId;
        this.rb_name = rb_name;
        this.moduleDoc = moduleDoc;
    }

    public ClientContext(String module, int moduleId, int contractId, String rb_name) {
        super(true);
        this.module = module;
        this.moduleId = moduleId;
        this.contractId = contractId;
        this.rb_name = rb_name;
        this.moduleDoc = ClientUtils.getModuleDoc(rb_name);
    }

    public ClientContext(String module, int moduleId, int contractId, int objectId, Package pkg) {
        super(true);
        this.module = module;
        this.moduleId = moduleId;
        this.contractId = contractId;
        String rb_name = pkg.getName() + ".setup";
        if (rb_name != null) {
            try {
                this.rb_name = rb_name;
                this.module = ClientUtils.getValueFromResourceBundle(rb_name, "module.id");
                this.moduleDoc = ClientUtils.getModuleDoc(rb_name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getModule() {
        return this.module;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public int getContractId() {
        return this.contractId;
    }

    public String getResourceBundleName() {
        return this.rb_name;
    }

    public Document getModuleDoc() {
        return this.moduleDoc;
    }

    public ClientContext clone() {
        return new ClientContext(this.module, this.moduleId, this.contractId, this.rb_name, this.moduleDoc);
    }

    public Request newRequest(String action) {
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.moduleId);
        request.setAction(action);
        if (this.contractId > 0) {
            request.setContractId(this.contractId);
        }
        return request;
    }

    public Document getDocument(Request req) {
        return TransferManager.getDocument(req);
    }

    public InputStream getInputStream(Request req) {
        return TransferManager.getInputStream(req);
    }

    public <K> Result<K> getResponseResult(Request req, Class<K> clazz) {
        try {
            Document doc = TransferManager.getDocument(req);
            if (ClientUtils.checkStatus(doc)) {
                try {
                    Element node = XMLUtils.selectElement(doc, "/data/*[namespace-uri()='http://common.bitel.ru' and local-name()='result']");
                    if (node != null) {
                        return (Result)JAXBContext.newInstance((Class[])new Class[]{clazz, Result.class}).createUnmarshaller().unmarshal((Source)new DOMSource(node), Result.class).getValue();
                    }
                    return null;
                }
                catch (JAXBException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    protected void status(String status, String message) {
        if (status.equals("error")) {
            ClientUtils.showErrorMessageDialog(message);
        } else if (status.equals("message")) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), message, "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
        }
    }

    public <T> T getPort(Class<T> iface) {
        return this.getPort(DBInfoManager.getManager().getActiveDBInfo().getDbServerURL(), iface, null, this.moduleId);
    }

    @Override
    public <T> T getPort(Class<T> iface, int moduleId) {
        return this.getPort(DBInfoManager.getManager().getActiveDBInfo().getDbServerURL(), iface, null, moduleId);
    }

    public <T> T getWebService(Class<T> clazz, int moduleId) {
        String key = clazz.getName() + "_" + moduleId;
        Object webService = this.webServiceMap.get(key);
        if (webService == null) {
            webService = this.getPort(clazz, moduleId);
            this.webServiceMap.put(key, webService);
        }
        return (T)webService;
    }

    public <T> T getWebService(Class<T> clazz) {
        Object webService = this.webServiceMap.get(clazz.getName());
        if (webService == null) {
            webService = this.getPort(clazz);
            this.webServiceMap.put(clazz.getName(), webService);
        }
        return (T)webService;
    }

    @Override
    public HandlerResolver newHandlerResolver(final Service webService) {
        return new HandlerResolver(){

            public List<Handler> getHandlerChain(PortInfo portInfo) {
                ArrayList<Handler> result = new ArrayList<Handler>();
                result.add((Handler)new ServiceAuthenticationSOAPHandler(webService));
                return result;
            }
        };
    }

    public <K extends Id> Directory<K> getDirectory(Class<K> clazz, int moduleId) throws BGException {
        return ClientDirectoryFactory.newDirectory(this, clazz, moduleId, true);
    }

    public <K extends Id> Directory<K> getDirectory(Class<K> clazz) throws BGException {
        return ClientDirectoryFactory.newDirectory(this, clazz, this.moduleId, true);
    }

    public <T> Future<T> getPortFuture(final Class<T> clazz) {
        SwingWorker worker = new SwingWorker<T, Void>(){

            @Override
            protected T doInBackground() throws Exception {
                return ClientContext.this.getPort(clazz);
            }

            @Override
            protected void done() {
            }
        };
        worker.execute();
        return worker;
    }

    public int getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(int customerId) {
        this.customerId = customerId;
    }

    public JSONObject getCustomer() {
        return this.customer;
    }

    public void setCustomer(JSONObject customer) {
        this.customer = customer;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public void setObjectId(int objectId) {
        this.objectId = objectId;
    }

    @Override
    protected WSClient.WSService getService(WSClient.WSKey key) {
        return serviceMap.get(key);
    }

    @Override
    protected void putService(WSClient.WSKey key, WSClient.WSService service) {
        serviceMap.put(key, service);
    }

    class ServiceAuthenticationSOAPHandler
    implements SOAPHandler<SOAPMessageContext> {
        private final Service service;

        ServiceAuthenticationSOAPHandler(Service service) {
            this.service = service;
        }

        public Set<QName> getHeaders() {
            return null;
        }

        public void close(MessageContext context) {
        }

        public boolean handleFault(SOAPMessageContext context) {
            try {
                context.getMessage().writeTo((OutputStream)System.err);
                System.err.println();
            }
            catch (SOAPException | IOException e) {
                e.printStackTrace();
            }
            return true;
        }

        public boolean handleMessage(SOAPMessageContext context) {
            try {
                boolean outbound = (Boolean)context.get((Object)"jakarta.xml.ws.handler.message.outbound");
                if (outbound) {
                    QName operation = (QName)context.get((Object)"jakarta.xml.ws.wsdl.operation");
                    System.err.println();
                    System.err.println(this.service.getWSDLDocumentLocation() + " -> " + context.get((Object)"jakarta.xml.ws.wsdl.service") + (String)(operation != null ? ":" + operation.getLocalPart() : ""));
                    if (debug && context.getMessage().countAttachments() == 0 && (operation == null || !operation.getLocalPart().contains("File"))) {
                        System.err.print("-> ");
                        context.getMessage().writeTo((OutputStream)System.err);
                        System.err.println();
                    }
                    DBInfo dbInfo = DBInfoManager.getManager().getActiveDBInfo();
                    SOAPEnvelope se = context.getMessage().getSOAPPart().getEnvelope();
                    SOAPHeader sh = se.getHeader();
                    if (sh == null) {
                        sh = se.addHeader();
                    }
                    SOAPFactory soapFactory = SOAPFactory.newInstance();
                    SOAPElement auth = soapFactory.createElement("auth", "", "http://ws.base.kernel.bgbilling.bitel.ru/");
                    auth.setAttribute("user", dbInfo.getDbServerLogin());
                    auth.setAttribute("pswd", dbInfo.getDbServerPassword());
                    sh.addChildElement(auth);
                } else {
                    SOAPEnvelope se;
                    SOAPHeader sh;
                    List messageList;
                    Map map;
                    Object message;
                    if (debug && context.getMessage().countAttachments() == 0) {
                        System.err.print("<- ");
                        context.getMessage().writeTo((OutputStream)System.err);
                        System.err.println();
                    }
                    if ((message = (map = (Map)context.get((Object)"jakarta.xml.ws.http.response.headers")).get("bgbilling-error")) != null) {
                        messageList = (List)message;
                        SwingUtilities.invokeLater(() -> {
                            for (Object m : messageList) {
                                ClientUtils.showErrorMessageDialog(String.valueOf(m));
                            }
                        });
                    }
                    if ((message = map.get("bgbilling-message")) != null) {
                        messageList = (List)message;
                        SwingUtilities.invokeLater(() -> {
                            for (Object m : messageList) {
                                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), String.valueOf(m), "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
                            }
                        });
                    }
                    if ((sh = (se = context.getMessage().getSOAPPart().getEnvelope()).getHeader()) != null) {
                        NodeList nodes = sh.getChildNodes();
                        int size = nodes.getLength();
                        for (int i = 0; i < size; ++i) {
                            Node node = nodes.item(i);
                            if (node.getNodeType() != 1 || !"message".equals(node.getNodeName())) continue;
                            String msg = String.valueOf(node.getTextContent());
                            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), msg, "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1));
                        }
                    }
                }
            }
            catch (SOAPException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
    }
}

