/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.directory.address;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import bitel.billing.module.contract.directory.AddressList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.directory.address.AddressEditorPanelBase;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;

public class HouseEditorPanel
extends AddressEditorPanelBase {
    public BGComboBox<ComboBoxItem> area;
    public BGComboBox<ComboBoxItem> quarter;
    public JTextArea comment;
    public IntTextField box_index;
    public IntTextField amount;
    private String dt = null;
    private int streetId = -1;
    private AddressList areasList = null;
    private AddressList quartersList = null;

    @Override
    protected JPanel getExtraPanel() {
        this.area = new BGComboBox();
        this.quarter = new BGComboBox();
        this.comment = new JTextArea();
        this.box_index = new IntTextField(6);
        this.amount = new IntTextField();
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel areaPanel = new JPanel(new GridBagLayout());
        JPanel quarterPanel = new JPanel(new GridBagLayout());
        JPanel box_indexPanel = new JPanel(new GridBagLayout());
        JPanel amountPanel = new JPanel(new GridBagLayout());
        JPanel commentPanel = new JPanel(new GridBagLayout());
        areaPanel.setBorder(new BGTitleBorder(" \u0420\u0430\u0439\u043e\u043d "));
        quarterPanel.setBorder(new BGTitleBorder(" \u041a\u0432\u0430\u0440\u0442\u0430\u043b "));
        box_indexPanel.setBorder(new BGTitleBorder(" \u0418\u043d\u0434\u0435\u043a\u0441 "));
        amountPanel.setBorder(new BGTitleBorder(" \u041a\u0432\u0430\u0440\u0442\u0438\u0440 "));
        commentPanel.setBorder(new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "));
        this.comment.setOpaque(true);
        this.comment.setText("");
        this.comment.setLineWrap(true);
        this.comment.setRows(2);
        this.comment.setWrapStyleWord(true);
        this.box_index.setMinimumSize(new Dimension(70, 24));
        this.box_index.setPreferredSize(new Dimension(59, 24));
        this.box_index.setHorizontalAlignment(0);
        this.box_index.setMaxValue(999999L);
        this.amount.setMinimumSize(new Dimension(37, 24));
        this.amount.setPreferredSize(new Dimension(59, 24));
        this.amount.setColumns(3);
        panel.add((Component)areaPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        areaPanel.add(this.area, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)quarterPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        quarterPanel.add(this.quarter, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)box_indexPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        box_indexPanel.add((Component)this.box_index, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)amountPanel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        amountPanel.add((Component)this.amount, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)commentPanel, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        commentPanel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    @Override
    protected void getExtraParams(Document doc) {
        this.areasList = new AddressList(XMLUtils.selectNode(doc, "/data/areas"));
        this.quartersList = new AddressList(XMLUtils.selectNode(doc, "/data/quarters"));
        Element el = XMLUtils.selectElement(doc, "//data/param");
        this.areasList.buildComboBox(this.area, this.getCityId(), false, true, el.getAttribute("areaId"));
        this.quartersList.buildComboBox(this.quarter, this.getCityId(), false, true, el.getAttribute("quarterId"));
        this.comment.setText(el.getAttribute("comment"));
        this.amount.setText(el.getAttribute("amount"));
        this.box_index.setText(el.getAttribute("boxIndex"));
        this.streetId = Utils.parseInt(el.getAttribute("streetId"), this.streetId);
        this.dt = el.getAttribute("date");
    }

    @Override
    public void setItemId(int itemId) {
        super.setItemId(itemId);
        this.streetId = itemId;
    }

    @Override
    protected String getLoadAction() {
        return "HouseEditor";
    }

    @Override
    protected String getSaveAction() {
        return "UpdateAddressHouse";
    }

    @Override
    protected String getTitleLabelText() {
        return "\u0414\u043e\u043c/\u0434\u0440\u043e\u0431\u044c:";
    }

    @Override
    protected void titleKeyReleased(KeyEvent event) {
        String index = null;
        if (this.streetId > 0) {
            try {
                index = this.getContext().getPort(AddressService.class, 0).postIndexGet(this.streetId, this.getTitle(), 0, null);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
        this.box_index.setText(Utils.maskNull(index));
    }

    @Override
    protected void setExtraParams(Request request) {
        request.setAttribute("addressType", "house");
        request.setAttribute("houseAndFrac", this.getTitle());
        request.setAttribute("quarterid", this.quarter.getSelectedItem().getObject());
        request.setAttribute("areaid", this.area.getSelectedItem().getObject());
        request.setAttribute("comment", this.comment.getText());
        request.setAttribute("amount", this.amount.getText());
        request.setAttribute("box_index", this.box_index.getText());
        request.setAttribute("dt", this.dt);
    }
}

