/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.runner;

import ru.bitel.bgbilling.client.runner.BGClientRunnerCipher;
import ru.bitel.bgbilling.client.runner.json.JSONObject;

public class BGClientRunnerDbInfo {
    protected static final String KEY_KEY = "key";
    protected static final String KEY_FAVORITE = "favorite";
    protected static final String KEY_SAFE = "safe";
    protected static final String KEY_JAVA_HOME = "javaHome";
    protected static final String KEY_PROXY_PORT = "proxyPort";
    protected static final String KEY_PROXY_HOST = "proxyHost";
    protected static final String KEY_AUTH = "auth";
    protected static final String KEY_URL = "url";
    protected static final String KEY_TITLE = "title";
    protected static final String KEY_TYPE = "type";
    protected static final String KEY_VM_ARGS = "VMArgs";
    private String dbServerKey = null;
    private String dbServerTitle = null;
    private String dbServerURL = null;
    private String dbServerJavaHome = null;
    private String dbServerProxyHost = null;
    private String dbServerProxyPort = null;
    private String dbServerLogin = null;
    private String dbServerPassword = null;
    private String dbServerType = null;
    private String dbServerVMArgs = null;
    private boolean favorite = false;
    private boolean safe = false;

    public void setProxy() {
        System.getProperties().setProperty("proxySet", "false");
        if (this.dbServerProxyHost != null && this.dbServerProxyHost.trim().length() > 0 && this.dbServerProxyPort != null && this.dbServerProxyPort.trim().length() > 0) {
            System.getProperties().put("proxySet", "true");
            System.getProperties().put(KEY_PROXY_HOST, this.dbServerProxyHost);
            System.getProperties().put(KEY_PROXY_PORT, this.dbServerProxyPort);
        }
    }

    public String getDbServerKey() {
        return this.dbServerKey;
    }

    public void setDbServerKey(String dbServerKey) {
        this.dbServerKey = dbServerKey;
    }

    public String getDbServerTitle() {
        return this.dbServerTitle;
    }

    public void setDbServerTitle(String dbServerTitle) {
        this.dbServerTitle = dbServerTitle;
    }

    public String getDbServerURL() {
        return this.dbServerURL;
    }

    public void setDbServerURL(String dbServerURL) {
        this.dbServerURL = dbServerURL;
    }

    public String getDbServerJavaHome() {
        return this.dbServerJavaHome;
    }

    public void setDbServerJavaHome(String dbServerJavaHome) {
        this.dbServerJavaHome = dbServerJavaHome;
    }

    public String getDbServerProxyHost() {
        return this.dbServerProxyHost;
    }

    public void setDbServerProxyHost(String dbServerProxyHost) {
        this.dbServerProxyHost = dbServerProxyHost;
    }

    public String getDbServerProxyPort() {
        return this.dbServerProxyPort;
    }

    public void setDbServerProxyPort(String dbServerProxyPort) {
        this.dbServerProxyPort = dbServerProxyPort;
    }

    public String getDbServerLogin() {
        return this.dbServerLogin;
    }

    public void setDbServerLogin(String dbServerLogin) {
        this.dbServerLogin = dbServerLogin;
    }

    public String getDbServerPassword() {
        return this.dbServerPassword;
    }

    public void setDbServerPassword(String dbServerPassword) {
        this.dbServerPassword = dbServerPassword;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public void setFavorite(boolean favorite) {
        this.favorite = favorite;
    }

    public String getDbServerType() {
        return this.dbServerType;
    }

    public void setDbServerType(String dbServerType) {
        this.dbServerType = dbServerType;
    }

    public String getDbServerVMArgs() {
        return this.dbServerVMArgs;
    }

    public void setDbServerVMArgs(String dbServerVMArgs) {
        this.dbServerVMArgs = dbServerVMArgs;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public void setSafe(boolean safe) {
        this.safe = safe;
    }

    public String toString() {
        return this.getDbServerTitle() != null ? this.getDbServerTitle() : "-";
    }

    public static BGClientRunnerDbInfo parseBGClientRunnerDbInfoFromJson(JSONObject jsonObject) {
        BGClientRunnerDbInfo bgClientRunnerDbInfo = null;
        if (jsonObject != null) {
            bgClientRunnerDbInfo = new BGClientRunnerDbInfo();
            bgClientRunnerDbInfo.setDbServerKey(jsonObject.optString(KEY_KEY, ""));
            bgClientRunnerDbInfo.setDbServerTitle(jsonObject.optString(KEY_TITLE, ""));
            bgClientRunnerDbInfo.setDbServerURL(jsonObject.optString(KEY_URL, ""));
            bgClientRunnerDbInfo.setDbServerJavaHome(jsonObject.optString(KEY_JAVA_HOME, ""));
            bgClientRunnerDbInfo.setDbServerProxyHost(jsonObject.optString(KEY_PROXY_HOST, ""));
            bgClientRunnerDbInfo.setDbServerProxyPort(jsonObject.optString(KEY_PROXY_PORT, ""));
            bgClientRunnerDbInfo.setDbServerType(jsonObject.optString(KEY_TYPE, null));
            bgClientRunnerDbInfo.setDbServerVMArgs(jsonObject.optString(KEY_VM_ARGS, ""));
            bgClientRunnerDbInfo.setFavorite(Boolean.valueOf(jsonObject.optString(KEY_FAVORITE, "false")));
            bgClientRunnerDbInfo.setSafe(Boolean.valueOf(jsonObject.optString(KEY_SAFE, "false")));
            String auth = jsonObject.optString(KEY_AUTH, null);
            if (auth != null) {
                String[] loginPassword = BGClientRunnerCipher.cipher(auth, true).split("\t");
                bgClientRunnerDbInfo.setDbServerLogin(loginPassword[0]);
                bgClientRunnerDbInfo.setDbServerPassword(loginPassword[1]);
            }
        }
        return bgClientRunnerDbInfo;
    }

    public JSONObject toJsonObject() {
        JSONObject serverJSONObject = new JSONObject();
        serverJSONObject.put(KEY_KEY, this.getDbServerKey());
        serverJSONObject.put(KEY_TITLE, this.getDbServerTitle());
        serverJSONObject.put(KEY_URL, this.getDbServerURL());
        serverJSONObject.put(KEY_JAVA_HOME, this.getDbServerJavaHome());
        serverJSONObject.put(KEY_PROXY_HOST, this.getDbServerProxyHost());
        serverJSONObject.put(KEY_PROXY_PORT, this.getDbServerProxyPort());
        serverJSONObject.put(KEY_TYPE, this.getDbServerType());
        serverJSONObject.put(KEY_VM_ARGS, this.getDbServerVMArgs());
        serverJSONObject.put(KEY_FAVORITE, String.valueOf(this.isFavorite()));
        serverJSONObject.put(KEY_SAFE, String.valueOf(this.isSafe()));
        if (this.isSafe()) {
            serverJSONObject.put(KEY_AUTH, BGClientRunnerCipher.cipher(this.getDbServerLogin() + "\t" + this.getDbServerPassword(), false));
        }
        return serverJSONObject;
    }
}

